/*
Copyright 1990-2008 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#include <jni.h>
#include <stdio.h>
#include "iiimvkb.h"
#include "com_sun_g11n_vkb_iiim_IIIMInterface_Impl.h"

JNIEXPORT void JNICALL Java_com_sun_g11n_vkb_iiim_IIIMInterface_1Impl_sendIIIMText (JNIEnv * env, jobject obj, jstring text) {
  const char * cstring = (*env)->GetStringUTFChars(env, text, JNI_FALSE);
  const jchar * jchars = (*env)->GetStringChars(env, text, JNI_FALSE);
  jsize len = (*env)->GetStringLength(env, text);
  cf_send_text (jchars, len, cstring); /* cstring is for debug */
}

JNIEXPORT void JNICALL Java_com_sun_g11n_vkb_iiim_IIIMInterface_1Impl_sendIIIMKeyEvent (JNIEnv * env, jobject obj, jint code, jint ch, jint modifier, jint time_stamp) {
  cf_send_key (code, ch, modifier, time_stamp);
}

JNIEXPORT void JNICALL Java_com_sun_g11n_vkb_iiim_IIIMInterface_1Impl_syncIIIMKeyboard (JNIEnv * env, jobject obj, jstring text) {
  const char * cstring = (*env)->GetStringUTFChars(env, text, JNI_FALSE);
  cf_synchronize_keyboard (cstring);
}

JNIEXPORT void JNICALL Java_com_sun_g11n_vkb_iiim_IIIMInterface_1Impl_resetSyncIIIMKeyboard (JNIEnv * env, jobject obj) {
  cf_reset_synchronize_keyboard ();
}

JNIEXPORT void JNICALL Java_com_sun_g11n_vkb_iiim_IIIMInterface_1Impl_invokeGNOMENativeHelp (JNIEnv *env, jobject obj) {
  cf_invoke_native_help ();
}
