/*
Copyright 1990-2008 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#include <limits.h>
#include <stdlib.h>
#include <strings.h>
#include <locale.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>

#include "iiimvkb.h"

static int initialized = FALSE;
static IIIMCF_handle iiim;
static IIIMCF_context context = NULL;
static IIIMF_status st;

static Display *display = NULL;

static IIIMP_card16 AUX_NAME[] = {'I', 'I', 'I', 'M', '_', 'V', 'K', 'B', 0};
static const IIIMP_card16 *TEXT_STORE[1];
static const IIIMP_card32 INT_STORE[] = {0};
static Atom iiim_settings_atom = None;
static Atom iiim_desktop_lang_atom = None;

BOOL iiim_prop_ok = FALSE;
IIIMSettings *orig_iiim_settings;
IIIMSettings *mod_iiim_settings;
char *orig_desktop_lang = NULL;

/* exported functions : cf_send_text, cf_send_key */

static BOOL create_context () {
  IIIMCF_attr attr;
  int n_lang;
  IIIMCF_language *lang_list;
  IIIMCF_event event;
  int i;
  char *lang, *lang2, *p;

  st = iiimcf_create_attr (&attr);
  if (st != IIIMF_STATUS_SUCCESS) {
    return FALSE;
  }

  iiimcf_get_supported_languages (iiim, &n_lang, &lang_list);
  if (!lang_list) {
    return FALSE;
  }

  lang = strdup (setlocale (LC_CTYPE, NULL));
  p = strchr (lang, '.');
  if (p) *p = '\0';

  /* for ko_KR.UTF-8 locale */
  lang2 = strdup (lang);
  p = strchr (lang2, '_');
  if (p) *p = '\0';

  for (i=0; i < n_lang; i++) {
    char *langid;

    iiimcf_get_language_id (lang_list[i], (const char **)&langid);
    if (!strncmp (lang, langid, strlen (lang)) ||
	!strncmp (lang2, langid, strlen (lang2)))
      break;
  }

  free (lang);
  free (lang2);

  /* use the first available language engine if lang isn't matched */
  if (i == n_lang) i = 0;

  iiimcf_attr_put_ptr_value (attr, IIIMCF_ATTR_INPUT_LANGUAGE,
			     lang_list[i]);

  st = iiimcf_create_context (iiim, attr, &context);
  if (st != IIIMF_STATUS_SUCCESS) {
    return FALSE;
  }

  iiimcf_destroy_attr (attr);

  /* create dummy ic focus event in order to get the hotkey profile
     event from server - dirty hack */
  iiimcf_create_seticfocus_event (&event);

  iiimcf_forward_event (context, event);

  return TRUE;
}

static BOOL cf_init() {
  IIIMCF_attr attr = NULL;
  IIIMF_status st;

  if (initialized == TRUE) {
    return TRUE;
  }
  st = iiimcf_initialize (IIIMCF_ATTR_NULL);
  if (st != IIIMF_STATUS_SUCCESS) {
    return FALSE;
  }

  st = iiimcf_create_attr (&attr);
  if (st != IIIMF_STATUS_SUCCESS) {
    return FALSE;
  }

  st = iiimcf_attr_put_string_value (attr, IIIMCF_ATTR_CLIENT_TYPE,
				     "GTK IIIMCF Module");
  if (st != IIIMF_STATUS_SUCCESS) {
    return FALSE;
  }

  display = XOpenDisplay (NULL);

  st = iiimcf_attr_put_string_value (attr, IIIMCF_ATTR_CLIENT_X_DISPLAY_NAME,
				     XDisplayString (display));
  if (st != IIIMF_STATUS_SUCCESS) {
    return FALSE;
  }

  {
    Atom iiimd;
    Atom client_group;
    Window iiimx;
    char path[PATH_MAX];
    char client_group_id[PATH_MAX];

    iiimd = XInternAtom (display, "IIIM_SERVER", True);
    if (iiimd != None) {
      iiimx = XGetSelectionOwner (display, iiimd);
      if (iiimx != None) {
	Atom type;
	int format;
	unsigned long length;
	unsigned long nitem;
	unsigned char *data;
	data = NULL;
	XGetWindowProperty (display, iiimx, iiimd,
			    0, INT_MAX, False, XA_STRING,
			    &type, &format, &nitem, &length, &data);
	if (data != NULL && !strncmp ("uds:", (char *)data, 4)) {
	  strncpy (path, (char *)data + 4, sizeof (path));
	  path[(sizeof (path)) - 1] = '\0';
	  XFree (data);
	  st = iiimcf_attr_put_string_value (attr,
					     IIIMCF_ATTR_SERVER_ADDRESS,
					     path);
	  if (st != IIIMF_STATUS_SUCCESS) {
	    return FALSE;
	  }
	  st = iiimcf_attr_put_string_value (attr,
					     IIIMCF_ATTR_SERVER_SERVICE,
					     "");
	  if (st != IIIMF_STATUS_SUCCESS) {
	    return FALSE;
	  }
	}
      }
    }
    client_group = XInternAtom (display, "IIIM_CLIENT_GROUP", True);
    if (client_group != NULL) {
      iiimx = XGetSelectionOwner (display, client_group);
      if (iiimx != None) {
	Atom type;
	int format;
	unsigned long length;
	unsigned long nitem;
	unsigned char *data;
	data = NULL;
	XGetWindowProperty (display, iiimx, client_group,
			    0, INT_MAX, False, XA_STRING,
			    &type, &format, &nitem, &length, &data);
	if (data != NULL) {
	  strncpy (client_group_id, (char *)data, sizeof (client_group_id));
	  path[(sizeof (client_group_id)) - 1] = '\0';
	  XFree (data);
	  st = iiimcf_attr_put_string_value (attr,
					     IIIMCF_ATTR_CLIENT_GROUP,
					     client_group_id);
	  if (st != IIIMF_STATUS_SUCCESS) {
	    return FALSE;
	  }
	}
      }
    }
  }
  st = iiimcf_create_handle (attr, &iiim);
  if (st != IIIMF_STATUS_SUCCESS) {
    return FALSE;
  }

  if (create_context () == FALSE) {
    return FALSE;
  }

  orig_iiim_settings = (IIIMSettings *)malloc(sizeof (IIIMSettings));
  mod_iiim_settings = (IIIMSettings *)malloc(sizeof (IIIMSettings));
  memset (orig_iiim_settings, 0, sizeof (IIIMSettings));
  memset (mod_iiim_settings, 0, sizeof (IIIMSettings));

  iiim_settings_atom = XInternAtom (display, "_IIIM_SETTINGS", False);
  iiim_desktop_lang_atom = XInternAtom (display, "_IIIM_SWITCHER_DESKTOP_INPUT_LANGUAGE", False);

  /* initialize gnome for help */
  

  initialized = TRUE;
  return TRUE;
}

static void notify_iiimcf_to_read_message () {
  Atom vkb_target_atom = XInternAtom(display, "_IIIM_VKB_TARGET", True);
  XClientMessageEvent event;
  Window win;
  if (vkb_target_atom == None)
    /* there is no target window */
    return;

  win = XGetSelectionOwner(display, vkb_target_atom);

  event.type = ClientMessage;
  event.serial = 0;
  event.send_event = True;
  event.display = display;
  event.window = win;
  event.message_type = vkb_target_atom;
  event.format = 8;

  XSendEvent (display, win, True, 0, (XEvent *)&event);
  XFlush(display);
}


void cf_send_text (const IIIMP_card16 *text, int len, const char *text8) {
  IIIMCF_event event;

  if (cf_init() == FALSE) {
    fprintf (stderr, "IIIM initialization failed. Please check IIIM server 'iiimd' is runnning.\n");
    return;
  }
  /* iiim(IIICF_handle), context(IIIMCF_context) are ready to use */

  TEXT_STORE[0] = text;
  st = iiimcf_create_aux_setvalues_event(AUX_NAME, 0, 1, INT_STORE, 1, TEXT_STORE, &event);
  if (st != IIIMF_STATUS_SUCCESS) {
    fprintf (stderr, " somthing wrong at create aux event. (%d)\n", st);
    return;
  }
  st = iiimcf_forward_event_with_operations (context, event, IIIMCF_SEND_STRING_TO_PREV_FOCUSED);
  /*
  st = iiimcf_forward_event(context, event);
  */
  if (st != IIIMF_STATUS_SUCCESS) {
    fprintf (stderr, " somthing wrong at forward event. (%d)\n", st);
    return;
  }

  /* notify gcf/xcf to retrieve committed string */

  notify_iiimcf_to_read_message();
}

void cf_send_key (const int code, const int ch, const int modifier, const int time_stamp) {
  IIIMCF_event event;

  if (cf_init() == FALSE) {
    fprintf (stderr, "IIIM initialization failed. Please check IIIM server 'iiimd' is runnning.\n");
    return;
  }
  /* iiim(IIICF_handle), context(IIIMCF_context) are ready to use */
  {
    IIIMCF_keyevent kev;
    IIIMCF_event pev;

    kev.keycode = code;
    kev.keychar = ch;
    kev.modifier = modifier;
    kev.time_stamp = time_stamp; /* not used in iiim I guess... */

    st = iiimcf_create_keyevent (&kev, &pev);
    if (st != IIIMF_STATUS_SUCCESS) {
      fprintf (stderr, " something wrong at create key event. (%d)\n", st);
      return;
    }

    st = iiimcf_forward_event_with_operations (context, pev, IIIMCF_SEND_KEYEVENT_TO_PREV_FOCUSED);
    if (st != IIIMF_STATUS_SUCCESS) {
      fprintf (stderr, " something wrong at forward key event. (%d)\n", st);
      return;
    }
  }

  notify_iiimcf_to_read_message();
}

static BOOL getIIIMSettings () {
  Atom type;
  unsigned long *data = NULL;
  int format;
  unsigned long length = 0, bytes_after;

  if (orig_iiim_settings == NULL || mod_iiim_settings == NULL) {
    return FALSE;
  }

  if (iiim_settings_atom == None) {
    fprintf (stderr, "iiimd is not running.\n");
    return FALSE;
  }
  if (XGetWindowProperty (display, RootWindow (display, DefaultScreen (display)),
			  iiim_settings_atom, 0L, 1000000L,
			  False, AnyPropertyType, &type, &format,
			  &length, &bytes_after, (unsigned char **)&data) == Success &&
      data != NULL) {
    orig_iiim_settings->lang_switch_policy = *(data + 0);
    orig_iiim_settings->on_off_policy = *(data + 1);
    orig_iiim_settings->kbd_layout = *(data + 2);
    orig_iiim_settings->sync_activation = *(data + 3);
    orig_iiim_settings->remember_last_le = *(data + 4);
    XFree (data);
    data = NULL;

    if (XGetWindowProperty (display, RootWindow (display, DefaultScreen (display)),
			    iiim_desktop_lang_atom, 0L, 1000000L,
			    False, AnyPropertyType, &type, &format,
			    &length, &bytes_after, (unsigned char **)&data) == Success &
	data != NULL) {
      orig_desktop_lang = strdup ((const char *)data);
      XFree (data);
    }

    return TRUE;
  }

  fprintf (stderr, "iiim-keyboard: get iiim property fails.\n");

  return FALSE;
}

static void setIIIMSettings (IIIMSettings *data) {
  XChangeProperty (display, RootWindow (display, DefaultScreen (display)),
		   iiim_settings_atom, iiim_settings_atom,
		   32, PropModeReplace, (unsigned char *)data,
		   (sizeof (IIIMSettings) / sizeof (int)));

}

static void setLanguageProperty (const char *name) {

  int len, append_engine = 0;
  char *langbuf;

  if (iiim_desktop_lang_atom == None) {
    fprintf (stderr, "iiimd is not running.\n");
    return;
  }

  if (strstr (name, ":") == NULL) {
    len = strlen(name) + strlen("unitle") + 2;
    append_engine = 1;
  } else {
    len = strlen(name) + 1;
  }

  langbuf = malloc (sizeof (char) * len);
  if (langbuf == NULL) {
    fprintf (stderr, "memory allocation error at switch language to %s\n", name);
    return;
  }

  strcpy (langbuf, name);
  if (append_engine) {
    strcat (langbuf, ":");
    strcat (langbuf, "unitle");
  }

  XChangeProperty (display, RootWindow (display, DefaultScreen (display)),
		   iiim_desktop_lang_atom, iiim_desktop_lang_atom,
		   8, PropModeReplace, (unsigned char *)langbuf, len);
  XFlush (display);
  fprintf(stderr, "atom (%d) is now %s\n", iiim_desktop_lang_atom, langbuf);
  free (langbuf);

}

void cf_synchronize_keyboard (const char *name) {
  fprintf (stderr, " Sync with layout : %s !\n", name);
  fflush (stderr);

  if (cf_init() == FALSE) {
    fprintf (stderr, "IIIM initialization failed. Please check IIIM server 'iiimd' is runnning.\n");
    return;
  }

  if (iiim_prop_ok == FALSE) {
    if (getIIIMSettings() == FALSE) {
      /* if getIIIMSettings returns FALSE, iiimd is not running correctly
	 so these opration can not be done. */
      iiim_prop_ok = FALSE;
      return;
    }

    iiim_prop_ok = TRUE;
    mod_iiim_settings->lang_switch_policy = LS_DESKTOP;
    mod_iiim_settings->on_off_policy = OO_ACTIVATE;
    mod_iiim_settings->kbd_layout = orig_iiim_settings->kbd_layout;
    mod_iiim_settings->sync_activation = IM_ON;
    mod_iiim_settings->remember_last_le = orig_iiim_settings->remember_last_le;

    setIIIMSettings(mod_iiim_settings);
  }
  /* set input language to new one */
  setLanguageProperty (name);
}

void cf_reset_synchronize_keyboard () {

  if (cf_init() == FALSE) {
    fprintf (stderr, "IIIM initialization failed. Please check IIIM server 'iiimd' is runnning.\n");
    return;
  }

  if (iiim_settings_atom == None) {
    /* if this atom is not interned, then we do not need to do anything here. */
    return;
  }

  if (iiim_prop_ok == FALSE) {
    return;
  }
  /* back iiim properties & desktop_lang to the original state. */
  setIIIMSettings(orig_iiim_settings);
  if (orig_desktop_lang) {
    fprintf (stderr, " orig desk = %s\n", orig_desktop_lang);
    fflush (stderr);
    setLanguageProperty(orig_desktop_lang);
  }
  iiim_prop_ok = FALSE;
}

void cf_invoke_native_help () {

  gnome_help_display ("iiim-keyboard.xml", NULL, NULL);

  fprintf (stderr, " Invoke GNOME help \n");
  fflush (stderr);
}
