/*
Copyright 1990-2008 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.sun.g11n.vkb.geom.xml;

import com.sun.g11n.vkb.geom.*;
import static com.sun.g11n.vkb.geom.xml.XMLGeometryWriter.*;

import org.xml.sax.Attributes;
import org.xml.sax.helpers.*;

import java.util.*;
import java.awt.geom.Point2D;

/**
 *
 * @author naoyuki
 */
public class SAXHandler extends DefaultHandler  {

    private Set<Geometry> geoms;
    private XMLGeometry geometry;
    private String charData;
    private Map<String, KeyShape> shapeMap;
    private Map<String, KeySection> sectionMap;
    private Mode mode;
    private KeyShape keyShape;
    private KeySection keySection;
    private KeyRow keyRow;
    private KeyInfo keyInfo;

    SAXHandler(Set<Geometry> geoms) {
        this.geoms = geoms;
        charData = null;
        mode = Mode.ROOT;
    }
        
    @Override public void startDocument() {
    }
    @Override public void endDocument() {
    }
    @Override public void startElement(String uri, String localName, String qName, Attributes attributes) {
        switch(mode) {
            case ROOT: {
                if (qName.startsWith(ROOT)) {
                    geometry = new XMLGeometry();
                    sectionMap = new HashMap<String, KeySection>();
                } else if (qName.equals(SHAPEMAP)) {
                    shapeMap = new HashMap<String, KeyShape>();
                    mode = Mode.SHAPEMAP;
                } else if (qName.equals(SECTION)) {
                    String value = attributes.getValue(NAME);
                    keySection = new KeySection(value);
                    mode = Mode.SECTION;
                }
                break;
            }
            case SHAPEMAP: {
                if (qName.equals(SHAPE)) {
                    keyShape = new KeyShape(attributes.getValue(NAME));
                    String value = attributes.getValue(CORNERRADIUS);
                    if (value != null) {
                        keyShape.setCornerRadius(toInt(value));
                    }
                    value = attributes.getValue(WIDTH);
                    if (value != null) {
                        keyShape.setWidth(toFloat(value));
                    }
                    value = attributes.getValue(HEIGHT);
                    if (value != null) {
                        keyShape.setHeight(toFloat(value));
                    }
                    mode = Mode.SHAPE;
                }
                break;
            }
            case SECTION: {
                if (qName.equals(ROW)) {
                    keyRow = new KeyRow();
                    mode = Mode.ROW;
                }
                break;
            }
            case ROW: {
                if (qName.equals(KEY)) {
                    keyInfo = new KeyInfo();
                    String value = attributes.getValue(NAME);
                    if (value != null) {
                        keyInfo.setLabel(value);
                    }
                    value = attributes.getValue(COLOR);
                    if (value != null) {
                        keyInfo.setColor(value);
                    }
                    value = attributes.getValue(SHAPE);
                    if (value != null) {
                        keyInfo.setShapeName(value);
                    }
                    value = attributes.getValue(GAP);
                    if (value != null) {
                        keyInfo.setGap(toFloat(value));
                    }
                }           
                break;
            }
        }
    }
    
    @Override public void endElement(String uri, String localName, String qName) {
        switch(mode) {
            case ROOT: {
                if (qName.equals(ROOT)) {
                    geometry.setSectionMap(sectionMap);
                    geoms.add(geometry);
                } else if (qName.equals(DESC)) {
                    geometry.setDescription(charData);
                } else if (qName.equals(WIDTH)) {
                    geometry.setWidth(toFloat(charData));
                } else if (qName.equals(HEIGHT)) {
                    geometry.setHeight(toFloat(charData));
                } else if (qName.equals(SHAPE)) {
                    geometry.setDefaultShapeName(charData);
                } else if (qName.equals(SECTION_LEFT)) {
                    geometry.setSectionLeft(toFloat(charData));
                } else if (qName.equals(ROW_LEFT)) {
                    geometry.setRowLeft(toFloat(charData));
                } else if (qName.equals(GAP)) {
                    geometry.setDefaultGap(toFloat(charData));
                }
                break;
            }
            case SHAPEMAP: {
                if (qName.equals(SHAPEMAP)) {
                    geometry.setShapeMap(shapeMap);
                    mode = Mode.ROOT;
                }
                break;
            }
            case SHAPE: {
                if (qName.equals(SHAPE)) {
                    shapeMap.put(keyShape.getName(), keyShape);
                    mode = Mode.SHAPEMAP;
                } else if (qName.equals(POINTS)) {
                    keyShape.addOutline(toPoints(charData));
                }
                break;
            }
            case SECTION: {
                if (qName.equals(SECTION)) {
                    sectionMap.put(keySection.getName(), keySection);
                    mode = Mode.ROOT;
                } else if (qName.equals(TOP)) {
                    keySection.setTop(toFloat(charData));
                } else if (qName.equals(LEFT)) {
                    keySection.setLeft(toFloat(charData));
                } else if (qName.equals(SHAPE)) {
                    keySection.setShapeName(charData);
                }
                break;
            }
            case ROW: {
                if (qName.equals(TOP)) {
                    keyRow.setTop(toFloat(charData));
                } else if (qName.equals(KEY)) {
                    keyRow.addKeyInfo(keyInfo);
                } else if (qName.equals(SHAPE)) {
                    keyRow.setShapeName(charData);
                } else if (qName.equals(ROW)) {
                    keySection.addRow(keyRow);
                    mode = mode.SECTION;
                }
                break;
            }
        }
    }
    
    @Override public void characters(char[] ch, int start, int length) {
        charData = new String(ch, start, length);
    }
    
    private static float toFloat(String str) {
        float f;
        try {
            f = Float.parseFloat(str);
        } catch(Exception e) {
            f = 0;
        }
        return f;
    }
    
    private static int toInt(String str) {
        int i;
        try {
            i = Integer.parseInt(str);
        } catch(Exception e) {
            i = 0;
        }
        return i;
    }
    
    private static List<Point2D.Float> toPoints(String str) {
        List<Point2D.Float> points = new ArrayList<Point2D.Float>();
        StringTokenizer st = new StringTokenizer(str, ",");
        try {
            for (; st.hasMoreTokens();) {
                // if data is not set of x,y, then exception will occur
                String xs = st.nextToken();
                String ys = st.nextToken();
                Point2D.Float f = new Point2D.Float(toFloat(xs), toFloat(ys));
                points.add(f);
            }
        } catch (Exception e) {
            e.printStackTrace();
            com.sun.g11n.vkb.Main.error ("Point data is currupted in xml.");
        }
        return points;
    }
    
    enum Mode {
        ROOT, SHAPEMAP, SHAPE, SECTION, ROW, KEY, 
    }
}
