/*
Copyright 1990-2008 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.sun.g11n.vkb;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

import com.sun.g11n.vkb.sym.Symbol;
import com.sun.g11n.vkb.geom.Geometry;
/**
 *
 * @author naoyuki
 */
public class StandAloneKeyboardFrame extends JFrame implements KeyboardFrame, FocusListener {

    private KeyboardFrameCommonData cdata;

    public StandAloneKeyboardFrame(KeyboardFrameCommonData cdata) {
        super(cdata.getKBDTitle());
        enableInputMethods(false);
        //getContentPane().enableInputMethods(false);
        this.cdata = cdata;        
        getContentPane().add(cdata.getKeyCanvas(), BorderLayout.CENTER);
        setCanvasResizable(cdata.isResizable());
        super.setBounds(0, 0, cdata.getWidth(), cdata.getHeight());
        addWindowListener(new WindowAdapter() {
            @Override public void windowClosing(WindowEvent e) {
                removeFrame();
            }
        });
        addFocusListener(this);
    }

    @Override public void changeSymbol(Symbol symbol) {
        KeyboardFrameCommonData ncdata = new KeyboardFrameCommonData(cdata.getGeometry(), symbol);
        setTitle(ncdata.getKBDTitle());
        KeyCanvas canvas = cdata.getKeyCanvas();
        float scale_x = canvas.getScaleX();
        float scale_y = canvas.getScaleY();
        getContentPane().remove(canvas);
        canvas = ncdata.getKeyCanvas();
        getContentPane().add(canvas, BorderLayout.CENTER);
        this.cdata = ncdata;                
        setCanvasResizable(ncdata.isResizable());
        super.setBounds(getX(), getY(), getWidth(), getHeight());
        canvas.setScale(scale_x, scale_y);
        setVisible(true);
    }

    @Override public void changeGeometry(Geometry geometry) {
        KeyboardFrameCommonData ncdata = new KeyboardFrameCommonData(geometry, cdata.getSymbol());
        setTitle(ncdata.getKBDTitle());
        KeyCanvas canvas = cdata.getKeyCanvas();
        float scale_x = canvas.getScaleX();
        float scale_y = canvas.getScaleY();
        getContentPane().remove(canvas);
        canvas = ncdata.getKeyCanvas();
        getContentPane().add(canvas, BorderLayout.CENTER);
        this.cdata = ncdata;
        setCanvasResizable(ncdata.isResizable());
        super.setBounds(getX(), getY(), getWidth(), getHeight());
        canvas.setScale(scale_x, scale_y);
        setVisible(true);
    }
    
    @Override public String getSavingPosScale() {
        // format is [x/y - scale_x/scale_y]
        KeyCanvas canvas = cdata.getKeyCanvas();
        float scale_x = canvas.getScaleX();
        float scale_y = canvas.getScaleY();
        String info = "[" + getX() + "/" + getY() + " - " + scale_x + "/" + scale_y + "]";
        
        return info;
    }

    private void removeFrame() {
        VKBManager.getInstance().removeKeyboardFrame(this);
    }
    
    @Override public KeyCanvas getCanvas() {
        return cdata.getKeyCanvas();
    }
    
    @Override public void setDesignMode(boolean design) {
        KeyCanvas canvas = getCanvas();
        if (canvas != null) {
            canvas.setDesignMode(design);
        }
    }
    
    @Override public boolean isDesignMode() {
        KeyCanvas canvas = getCanvas();
        if (canvas != null) {
            return canvas.isDesignMode();
        }
        return false;
    }
    
    @Override public void setModifiable(boolean mod) {
        KeyCanvas canvas = getCanvas();
        if (canvas != null) {
            canvas.setModifiable(mod);
        }
    }
    
    @Override public boolean isModifiable() {
        KeyCanvas canvas = getCanvas();
        if (canvas != null) {
            return canvas.isModifiable();
        }
        return false;
    }
    
    @Override public void setKBDTitle(String title) {
        super.setTitle(title);
        cdata.setKBDTitle(title);
    }
    
    @Override public String getKBDTitle() {
        return cdata.getKBDTitle();
    }
    
    @Override public boolean isTarget() {
        return super.isActive();
    }
    
    private void setCanvasResizable(boolean resize) {
        KeyCanvasResizeListener resizeListener = cdata.getResizeListener();
        if (resize && resizeListener != null) {
            addComponentListener(resizeListener);
        } else if (!resize && resizeListener != null) {
            removeComponentListener(resizeListener);
        }
    }
    
    @Override public void dismiss() {
        removeFocusListener(this);
        dispose();
    }
    
    @Override public KeyboardFrameCommonData getCommonData() {
        cdata.setTarget(isTarget());
        return cdata;
    }
    

    // FocusListner implementation
    @Override public void focusGained(FocusEvent e) {
        VKBManager.getInstance().setCurrentFrame(this);
    }
    
    @Override public void focusLost(FocusEvent e) {
    }
}
