/*
Copyright 1990-2008 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.sun.g11n.vkb;

import com.sun.g11n.vkb.sym.Symbol;
import com.sun.g11n.vkb.geom.*;
import java.util.*;

/**
 * This class holds all of nessesary layout info
 * 
 * @author naoyuki
 */
public class KeyboardLayout {
    private Geometry geom;
    private Symbol sym;
    private KeyShape defaultShape;
    private boolean caps;
    private int level;
    private int modifierState; // for sending keyevent to client
    
    public KeyboardLayout(Geometry geom, Symbol sym) {
        this.geom = geom;
        this.sym = sym;
        //keys = null;
        keyViewSet = null;
        caps = false;
        level = 0;
        modifierState = 0;
        total_width = offset_x;
        total_height = offset_y;
    }
    
    private int offset_x = 20;
    private int offset_y = 20;
    private int total_width;
    private int total_height;
    public int getWidth() {
        return total_width;
    }
    public int getHeight() {
        return total_height;
    }

    private KeyViewSet keyViewSet;
    
    public KeyViewSet setupKeyView2() {
        if (keyViewSet != null) {
            return keyViewSet;
        }
        keyViewSet = new KeyViewSet(geom.getDescription(), sym.getDescription());
        Collection<KeySection> sections = geom.getActiveSections();
        
        for (KeySection section : sections) {
            float top = section.getTop();
            float left = section.getLeft();
            if (left == 0) {
                left = geom.getSectionLeft();
            }
            
            String defaultShapeName = section.getDefaultShapeName();
            if (defaultShapeName == null) {
                defaultShapeName = geom.getDefaultShape();
            }
            defaultShape = geom.getShape(defaultShapeName);
            float current_x = 0;
            float current_y = 0;
            float default_gap = geom.getDefaultGap();
            
            Map<String, KeyModel> symbolMap = sym.getKeyMap();
            List<KeyRow> rowList = section.getRowList();
            for (KeyRow row : rowList) {
                List<KeyInfo> keyInfoList = row.getKeyInfoList();
                current_x = left + row.getLeft();
                current_y = top + row.getTop();
                for (KeyInfo sectionKey : keyInfoList) {
                    // convert KeySection.Key and KeyModel to GUI representation KeyView
                    String label = sectionKey.getLabel();
                    float gap = sectionKey.getGap();
                    if (gap == 0) {
                        gap = section.getGap();
                        if (gap == 0) {
                            gap = default_gap;
                        }
                    }
                    String shapeName = sectionKey.getShapeName();
                    if (shapeName == null) {
                        shapeName = row.getShapeName();
                        if (shapeName == null) {
                            shapeName = section.getDefaultShapeName();
                            if (shapeName == null) {
                                shapeName = defaultShapeName;
                            }
                        }
                    } 
                    KeyShape shape = geom.getShape(shapeName);
                    current_x += gap;                    
                    KeyView view = new KeyView(current_x, current_y, shape);
                    current_x += shape.getWidth();
                    
                    KeyModel model = symbolMap.get(label);
                    
                    if (model != null) {
                        model = model.copy();
                    } else {
                        model = KeyModel.getInstance(label);
                    }
                    if (model.hasIdentical()) {
                        KeyModel model2 = findSameModel(model.getIdentical());
                        if (model2 != null) {
                            model = model2;
                        }
                    }
                    view.setModel(model);
                    model.setLayout(this);
                    view.setFontSize((int)(defaultShape.getHeight() * 0.41));
                    keyViewSet.add(label, view);
                }
                if (total_width < current_x) {
                    total_width = (int)current_x;
                }
            }
            if (current_y + offset_y > total_height) {
                total_height = (int) current_y + offset_y;
            }
            total_width += offset_x;
        }
        return keyViewSet;
    }
    
    public KeyViewSet setupKeyView() {
        if (keyViewSet != null) {
            return keyViewSet;
        }
        keyViewSet = new KeyViewSet(geom.getDescription(), sym.getDescription());
        KeySection section = geom.getDefaultSection();
        if (section == null) {
            return keyViewSet;
        }
        
        String defaultShapeName = section.getDefaultShapeName();
        if (defaultShapeName == null) {
            defaultShapeName = geom.getDefaultShape();
        }
        if (defaultShapeName == null) {
            defaultShapeName = "NORM";
        }
        defaultShape = geom.getShape(defaultShapeName);
        
        // TODO: this needs to be brushed up when it supports multiple
        //       sections
        float section_left = geom.getSectionLeft();
        float section_top = section.getTop();
        section_left = offset_x;
        section_top = offset_y;
        float current_x = 0;
        float current_y = 0;
        float default_gap = geom.getDefaultGap();
        
        // get KeyModel from symbol
        Map<String, KeyModel> symbolMap = sym.getKeyMap();
        
        List<KeyRow> rowList = section.getRowList();
        for (KeyRow row : rowList) {
            List<KeyInfo> keyInfoList = row.getKeyInfoList();
            current_y = section_top + row.getTop();
            current_x = section_left;
            for (KeyInfo sectionKey : keyInfoList) {
                // convert KeySection.Key and KeyModel to GUI representation KeyView
                String label = sectionKey.getLabel();
                float gap = sectionKey.getGap();
                if (gap == 0) {
                    gap = section.getGap();
                    if (gap == 0) {
                        gap = default_gap;
                    }
                }
                
                String shapeName = sectionKey.getShapeName();
                if (shapeName == null) {
                    shapeName = row.getShapeName();
                    if (shapeName == null) {
                        shapeName = section.getDefaultShapeName();
                        if (shapeName == null) {
                            shapeName = defaultShapeName;
                        }
                    }
                }
                KeyShape shape = geom.getShape(shapeName);
                current_x += gap;
                KeyView view = new KeyView(current_x, current_y, shape);
                current_x += shape.getWidth();
                
                KeyModel model = symbolMap.get(label);
                
                if (model != null) {
                    model = model.copy();
                } else {
                    model = KeyModel.getInstance(label);
                    Integer code = Main.getIMInterface().getKeyCodeFromLabel(label);
                    if (code != -1) {
                        model.setCode(code);
                    }
                }
                if (model.hasIdentical()) {
                    KeyModel model2 = findSameModel(model.getIdentical());
                    if (model2 != null) {
                        model = model2;
                    }
                }
                view.setModel(model);
                model.setLayout(this);
                view.setFontSize((int)(defaultShape.getHeight() * 0.41));
                keyViewSet.add(label, view);
            }
            if (total_width < current_x) {
                total_width = (int)current_x;
            }
        }
        total_height = (int)current_y + offset_y;
        total_width += offset_x;
        
        return keyViewSet;
    }

    /*
     * find same model which has been added to this layout first
     * the second KeyView uses the model of the first KeyView 
     */
    private KeyModel findSameModel(String name) {
        KeyModel sameModel = null;
        if (keyViewSet != null) {
            sameModel = keyViewSet.findModel(name);
        }
        return sameModel;
    }
    
    /*
     * return KeyView which has KeyModel model
     * but other that argument view.
     * This method is used by KeyView to handle identical 
     * key handling (like Right Shift and Left Shift.
     */
    KeyView getOtherView(KeyView view, KeyModel model) {
        if (keyViewSet != null && model != null) {
            return keyViewSet.findAnotherView(view, model);
        }
        return null;
    }
    /*
     * level is 0, 1, 2 or 3. 
     *    0 : no shift / no altgraph
     *    1 : shift / no altgraph
     *    2 : no shift / altgraph
     *    3 : shift / altgraph
     */        
    public int getLevel() {
        return level;
    }
    public void setLevel(int lev) {
        level = lev;
    }
    public void setModifierState(int mod) {
        if ((modifierState & mod) != 0) {
            modifierState ^= mod;
        } else {
            modifierState |= mod;
        }
    }
    public int getModifierState() {
        return modifierState;
    }
    public boolean isCaps() {
        return caps;
    }
    public void setCaps(boolean b) {
        caps = b;
    }
    public boolean getControl() {
        return ((modifierState & java.awt.event.InputEvent.CTRL_MASK) != 0);
    }
    public boolean getAlt() {
        return ((modifierState & java.awt.event.InputEvent.ALT_MASK) != 0);
    }
    
}
