/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.sun.g11n.vkb;

import java.io.*;
import java.util.*;

/**
 *
 * @author naoyuki
 */
public class Help {
    public static enum Type{
        GNOME, JAVA, BROWSER,
    };

    public static void invokeHelp() {
        String typeStr = Main.getHelpType().toLowerCase();
        Type type = Type.BROWSER;
        if (typeStr.equals("gnome")) {
            type = Type.GNOME;
        } else if (typeStr.equals("java")) {
            type = Type.JAVA;
        }
        invokeHelp(type);
    }
    public static void invokeHelp(Type type) {
        switch (type) {
            case GNOME:
                // not supported yet
            case JAVA:
                // not supported yet
            default: // BROWSER
                String browser = Main.getHelpBrowser();
                String helpFile = Main.getHelpFile();
                int start = helpFile.indexOf("<");
                int end = helpFile.indexOf(">");
                if (start > -1 && start < end ) {
                    Locale l = Locale.getDefault();
                    String lang = l.getLanguage();
                    if (lang.equals("en")) {
                        lang = "C";
                    }
                    String pre = helpFile.substring(0, start);
                    String post = helpFile.substring(end + 1);
                    helpFile = pre + lang + post;
                    File file = new File(helpFile);
                    if (!file.canRead()) {
                        helpFile = pre + "C" + post;
                    }
                }
                Runtime runtime = Runtime.getRuntime();
                String[] command = new String[2];
                command[0] = browser;
                command[1] = helpFile;
                try {
                     runtime.exec(command);       
                } catch(Exception e) {
                    e.printStackTrace();
                }
        }
    }
}
