/*
Copyright 1990-2008 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
/*
 * ControlPanel.java
 *
 * Created on 2008/04/22, 15:55
 */

package com.sun.g11n.vkb;

import com.sun.g11n.vkb.sym.Symbol;
import com.sun.g11n.vkb.geom.GeometryCollection;
import com.sun.g11n.vkb.geom.Geometry;
import java.util.*;
import java.awt.event.*;

/**
 *
 * @author  naoyuki
 */
public class ControlPanel extends javax.swing.JFrame {
    private static ControlPanel controlPanel;
    private static VKBManager manager;
    public static ControlPanel getInstance() {
        if (controlPanel == null) {
            controlPanel = new ControlPanel();
        }
        return controlPanel;
    }
    /** Creates new form ControlPanel */
    private ControlPanel() {
        super();
        manager = VKBManager.getInstance();        
        initComponents();
        addWindowListener(new WindowAdapter() {
            @Override public void windowClosing(WindowEvent e) {
                if (manager.getNumKeyboardFrame() < 1) {
                    manager.exitVKB();
                } else {
                    setVisible(false);
                }
            }
        });
        syncCheck.setSelected(manager.getSyncMode());
    }
    
    public void enableClose(boolean b) {
        closeButton.setEnabled(b);
    }
    public void enableDesign(boolean b) {
        designCheck.setEnabled(b);
    }
    
    @Override public void setVisible(boolean visible) {
        super.setVisible(visible);
        Prefs.setControlPanelVisibility(visible);
        if (visible) {
            int kn = manager.getNumKeyboardFrame();
            enableClose(kn > 0);
            enableDesign(kn > 0);
        } else {
            recordPos();
        }
    }
    
    public void recordPos() {
        Prefs.setControlPanelPosition(getX(), getY());        
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        upperPanel1 = new javax.swing.JPanel();
        symbolCombo = new javax.swing.JComboBox();
        geometryCombo = new javax.swing.JComboBox();
        symbolLabel1 = new javax.swing.JLabel();
        geometryLabel1 = new javax.swing.JLabel();
        newButton = new javax.swing.JButton();
        jPanel4 = new javax.swing.JPanel();
        styleLabel1 = new javax.swing.JLabel();
        styleCombo = new javax.swing.JComboBox();
        jSeparator5 = new javax.swing.JSeparator();
        jSeparator6 = new javax.swing.JSeparator();
        jSeparator7 = new javax.swing.JSeparator();
        jPanel5 = new javax.swing.JPanel();
        editListButton = new javax.swing.JButton();
        saveButton = new javax.swing.JButton();
        saveButton.setEnabled(false);
        designCheck = new javax.swing.JCheckBox();
        jPanel6 = new javax.swing.JPanel();
        closeButton = new javax.swing.JButton();
        exitButton = new javax.swing.JButton();
        helpButton = new javax.swing.JButton();
        jSeparator8 = new javax.swing.JSeparator();
        syncCheck = new javax.swing.JCheckBox();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("com/sun/g11n/vkb/vkb-message"); // NOI18N
        setTitle(bundle.getString("vkb.control_panel.title")); // NOI18N
        setName("controPanel"); // NOI18N

        setupSymbolCombo();
        symbolCombo.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                symbolChange(evt);
            }
        });

        setupGeometryCombo();
        geometryCombo.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                geometryChange(evt);
            }
        });

        symbolLabel1.setText(bundle.getString("vkb.control_panel.symbol_list_label")); // NOI18N

        geometryLabel1.setText(bundle.getString("vkb.control_panel.geometry_list_label")); // NOI18N

        newButton.setText(bundle.getString("vkb.control_panel.new_keyboard_button")); // NOI18N
        newButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                newKeyboard(evt);
            }
        });

        javax.swing.GroupLayout upperPanel1Layout = new javax.swing.GroupLayout(upperPanel1);
        upperPanel1.setLayout(upperPanel1Layout);
        upperPanel1Layout.setHorizontalGroup(
            upperPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(upperPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(upperPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(symbolLabel1)
                    .addComponent(geometryLabel1))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(upperPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                    .addComponent(symbolCombo, 0, 139, Short.MAX_VALUE)
                    .addComponent(geometryCombo, 0, 139, Short.MAX_VALUE))
                .addGap(31, 31, 31)
                .addComponent(newButton)
                .addContainerGap())
        );
        upperPanel1Layout.setVerticalGroup(
            upperPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(upperPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(upperPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(symbolCombo, javax.swing.GroupLayout.PREFERRED_SIZE, 26, Short.MAX_VALUE)
                    .addComponent(symbolLabel1))
                .addGap(18, 18, 18)
                .addGroup(upperPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(geometryCombo, javax.swing.GroupLayout.PREFERRED_SIZE, 26, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(geometryLabel1))
                .addContainerGap())
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, upperPanel1Layout.createSequentialGroup()
                .addContainerGap(34, Short.MAX_VALUE)
                .addComponent(newButton)
                .addGap(33, 33, 33))
        );

        styleLabel1.setText(bundle.getString("vkb.control_panel.style_list_label")); // NOI18N

        setupStyleCombo();
        styleCombo.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                styleChange(evt);
            }
        });

        javax.swing.GroupLayout jPanel4Layout = new javax.swing.GroupLayout(jPanel4);
        jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(
            jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel4Layout.createSequentialGroup()
                .addGap(100, 100, 100)
                .addComponent(styleLabel1)
                .addGap(30, 30, 30)
                .addComponent(styleCombo, javax.swing.GroupLayout.PREFERRED_SIZE, 130, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(85, Short.MAX_VALUE))
        );
        jPanel4Layout.setVerticalGroup(
            jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup()
                .addContainerGap(23, Short.MAX_VALUE)
                .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(styleCombo, javax.swing.GroupLayout.PREFERRED_SIZE, 26, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(styleLabel1))
                .addGap(23, 23, 23))
        );

        editListButton.setText(bundle.getString("vkb.control_panel.manage_list")); // NOI18N
        editListButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                showLayoutListEditor(evt);
            }
        });

        saveButton.setText(bundle.getString("vkb.control_panel.save_button_label")); // NOI18N
        saveButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                saveButtonActionPerformed(evt);
            }
        });

        designCheck.setText(bundle.getString("vkb.control_panel.design_mode_label")); // NOI18N
        designCheck.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                modeChange(evt);
            }
        });

        javax.swing.GroupLayout jPanel5Layout = new javax.swing.GroupLayout(jPanel5);
        jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(
            jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel5Layout.createSequentialGroup()
                .addGap(73, 73, 73)
                .addComponent(designCheck)
                .addGap(61, 61, 61)
                .addGroup(jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(editListButton, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(saveButton, javax.swing.GroupLayout.DEFAULT_SIZE, 106, Short.MAX_VALUE))
                .addContainerGap(68, Short.MAX_VALUE))
        );
        jPanel5Layout.setVerticalGroup(
            jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel5Layout.createSequentialGroup()
                .addGroup(jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel5Layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(saveButton)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(editListButton))
                    .addGroup(jPanel5Layout.createSequentialGroup()
                        .addGap(32, 32, 32)
                        .addComponent(designCheck)))
                .addContainerGap(19, Short.MAX_VALUE))
        );

        closeButton.setText(bundle.getString("vkb.control_panel.close_button")); // NOI18N
        closeButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                closePanel(evt);
            }
        });

        exitButton.setText(bundle.getString("vkb.control_panel.exit_button")); // NOI18N
        exitButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                exitVKB(evt);
            }
        });

        helpButton.setText(bundle.getString("vkb.control_panel.help")); // NOI18N
        helpButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                invokeHelp(evt);
            }
        });

        javax.swing.GroupLayout jPanel6Layout = new javax.swing.GroupLayout(jPanel6);
        jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(
            jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel6Layout.createSequentialGroup()
                .addGap(48, 48, 48)
                .addComponent(helpButton, javax.swing.GroupLayout.PREFERRED_SIZE, 95, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(27, 27, 27)
                .addComponent(closeButton, javax.swing.GroupLayout.PREFERRED_SIZE, 102, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addComponent(exitButton, javax.swing.GroupLayout.PREFERRED_SIZE, 109, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(45, Short.MAX_VALUE))
        );
        jPanel6Layout.setVerticalGroup(
            jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel6Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(exitButton)
                    .addComponent(helpButton)
                    .addComponent(closeButton))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        syncCheck.setText(bundle.getString("vkb.control_panel.sync_label")); // NOI18N
        syncCheck.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                changeSyncMode(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel4, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addGap(96, 96, 96))
            .addGroup(layout.createSequentialGroup()
                .addGap(46, 46, 46)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addGroup(javax.swing.GroupLayout.Alignment.LEADING, layout.createSequentialGroup()
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addComponent(jSeparator7, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 449, Short.MAX_VALUE)
                                    .addComponent(jSeparator6, javax.swing.GroupLayout.DEFAULT_SIZE, 449, Short.MAX_VALUE)
                                    .addComponent(jPanel5, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(jPanel6, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                            .addGroup(layout.createSequentialGroup()
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jSeparator8, javax.swing.GroupLayout.PREFERRED_SIZE, 449, javax.swing.GroupLayout.PREFERRED_SIZE))
                            .addComponent(jSeparator5, javax.swing.GroupLayout.DEFAULT_SIZE, 449, Short.MAX_VALUE))
                        .addGap(28, 28, 28))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(upperPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addContainerGap(73, Short.MAX_VALUE))))
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap(140, Short.MAX_VALUE)
                .addComponent(syncCheck, javax.swing.GroupLayout.PREFERRED_SIZE, 251, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(132, 132, 132))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(jPanel4, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jSeparator8, javax.swing.GroupLayout.PREFERRED_SIZE, 11, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(syncCheck)
                .addGap(25, 25, 25)
                .addComponent(jSeparator5, javax.swing.GroupLayout.PREFERRED_SIZE, 16, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(upperPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jSeparator6, javax.swing.GroupLayout.PREFERRED_SIZE, 16, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel5, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jSeparator7, javax.swing.GroupLayout.PREFERRED_SIZE, 15, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel6, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    // called from VKBManager
    public void setDesignMode(boolean design) {
        designCheck.setSelected(design);
        saveButton.setEnabled(design);
        newButton.setEnabled(!design);
    }
    /*
    private static LayoutSaveDialog layoutSaveDialog = null;
    public static LayoutSaveDialog getLayoutSaveDialog() {
        if (layoutSaveDialog == null) {
            layoutSaveDialog = new LayoutSaveDialog(new JFrame(), true);
        }
        return layoutSaveDialog;
    }
     * */

    private void symbolChange(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_symbolChange
        Symbol sym = (Symbol)symbolCombo.getSelectedItem();
        manager.setCurrentSymbol(sym);
}//GEN-LAST:event_symbolChange

    private void geometryChange(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_geometryChange
        Geometry geom = (Geometry)geometryCombo.getSelectedItem();
        manager.setCurrentGeometry(geom);
}//GEN-LAST:event_geometryChange

    private void newKeyboard(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_newKeyboard
        manager.newKeyboardFrame();
}//GEN-LAST:event_newKeyboard

    private void styleChange(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_styleChange
        FrameStyle st = (FrameStyle)styleCombo.getSelectedItem();
        manager.setFrameStyle(st);
}//GEN-LAST:event_styleChange
    private static LayoutListEditor layoutListEditor = null;
    private void showLayoutListEditor(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_showLayoutListEditor
        if (layoutListEditor == null) {
            layoutListEditor = new LayoutListEditor(this, true);
        }
        layoutListEditor.setVisible(true);
}//GEN-LAST:event_showLayoutListEditor

    private void saveButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_saveButtonActionPerformed
        //layoutSaveDialog = getLayoutSaveDialog();
        LayoutSaveDialog layoutSaveDialog = new LayoutSaveDialog(this, true);
        layoutSaveDialog.setVisible(true);
}//GEN-LAST:event_saveButtonActionPerformed

    private void modeChange(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_modeChange
        boolean design = designCheck.isSelected();
        //manager.setDesignMode(design);
}//GEN-LAST:event_modeChange

    private void closePanel(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_closePanel
        setVisible(false);
}//GEN-LAST:event_closePanel

    private void exitVKB(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_exitVKB
        manager.exitVKB();
}//GEN-LAST:event_exitVKB

    private void invokeHelp(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_invokeHelp
        manager.invokeHelp();
}//GEN-LAST:event_invokeHelp

    private void changeSyncMode(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_changeSyncMode
        boolean sync = syncCheck.isSelected();
        manager.setSyncMode(sync);
}//GEN-LAST:event_changeSyncMode
    
    private void setupStyleCombo() {
        FrameStyle style = Prefs.getFrameStyle();
        for (FrameStyle st : FrameStyle.values()) {
            styleCombo.addItem(st);
            if (st == style) {
                styleCombo.setSelectedItem(st);
            }
        }
    }
    
    public void setFrameStyle(FrameStyle style) {
        styleCombo.setSelectedItem(style);
    }
    
    private void setupSymbolCombo() {
        SortedSet<Symbol> ssymbols = manager.getSortedSymbolSet();
        Symbol currentSymbol = manager.getCurrentSymbol();
        for (Symbol symbol : ssymbols) {
            symbolCombo.addItem(symbol);
        }
        symbolCombo.setSelectedItem(currentSymbol);
    }
    
    public void addSymbolToUI(Symbol newSymbol) {
        symbolCombo.addItem(newSymbol);
    }
    
    public void updateSymbols() {
        symbolCombo.removeAllItems();
        setupSymbolCombo();
    }
    
    private void setupGeometryCombo() {
        GeometryCollection geomCol = Main.getGeometryCollection();
        Set<Geometry> geoms = geomCol.getGeometrySet();
        SortedSet<Geometry> sgeoms = new TreeSet<Geometry>();
        Geometry currentGeometry = VKBManager.getInstance().getCurrentGeometry();
        for (Geometry geom : geoms) {
            String geomName = geom.toString();
            if (geomName != null) {
                sgeoms.add(geom);
            }
        }
        for (Geometry geom : sgeoms) {
            geometryCombo.addItem(geom);
        }
        geometryCombo.setSelectedItem(currentGeometry);
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                ControlPanel dialog = new ControlPanel();
                dialog.addWindowListener(new java.awt.event.WindowAdapter() {
                    @Override public void windowClosing(java.awt.event.WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton closeButton;
    private javax.swing.JCheckBox designCheck;
    private javax.swing.JButton editListButton;
    private javax.swing.JButton exitButton;
    private javax.swing.JComboBox geometryCombo;
    private javax.swing.JLabel geometryLabel1;
    private javax.swing.JButton helpButton;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanel5;
    private javax.swing.JPanel jPanel6;
    private javax.swing.JSeparator jSeparator5;
    private javax.swing.JSeparator jSeparator6;
    private javax.swing.JSeparator jSeparator7;
    private javax.swing.JSeparator jSeparator8;
    private javax.swing.JButton newButton;
    private javax.swing.JButton saveButton;
    private javax.swing.JComboBox styleCombo;
    private javax.swing.JLabel styleLabel1;
    private javax.swing.JComboBox symbolCombo;
    private javax.swing.JLabel symbolLabel1;
    private javax.swing.JCheckBox syncCheck;
    private javax.swing.JPanel upperPanel1;
    // End of variables declaration//GEN-END:variables
    
}
