/*
Copyright 1990-2006 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#ifndef KBLTRANS_KBLTRANS_IMPLE_H
#define KBLTRANS_KBLTRANS_IMPLE_H
#include "common.h"
#include "error.h"
#include "list.h"

typedef enum {
  ALBANIAN = 0,
  ARABIC,
  BELARUSIAN,
  BELGIAN,
  BOSNIAN_HERZEGOVINA,
  BRAGILLIAN_PORTUGUESE,
  BULGARIAN,
  CANADIAN_FRENCH,
  CANADIAN,
  CROATIAN,
  CZECH,
  CZECH_QWERTY,
  DANISH,
  DUTCH,
  ESTONIAN,
  FINNISH,
  FRENCH,
  GERMAN,
  GREEK,
  HUNGARIAN,
  ICELANDIC,
  ITALIAN,
  JAPANESE,
  KAZAKHSTAN,
  KOREAN,
  LATVIAN,
  LITHUANIAN,
  MACEDONIAN,
  MALTESE_UK,
  MALTESE_US,
  NORWEGIAN,
  POLISH,
  PORTUGUESE,
  ROMANIAN,
  RUSSIAN,
  SERBIAN,
  SLOVAK,
  SLOVAK_QWERTY,
  SLOVENIAN,
  SPANISH,
  SWEDISH,
  SWISS_FRENCH,
  SWISS_GERMAN,
  TRADITIONAL_CHINESE,
  TURKISH_F,
  THUKISH_Q,
  UKRAINIAN,
  URUDU,
  UK,
  US_DVORAK,
  US_ENGLISH,
  GEORGIAN,
  _MAX_LAYOUT
} _IIIMKB_layout_id;
#define _NO_DEF_ -1

/* #define DEFAULT_ID _MAX_LAYOUT - 1
   This needs to be changed to US_ENGLISH with below reason.
   Newly added layout must be added at the buttom of
   _IIIMKB_layout_id array so that it does not change user's saved
   layout (without using autodetect). It means '_MAX_LAYOUT -1'
   will be that newly added one. It is not preferable.
 */
#define DEFAULT_ID US_ENGLISH

static char * layout_name[] = {
  "Albanian", 			"x-kbl-al",
  "Arabic",			"x-kbl-ar",
  "Belarusian",			"x-kbl-by",
  "Belgian",			"x-kbl-be",
  "Bosnian/Herzegovina",	"x-kbl-bs",
  "Brazilian/Portuguese",	"x-kbl-br",
  "Bulgarian",			"x-kbl-bg",
  "Canadian/French",		"x-kbl-ca_enhanced",
  "Canadian",			"x-kbl-ca",
  "Croatian",			"x-kbl-hr",
  "Czech",			"x-kbl-cz",
  "Czech/Qwerty",		"x-kbl-cz_qwerty",
  "Danish",			"x-kbl-dk",
  "Dutch",			"x-kbl-nl",
  "Estonian",			"x-kbl-ee",
  "Finnish",			"x-kbl-fi",
  "French",			"x-kbl-fr",
  "German",			"x-kbl-de",
  "Greek",			"x-kbl-el",
  "Hungarian",			"x-kbl-hu",
  "Icelandic",			"x-kbl-is",
  "Italian",			"x-kbl-it",
  "Japanese",			"x-kbl-ja",
  "Kazakhstan",			"x-kbl-kz",
  "Korean",			"x-kbl-ko",
  "Latvian",			"x-kbl-lv",
  "Lithuanian",			"x-kbl-lt",
  "Macedonian",			"x-kbl-mk",
  "Maltese/UK",			"x-kbl-mt",
  "Maltese/US",			"x-kbl-mt_us",
  "Norwegian",			"x-kbl-no",
  "Polish",			"x-kbl-pl",
  "Portuguese",			"x-kbl-pt",
  "Romanian",			"x-kbl-ro",
  "Russian",			"x-kbl-ru",
  "Serbian",			"x-kbl-sr",
  "Slovak",			"x-kbl-sk",
  "Slovak/Qwerty",		"x-kbl-sk_qwerty",
  "Slovenian",			"x-kbl-si",
  "Spanish",			"x-kbl-es",
  "Swedish",			"x-kbl-se",
  "Swiss/French",		"x-kbl-fr_CH",
  "Swiss/German",		"x-kbl-de_CH",
  "Traditional/Chinese",	"x-kbl-tw",
  "Turkish/F",			"x-kbl-tr_f",
  "Turkish/Q",			"x-kbl-tr",
  "Ukrainian",			"x-kbl-ua",
  "Urdu",			"x-kbl-pk",
  "UK",				"x-kbl-gb",
  "US/Dvorak",			"x-kbl-dvorak",
  "US/English",			"x-kbl-en",
  "Georgian",			"x-kbl-ge",
};

typedef enum {
  BUITIN,
  CUSTOM
} LAYOUT_TYPE;

struct _KBLTR_layout {
  LAYOUT_TYPE type;
  char *source;
  char *name;
  int alg;
  List *list;
};

struct _KBLTR_context {
  struct _KBLTR_layout *source;
  struct _KBLTR_layout *target;
};

typedef struct {
  char *location_code_name;
  int code;
  int altcode;
  
  int g1l1;
  int g1l2;
  int g2l1;
  int g2l2;
} CODES;

typedef struct {
  char *location_code_name;
  int code;

  UTF16_CHAR *g1l1;
  UTF16_CHAR *g1l2;
  UTF16_CHAR *g2l1;
  UTF16_CHAR *g2l2;
} CODES_EXT;

#if sun
#define TYPE45		0
#define TYPE6_1		1
#define TYPE6_2		2

#define TYPE45_MAX	0x61
#define TYPE6_1_MAX	0x23
#define TYPE6_2_MIN	0x100
#define TYPE6_2_MAX	0x10f
static const int platform_layout_type45[] = {
  /* 0 - 7 */
  US_ENGLISH,
  US_ENGLISH,
  BELGIAN,
  CANADIAN,
  DANISH,
  GERMAN,
  ITALIAN,
  DUTCH,
  /* 8 - 0f */
  NORWEGIAN,
  PORTUGUESE,
  SPANISH,
  SWEDISH,
  SWISS_FRENCH,
  SWISS_GERMAN,
  UK,
  _NO_DEF_,
  /* 10 - 17 */
  KOREAN,
  TRADITIONAL_CHINESE,
  _NO_DEF_,
  US_ENGLISH,
  _NO_DEF_,
  _NO_DEF_,
  _NO_DEF_,
  _NO_DEF_,
  /* 18 - 1f */
  _NO_DEF_,
  _NO_DEF_,
  _NO_DEF_,
  _NO_DEF_,
  _NO_DEF_,
  _NO_DEF_,
  _NO_DEF_,
  _NO_DEF_,
  /* 20 - 27 */
  JAPANESE,
  US_ENGLISH,
  US_ENGLISH,
  FRENCH,
  DANISH,
  GERMAN,
  ITALIAN,
  DUTCH,
  /* 28 - 2f */
  NORWEGIAN,
  PORTUGUESE,
  SPANISH,
  SWEDISH,
  SWISS_FRENCH,
  SWISS_GERMAN,
  UK,
  KOREAN,
  /* 30 - 37 */
  TRADITIONAL_CHINESE,
  JAPANESE,
  CANADIAN_FRENCH,
  HUNGARIAN,
  POLISH,
  CZECH,
  RUSSIAN,
  LATVIAN,
  /* 38 - 3f */
  TURKISH_F,
  GREEK,
  _NO_DEF_,
  LITHUANIAN,
  _NO_DEF_,
  _NO_DEF_,
  _NO_DEF_,
  CANADIAN_FRENCH,
  /* 40 - 47 */
  _NO_DEF_,
  _NO_DEF_,
  _NO_DEF_,
  _NO_DEF_,
  _NO_DEF_,
  _NO_DEF_,
  _NO_DEF_,
  _NO_DEF_,
  /* 48 - 4f */
  _NO_DEF_,
  _NO_DEF_,
  _NO_DEF_,
  _NO_DEF_,
  _NO_DEF_,
  _NO_DEF_,
  _NO_DEF_,
  _NO_DEF_,
  /* 50 - 57 */
  US_ENGLISH,
  US_ENGLISH,
  FRENCH,
  DANISH,
  GERMAN,
  ITALIAN,
  DUTCH,
  NORWEGIAN,
  /* 58 - 5f */
  PORTUGUESE,
  SPANISH,
  SWEDISH,
  SWISS_FRENCH,
  SWISS_GERMAN,
  UK,
  KOREAN,
  TRADITIONAL_CHINESE,
  /* 60 - 67 */
  JAPANESE,
  CANADIAN_FRENCH,
};
static const int platform_layout_type6_1[] = { 
  /* 0 - 7 */
  US_ENGLISH,
  _NO_DEF_,
  BELGIAN,
  _NO_DEF_,
  CANADIAN_FRENCH,
  CZECH,
  DANISH,
  FINNISH,
  /* 8 - f */
  FRENCH,
  GERMAN,
  GREEK,
  _NO_DEF_,
  HUNGARIAN,
  _NO_DEF_,
  ITALIAN,
  JAPANESE,
  /* 10 - 17 */
  KOREAN,
  SPANISH,
  DUTCH,
  NORWEGIAN,
  _NO_DEF_,
  POLISH,
  PORTUGUESE,
  RUSSIAN,
  /* 18 - 1f */
  SLOVAK,
  SPANISH,
  SWEDISH,
  SWISS_FRENCH,
  SWISS_GERMAN,
  _NO_DEF_,
  TRADITIONAL_CHINESE,
  THUKISH_Q,
  /* 20 - 27 */
  UK,
  US_ENGLISH,
  _NO_DEF_,
  TURKISH_F,
};
static const int platform_layout_type6_2[] = {
  /* 100 - 107 */
  SLOVENIAN,
  SERBIAN,
  ICELANDIC,
  CROATIAN,
  BULGARIAN,
  BELARUSIAN,
  MALTESE_US,
  MALTESE_UK,
  /* 108 - 10f */
  ALBANIAN,
  LITHUANIAN,
  LATVIAN,
  MACEDONIAN,
  _NO_DEF_,
  _NO_DEF_,
  _NO_DEF_,
  JAPANESE,
};
#endif /* sun */
#define CAPS_LOCK_MASK 0x40000000

#endif
