/*
Copyright 1990-2006 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
/*
 * XMLOutput.java
 *
 * Created on 2006/08/10, 19:38
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package kldhandler;

import java.util.*;
import java.io.*;
import javax.xml.parsers.*;
import org.w3c.dom.*;

/**
 *
 * @author naoyuki
 */
public class XMLOutput implements DataOutput {
    
    private File outfile;
    
    /** Creates a new instance of XMLOutput */
    public XMLOutput(File outfile) {
        this.outfile = outfile;
    }

    /*
     * make DOM with pinfo and write out it to 'outfile'
     * 
     * XML format is
     * <iiimkbdata>
     *   <lo type="Arabic">
     *     <key sym="AB01">
     *       <c1>z</c1>
     *       <c2>Z</c2>
     *       <c3>Arabic_hamzaonyeh</c3>
     *       <c4>ascitilde</c4>
     *       <code>5a</code>
     *       <altcode>5c</altcode>
     *     </key>
     *     <key sym="<AB02>">
     *   ....
     *   </lo>
     * </iiimkbdata>
     */
    public void print(Map<String, Map<String, GLSymbol>> pinfo) throws Exception {
        DocumentBuilderFactory facotry = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = facotry.newDocumentBuilder();
        Document document = builder.newDocument();
        Element root = document.createElement("kbltrans");
        document.appendChild(root);
        LONameMapper mapper = Main.getMapper();
        for (String name : pinfo.keySet()) {
            Element elm = document.createElement("lo");
            elm.setAttribute("type", name);
            if (mapper.preferAltGraph(name)) {
                elm.setAttribute("alg", "true");
            }
            root.appendChild(elm);
            
            boolean addUS12 = false;
            Map <String, GLSymbol> us_map = null;
            if (mapper.addUSSymbols(name)) {
                addUS12 = true;
                us_map = Main.getUSMap();
            }

            Map<String, GLSymbol> m = pinfo.get(name);
            SortedSet<String> sset = new TreeSet<String>(m.keySet());
            for (String code : sset) {
                String elmCode = code.trim();
                if (Util.isIgnore(elmCode)) {
                    // ignore code like modifiers, functions or numpad keys
                    continue;
                }
                if (elmCode.length() < 3) {
                    System.err.println(" Invalid code : " + code);
                    continue;
                }
                elmCode = elmCode.substring(1, code.length() - 1);
                Element codeElm = document.createElement("key");
                codeElm.setAttribute("sym", elmCode);

                GLSymbol gls = m.get(code);
                String g1l1 = checkNull(gls.getG1L1());
                String g1l2 = checkNull(gls.getG1L2());
                String g2l1 = checkNull(gls.getG2L1());
                String g2l2 = checkNull(gls.getG2L2());
                if (addUS12 && g2l1 == null && g2l2 == null) {
                    GLSymbol gls_us = us_map.get(code);
                    g2l1 = checkNull(gls_us.getG1L1());
                    g2l2 = checkNull(gls_us.getG1L2());
                }

                if (g1l1 != null) {
                    Element g = document.createElement("c1");
                    codeElm.appendChild(g);
                    String keychar = Util.toKeychar(g1l1);
                    if (keychar == null) {
                        System.err.println(g1l1 + " is not found in keysymToKeychar map.");
                        keychar = "3f"; // '?'
                    }
                    g.appendChild(document.createTextNode(keychar));
                }
                if (g1l2 != null) {
                    Element g = document.createElement("c2");
                    codeElm.appendChild(g);
                    String keychar = Util.toKeychar(g1l2);
                    if (keychar == null) {
                        System.err.println(g1l2 + " is not found in keysymToKeychar map.");
                        keychar = "3f";
                    }
                    g.appendChild(document.createTextNode(keychar));
                }
                if (g2l1 != null) {
                    Element g = document.createElement("c3");
                    codeElm.appendChild(g);
                    String keychar = Util.toKeychar(g2l1);
                    if (keychar == null) {
                        System.err.println(g2l1 + " is not found in keysymToKeychar map.");
                        keychar = "3f";
                    }
                    g.appendChild(document.createTextNode(keychar));
                }
                if (g2l2 != null) {
                    Element g = document.createElement("c4");
                    codeElm.appendChild(g);
                    String keychar = Util.toKeychar(g2l2);
                    if (keychar == null) {
                        System.err.println(g2l2 + " is not found in keysymToKeychar map.");
                        keychar = "3f";
                    }
                    g.appendChild(document.createTextNode(keychar));
                }

                String keysym = g1l1 != null ? g1l1 : (g1l2 != null ? g1l2 :
                    (g2l1 != null ? g2l1 : g2l2));

                if (keysym != null) {
                    String keycode = Util.toKeycode(keysym);
                    if (keycode == null) {
                        // System.err.println(keysym + " is not found in keysymToKeycode map.");
                        keycode = "0";
                    }
                    Element kc = document.createElement("code");
                    codeElm.appendChild(kc);
                    kc.appendChild(document.createTextNode(keycode));
                }
                if (g2l1 != null) {
                    String altKeycode = Util.toKeycode(g2l1);
                    if (altKeycode != null) {
                        Element akc = document.createElement("altcode");
                        codeElm.appendChild(akc);
                        akc.appendChild(document.createTextNode(altKeycode));
                    }
                }
                elm.appendChild(codeElm);
            }
        }
        document.normalize();
        FileWriter writer = new FileWriter(outfile);
        String xml = toXMLString(document.getFirstChild());
        writer.write(xml);
        writer.close();
    }
    
    private static String checkNull(String a) {
        if (a == null || a.toLowerCase().startsWith("nosymbol")) 
            return null;
        
        return a;
    }
    
    /*
     * really simple XML writing method (Where the LSSerializer implementation?)
     */
    private String toXMLString(Node node) {
        short type = node.getNodeType();
        if (type == Node.TEXT_NODE) {
            return node.getNodeValue();
        }
        
        StringBuffer buffer = new StringBuffer();        
        String name = node.getNodeName();
        buffer.append("<");
        buffer.append(name);
        NamedNodeMap attrs = node.getAttributes();
        for (int i = 0, len = attrs.getLength(); i < len; i++) {
            Node attr = attrs.item(i);
            String attrName = attr.getNodeName();
            String attrValue = attr.getNodeValue();
            buffer.append(" ");
            buffer.append(attrName);
            buffer.append("=");
            buffer.append("\"");
            buffer.append(attrValue);
            buffer.append("\"");
        }
        buffer.append(">");
        NodeList nodeList = node.getChildNodes();
         for (int i = 0, len = nodeList.getLength(); i < len; i++) {
            buffer.append(toXMLString(nodeList.item(i)));
        }
        buffer.append("</");
        buffer.append(name);
        buffer.append(">");
        return buffer.toString();
    }
}
