#include <stdio.h>

#include "lookup_aux.h"

#define _(s)  (s)

void lookup_window_hide(lookup_window_t *lookup_window);
GtkWidget *lookup_window_create_symbols_page(lookup_window_t *lookup_window);
GtkWidget *lookup_window_create_charmap_page(lookup_window_t *lookup_window);
void lookup_window_click_ok_button_callback (GtkButton *button, gpointer user_data);
gboolean lookup_window_delete_callback (GtkWidget *widget, GdkEvent *event, gpointer user_data);

/*********************************************************************/
/*                lookup_window_t  utilities                         */
/*********************************************************************/
lookup_window_t *lookup_window_new()
{
    GtkWidget *window;
    GtkWidget *vbox;
    GtkWidget *notebook;
    GtkWidget *ok_button;
    GtkWidget *label;
    GtkWidget *symbols_page;
    GtkWidget *charmap_page;
    GtkWidget *hbox;
    lookup_window_t *lookup_window = NULL;

    lookup_window = (lookup_window_t *) calloc(1, sizeof(lookup_window_t));
    if (lookup_window == NULL)
        return NULL;

    lookup_window->lookup_data = (lookup_data_t *)lookup_data_new();
    lookup_data_print(lookup_window->lookup_data);

    window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
    gtk_window_set_accept_focus (GTK_WINDOW(window), FALSE);
    gtk_window_set_title(GTK_WINDOW(window), _("window"));
    lookup_window->window = window;

    vbox = gtk_vbox_new(FALSE, 6);
    gtk_widget_show(vbox);
    gtk_container_add(GTK_CONTAINER(window), vbox);

    notebook = gtk_notebook_new();
    gtk_widget_show(notebook);
    gtk_notebook_set_scrollable (GTK_NOTEBOOK(notebook), TRUE);
    gtk_notebook_popup_enable (GTK_NOTEBOOK(notebook));
    gtk_box_pack_start(GTK_BOX(vbox), notebook, FALSE, FALSE, 6);

    label = gtk_label_new(_("symbols page"));
    gtk_widget_show(label);

    symbols_page = (GtkWidget *)lookup_window_create_symbols_page(lookup_window);
    gtk_notebook_append_page (GTK_NOTEBOOK (notebook), symbols_page, label);

    label = gtk_label_new(_("charmap page"));
    gtk_widget_show(label);

    charmap_page = lookup_window_create_charmap_page(lookup_window);
    gtk_notebook_append_page (GTK_NOTEBOOK (notebook), charmap_page, label);

    // Create hbox for button area.
    hbox = gtk_hbox_new (FALSE, 0);
    gtk_widget_show (hbox);
    gtk_box_pack_start(GTK_BOX (vbox), hbox, FALSE, FALSE, 8);

    ok_button = gtk_button_new_from_stock ("gtk-ok");
    gtk_widget_show (ok_button);
    gtk_box_pack_end (GTK_BOX (hbox), ok_button, FALSE, FALSE, 4);
    GTK_WIDGET_SET_FLAGS (ok_button, GTK_CAN_DEFAULT);

    g_signal_connect ((gpointer) ok_button, "clicked",
                      G_CALLBACK (lookup_window_click_ok_button_callback),
                      lookup_window);
    g_signal_connect (G_OBJECT (window), "delete_event",
                      G_CALLBACK (lookup_window_delete_callback),
                      lookup_window);

    gtk_widget_grab_default (ok_button);

    gtk_widget_realize(window);

    return lookup_window;
}

void lookup_window_destroy(lookup_window_t *lookup_window)
{
    if (lookup_window == NULL)
        return;

    if (lookup_window->lookup_data) {
        lookup_data_destroy(lookup_window->lookup_data);
    }

    if (lookup_window->window)
        gtk_widget_destroy(lookup_window->window);

    free ((char *)lookup_window);
}

void lookup_window_print(lookup_window_t *lookup_window)
{
    if (lookup_window == NULL)
        return;

    if (lookup_window->lookup_data) {
        lookup_data_print(lookup_window->lookup_data);
    }
}

void lookup_window_show(lookup_window_t *lookup_window)
{
    if (lookup_window == NULL)
        return;

    if (lookup_window->window) {
        gtk_widget_show (lookup_window->window);
        gdk_window_raise (lookup_window->window->window);
    }
}

void lookup_window_hide(lookup_window_t *lookup_window)
{
    if (lookup_window == NULL)
        return;

    if (lookup_window->window) {
        gtk_widget_hide (lookup_window->window);
    }
}

GtkWidget *lookup_window_create_charmap_page(lookup_window_t *lookup_window)
{
    GtkWidget *hbox;
    GtkWidget *scrolledwindow;
    GtkWidget *viewport;
    GtkWidget *fixed;
    GtkWidget *button;
    GtkWidget *vbox;
    GtkWidget *label;

    hbox = gtk_hbox_new(FALSE, 0);
    gtk_widget_show(hbox);

    scrolledwindow = gtk_scrolled_window_new(NULL, NULL);
    gtk_widget_show(scrolledwindow);
    gtk_box_pack_start(GTK_BOX(hbox), scrolledwindow, TRUE, TRUE, 0);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolledwindow),
				   GTK_POLICY_AUTOMATIC,
				   GTK_POLICY_AUTOMATIC);

    viewport = gtk_viewport_new(NULL, NULL);
    gtk_widget_show(viewport);
    gtk_container_add(GTK_CONTAINER(scrolledwindow), viewport);

    fixed = gtk_fixed_new();
    gtk_widget_show(fixed);
    gtk_container_add(GTK_CONTAINER(viewport), fixed);

    button = gtk_button_new_with_mnemonic(_("button"));
    gtk_widget_show(button);
    gtk_fixed_put(GTK_FIXED(fixed), button, 160, 40);
    gtk_widget_set_size_request(button, 60, 27);

    button = gtk_button_new_with_mnemonic(_("button"));
    gtk_widget_show(button);
    gtk_fixed_put(GTK_FIXED(fixed), button, 56, 32);
    gtk_widget_set_size_request(button, 60, 27);

    vbox = gtk_vbox_new(FALSE, 0);
    gtk_widget_show(vbox);
    gtk_box_pack_start(GTK_BOX(hbox), vbox, TRUE, TRUE, 0);

    label = gtk_label_new(_("label"));
    gtk_widget_show(label);
    gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, FALSE, 0);

    label = gtk_label_new(_("label"));
    gtk_widget_show(label);
    gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, FALSE, 0);

    label = gtk_label_new(_("label"));
    gtk_widget_show(label);
    gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, FALSE, 0);

    button = gtk_button_new_with_mnemonic(_("button"));
    gtk_widget_show(button);
    gtk_box_pack_start(GTK_BOX(vbox), button, FALSE, FALSE, 0);

    button = gtk_button_new_with_mnemonic(_("button"));
    gtk_widget_show(button);
    gtk_box_pack_start(GTK_BOX(vbox), button, FALSE, FALSE, 0);

    return hbox;
}

GtkWidget *lookup_window_create_symbols_page(lookup_window_t *lookup_window)
{
    GtkWidget *hbox;
    GtkWidget *scrolledwindow;
    GtkWidget *scrolledwindow2;
    GtkWidget *viewport1;
    GtkWidget *treeview;
    GtkWidget *table1;
    GtkWidget *button;

    hbox = gtk_hbox_new(FALSE, 0);
    gtk_widget_show(hbox);

    scrolledwindow = gtk_scrolled_window_new(NULL, NULL);
    gtk_widget_show(scrolledwindow);
    gtk_box_pack_start(GTK_BOX(hbox), scrolledwindow, TRUE, TRUE, 0);
    gtk_widget_set_size_request(scrolledwindow, 150, 280);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolledwindow),
				   GTK_POLICY_AUTOMATIC,
				   GTK_POLICY_AUTOMATIC);

    treeview = gtk_tree_view_new();
    gtk_widget_show(treeview);
    gtk_container_add(GTK_CONTAINER(scrolledwindow), treeview);
    gtk_widget_set_size_request(treeview, 9, -1);
    gtk_tree_view_set_headers_visible(GTK_TREE_VIEW(treeview), FALSE);
    gtk_tree_view_set_rules_hint(GTK_TREE_VIEW(treeview), TRUE);
    gtk_tree_view_set_reorderable(GTK_TREE_VIEW(treeview), TRUE);

    scrolledwindow2 = gtk_scrolled_window_new(NULL, NULL);
    gtk_widget_show(scrolledwindow2);
    gtk_box_pack_start(GTK_BOX(hbox), scrolledwindow2, TRUE, TRUE, 0);
    gtk_widget_set_size_request(scrolledwindow2, 470, 420);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolledwindow2),
				   GTK_POLICY_AUTOMATIC,
				   GTK_POLICY_AUTOMATIC);

    viewport1 = gtk_viewport_new(NULL, NULL);
    gtk_widget_show(viewport1);
    gtk_container_add(GTK_CONTAINER(scrolledwindow2), viewport1);

    table1 = gtk_table_new(10, 10, FALSE);
    gtk_widget_show(table1);
    gtk_container_add(GTK_CONTAINER(viewport1), table1);

    button = gtk_button_new_with_mnemonic(_("button"));
    gtk_widget_show(button);
    gtk_table_attach(GTK_TABLE(table1), button, 0, 1, 0, 1,
		     (GtkAttachOptions) (GTK_FILL),
		     (GtkAttachOptions) (0), 0, 0);

    button = gtk_button_new_with_mnemonic(_("button"));
    gtk_widget_show(button);
    gtk_table_attach(GTK_TABLE(table1), button, 1, 2, 1, 2,
		     (GtkAttachOptions) (GTK_FILL),
		     (GtkAttachOptions) (0), 0, 0);

    return hbox;
}

void
lookup_window_click_ok_button_callback (GtkButton *button, gpointer user_data)
{
    lookup_window_t *lookup_window = (lookup_window_t *)user_data;

    lookup_window_hide(lookup_window);
    return;
}

gboolean
lookup_window_delete_callback (GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
    lookup_window_t *lookup_window = (lookup_window_t *)user_data;

    lookup_window_hide(lookup_window);
    return TRUE;
}
