/*
Copyright 1990-2003 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#ifndef	XAUX_COMMON_H
#define	XAUX_COMMON_H

#pragma ident	"$Id$"

#define	ME_SO	"xaux_so"
#define	ME_EXT	"xaux_ext"

#define	XAUX_SOWIN_SUFFIX	"_sowin"
#define	XAUX_EXTWIN_SUFFIX	"_extwin"
#define	XAUX_XS_SUFFIX		"_xs"
#define	XAUX_SX_SUFFIX		"_sx"

#define	XAUX_MAXCLASSNAMELEN	255
#define	XAUX_MAXSUFFIXLEN	16
#define	XAUX_MAXPROPSZ		0x30000

#define	XAUX_MAXNPROPS_INIT	64

typedef enum {
	XAUX_PRIVTYPE_PUBLIC = 0,
	XAUX_PRIVTYPE_REQSEG = 1
} xaux_privtype_t;

#define	XAUX_PROTOVERS_MAJOR	1
#define	XAUX_PROTOVERS_MINOR	0

/* SX header */
#define	SX_PROTOVERS_MAJOR(prop)	(*((CARD16 *)((prop) + 0))) /* 2 */
#define	SX_PROTOVERS_MINOR(prop)	(*((CARD16 *)((prop) + 2))) /* 2 */
#define	SX_SEQNO(prop)		(*((CARD32 *)((prop) + 4))) /* 4 */
#define	SX_ATOM_AUX_NAME(prop)	(*((CARD32 *)((prop) + 8))) /* 4 */
#define	SX_INDEX(prop)		(*((CARD16 *)((prop) + 12))) /* 2 */
#define	SX_PRIVTYPE(prop)	(*((CARD8 *)((prop) + 14))) /* 1 */
#define	SX_AUXTYPE(prop)	(*((CARD8 *)((prop) + 15))) /* 1 */
#define	SX_IMID(prop)		(*((CARD16 *)((prop) + 16))) /* 2 */
#define	SX_ICID(prop)		(*((CARD16 *)((prop) + 18))) /* 2 */
#define	SX_MORESEGS(prop)	(*((CARD16 *)((prop) + 20))) /* 2 */
#define	SX_SEGNO(prop)		(*((CARD16 *)((prop) + 22))) /* 2 */
#define	SX_SEGSIZE(prop)	(*((CARD32 *)((prop) + 24))) /* 4 */
#define	SX_SIZE_HEADER		28
#define	SX_DATA_TOP(prop)	((prop) + SX_SIZE_HEADER)

/* AUX_DRAW */
#define	SX_DRAW_SOWIN(draw)		(*((CARD32 *)((draw) + 0))) /* 4 */
#define	SX_DRAW_CLIENTWIN(draw)		(*((CARD32 *)((draw) + 4))) /* 4 */
#define	SX_DRAW_FOCUSWIN(draw)		(*((CARD32 *)((draw) + 8))) /* 4 */
#define	SX_DRAW_POSX(draw)		(*((CARD16 *)((draw) + 12))) /* 2 */
#define	SX_DRAW_POSY(draw)		(*((CARD16 *)((draw) + 14))) /* 2 */
#define	SX_DRAW_INT_COUNT(draw)		(*((CARD32 *)((draw) + 16))) /* 4 */
#define	SX_DRAW_STR_COUNT(draw)		(*((CARD32 *)((draw) + 20))) /* 4 */
#define	SX_DRAW_TOTAL_STR_LEN(draw)	(*((CARD32 *)((draw) + 24))) /* 4 */
#define SX_SIZE_DRAW_HEADER		28
#define	SX_DRAW_INT_LIST(draw) \
	((CARD32 *)((draw) + SX_SIZE_DRAW_HEADER))
#define	SX_DRAW_STR_LIST(draw) \
	((unsigned char *)((draw) + SX_SIZE_DRAW_HEADER) \
		+ SX_DRAW_INT_COUNT((draw)) * 4)

/* XS header */
#define	XS_PROTOVERS_MAJOR(prop)	(*((CARD16 *)((prop) + 0))) /* 2 */
#define	XS_PROTOVERS_MINOR(prop)	(*((CARD16 *)((prop) + 2))) /* 2 */
#define	XS_SEQNO(prop)		(*((CARD32 *)((prop) + 4))) /* 4 */
#define	XS_ATOM_AUX_NAME(prop)	(*((CARD32 *)((prop) + 8))) /* 4 */
#define	XS_INDEX(prop)		(*((CARD16 *)((prop) + 12))) /* 2 */
#define	XS_PRIVTYPE(prop)	(*((CARD8 *)((prop) + 14))) /* 1 */
#define	XS_AUXTYPE(prop)	(*((CARD8 *)((prop) + 15))) /* 1 */
#define	XS_IMID(prop)		(*((CARD16 *)((prop) + 16))) /* 2 */
#define	XS_ICID(prop)		(*((CARD16 *)((prop) + 18))) /* 2 */
#define	XS_MORESEGS(prop)	(*((CARD16 *)((prop) + 20))) /* 2 */
#define	XS_SEGNO(prop)		(*((CARD16 *)((prop) + 22))) /* 2 */
#define	XS_SEGSIZE(prop)	(*((CARD32 *)((prop) + 24))) /* 4 */
#define	XS_SIZE_HEADER		28
#define	XS_DATA_TOP(prop)	((prop) + XS_SIZE_HEADER)

/* AUX_SETVALUE */
#define	XS_SETV_INT_COUNT(setvalue)	(*((CARD32 *)((setvalue) + 0))) /* 4 */
#define	XS_SETV_STR_COUNT(setvalue)	(*((CARD32 *)((setvalue) + 4))) /* 4 */
#define XS_SIZE_SETV_HEADER		8
#define	XS_SETV_INT_LIST(setvalue) \
	((CARD32 *)((setvalue) + XS_SIZE_SETV_HEADER))
#define	XS_SETV_STR_LIST(setvalue) \
	((unsigned char *)((setvalue) + XS_SIZE_SETV_HEADER) \
		+ XS_SETV_INT_COUNT((setvalue)) * 4)

/* byte order */
#define	BO_SWAP2(n)	((((*((CARD8 *)(n))) | 0x0000ff00) >> 8) | \
			 (((*((CARD8 *)(n))) | 0x000000ff) << 8))
#define	BO_SWAP4(n)	((((*((CARD8 *)(n))) | 0xff000000) >> 24) | \
			 (((*((CARD8 *)(n))) | 0x00ff0000) >> 8)  | \
			 (((*((CARD8 *)(n))) | 0x0000ff00) << 8)  | \
			 (((*((CARD8 *)(n))) | 0x000000ff) << 24))
							
#define	BO_CARD16(p, n)	((1 == (*((CARD16 *)(p)))) ? \
			 *((CARD16 *)(n)) : ((CARD16)(BO_SWAP2(n))))

#define	BO_CARD32(p, n)	((1 == (*((CARD16 *)(p)))) ? \
			 *((CARD32 *)(n)) : ((CARD32)(BO_SWAP4(n))))

#define	BO_PROTOVERS_MAJOR(prop)	((1 == (*((CARD16 *)(prop)))) ? \
					 (*((CARD16 *)((prop) + 0))) : \
					 BO_SWAP2((prop) + 0))
#define	BO_PROTOVERS_MINOR(prop)	((1 == (*((CARD16 *)(prop)))) ? \
					 (*((CARD16 *)((prop) + 2))) : \
					 BO_SWAP2((prop) + 2))
#define	BO_SEQNO(prop)			((1 == (*((CARD16 *)(prop)))) ? \
					 (*((CARD32 *)((prop) + 4))) : \
					 BO_SWAP4((prop) + 4))
#define	BO_ATOM_AUX_NAME(prop)		((1 == (*((CARD16 *)(prop)))) ? \
					 (*((CARD32 *)((prop) + 8))) : \
					 BO_SWAP4((prop) + 8))
#define	BO_INDEX(prop)			((1 == (*((CARD16 *)(prop)))) ? \
					 (*((CARD16 *)((prop) + 12))) : \
					 BO_SWAP2((prop) + 12))
#define	BO_PRIVTYPE(prop)		(*((CARD8 *)((prop) + 14)))
#define	BO_AUXTYPE(prop)		(*((CARD8 *)((prop) + 15)))
#define	BO_IMID(prop)			((1 == (*((CARD16 *)(prop)))) ? \
					 (*((CARD16 *)((prop) + 16))) : \
					 BO_SWAP2((prop) + 16))
#define	BO_ICID(prop)			((1 == (*((CARD16 *)(prop)))) ? \
					 (*((CARD16 *)((prop) + 18))) : \
					 BO_SWAP2((prop) + 18))
#define	BO_MORESEGS(prop)		((1 == (*((CARD16 *)(prop)))) ? \
					 (*((CARD16 *)((prop) + 20))) : \
					 BO_SWAP2((prop) + 20))
#define	BO_SEGNO(prop)			((1 == (*((CARD16 *)(prop)))) ? \
					 (*((CARD16 *)((prop) + 22))) : \
					 BO_SWAP2((prop) + 22))
#define	BO_SEGSIZE(prop)		((1 == (*((CARD16 *)(prop)))) ? \
					 (*((CARD32 *)((prop) + 24))) : \
					 BO_SWAP4((prop) + 24))

#define	BO_DRAW_SOWIN(prop)		((1 == (*((CARD16 *)(prop)))) ? \
					 (*((CARD32 *)((prop) + 28))) : \
					 BO_SWAP4((prop) + 28))
#define	BO_DRAW_CLIENTWIN(prop)		((1 == (*((CARD16 *)(prop)))) ? \
					 (*((CARD32 *)((prop) + 32))) : \
					 BO_SWAP4((prop) + 32))
#define	BO_DRAW_FOCUSWIN(prop)		((1 == (*((CARD16 *)(prop)))) ? \
					 (*((CARD32 *)((prop) + 36))) : \
					 BO_SWAP4((prop) + 36))
#define	BO_DRAW_POSX(prop)		((1 == (*((CARD16 *)(prop)))) ? \
					 (*((CARD16 *)((prop) + 40))) : \
					 BO_SWAP2((prop) + 40))
#define	BO_DRAW_POSY(prop)		((1 == (*((CARD16 *)(prop)))) ? \
					 (*((CARD16 *)((prop) + 42))) : \
					 BO_SWAP2((prop) + 42))
#define	BO_DRAW_INT_COUNT(prop)		((1 == (*((CARD16 *)(prop)))) ? \
					 (*((CARD32 *)((prop) + 44))) : \
					 BO_SWAP4((prop) + 44))
#define	BO_DRAW_STR_COUNT(prop)		((1 == (*((CARD16 *)(prop)))) ? \
					 (*((CARD32 *)((prop) + 48))) : \
					 BO_SWAP4((prop) + 48))
#define	BO_DRAW_TOTAL_STR_LEN(prop)	((1 == (*((CARD16 *)(prop)))) ? \
					 (*((CARD32 *)((prop) + 52))) : \
					 BO_SWAP4((prop) + 52))
#define BO_SIZE_DRAW_HEADER		28
#define	BO_DRAW_INT_LIST(prop) \
	((CARD32 *)((prop) + BO_SIZE_DRAW_HEADER))
#define	BO_DRAW_STR_LIST(prop) \
	((unsigned char *)((prop) + BO_SIZE_DRAW_HEADER) \
		+ BO_DRAW_INT_COUNT((prop)) * 4)

#define	BO_SETV_INT_COUNT(prop)		((1 == (*((CARD16 *)(prop)))) ? \
					 (*((CARD32 *)((prop) + 28))) : \
					 BO_SWAP4((prop) + 28))
#define	BO_SETV_STR_COUNT(prop)		((1 == (*((CARD16 *)(prop)))) ? \
					 (*((CARD32 *)((prop) + 32))) : \
					 BO_SWAP4((prop) + 32))
#define BO_SIZE_SETV_HEADER		8
#define	BO_SETV_INT_LIST(prop) \
	((CARD32 *)((prop) + BO_SIZE_SETV_HEADER))
#define	BO_SETV_STR_LIST(prop) \
	((unsigned char *)((prop) + BO_SIZE_SETV_HEADER) \
		+ BO_SETV_INT_COUNT((prop)) * 4)

#include	"xaux_atommng.h"

static const int	padding[4] = {0, 3, 2, 1};

#endif	/* !XAUX_COMMON_H */
