/*

Copyright (c) 2006 Kenji ABE <abek@terre-sys.com>

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.

*/

#include <string.h>

#include "utfcsdef.h"

size_t
utfcslen(
    const UTFCHAR *s
)
{
    int len = 0;
    while (*s++) { ++len; }
    return len;
}

UTFCHAR *utfcscpy(
    UTFCHAR *dest,
    const UTFCHAR *src
)
{
    int len = utfcslen(src);
    memcpy(dest, src, (len + 1) * sizeof(UTFCHAR));
    return dest + len;
}

UTFCHAR *
utfcsi2s(
    UTFCHAR *buff,
    int val
)
{
    char work[16], *p;
    snprintf(work, sizeof(work), "%d", val);
    p = work;
    while (*p) {
	*buff++ = *p++;
    }
    *buff = '\0';
    return buff;
}

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
