/*

Copyright (c) 2006 Yuuhei TERAMOTO <tera@terre-sys.com>

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.

*/

#ifndef TRANSINTRN_H_INCLUDED
#define TRANSINTRN_H_INCLUDED

#include <stdio.h>
#include "iconv.h"


#define PGC_TRANS_LAST ((size_t)-1)
#define PGC_TRANS_BUFUNIT (16)
#define PGC_TRANS_LENMAX (5)
#define PGC_TRANS_CHARMAX (6)


typedef struct pgc_trans_unit_rec pgc_trans_unit_rec;
typedef struct pgc_trans_rec pgc_trans_rec;

struct pgc_trans_unit_rec {
    size_t src_s; // point first position of translated input sequence.
    size_t src_e; // point end position of translated input sequence.
    unsigned char str[PGC_TRANS_LENMAX*PGC_TRANS_CHARMAX];
    int bytes;
};

struct pgc_trans_rec {
    size_t len;
    pgc_trans_unit_rec *data;
    size_t bufsize;
    pgc_trans_rec *next;
};

pgc_trans_rec*	pgc_trans_create();
pgc_trans_rec*	pgc_trans_dup( pgc_trans_rec *trsl );
void		pgc_trans_destroy( pgc_trans_rec *trsl );
pgc_trans_rec*	pgc_trans_add( pgc_trans_rec *trsl, pgc_trans_unit_rec *unit );
int		pgc_trans_reencode( iconv_t icd, pgc_trans_rec *trans );
int		pgc_trans_unit_count(pgc_trans_rec * trans, size_t *count);
int		pgc_trans_get_string( pgc_trans_rec *trans, size_t su, size_t eu,
				      size_t *sp, size_t *ep, unsigned char *buf, size_t bufsize );
int		pgc_trans_strcmp( pgc_trans_rec * t1, pgc_trans_rec * t2 );
int		pgc_trans_get_source_pos( pgc_trans_rec * trans, size_t su, size_t eu, size_t *sp, size_t *ep );
void		pgc_trans_list_destroy( pgc_trans_rec *list );
pgc_trans_rec*	pgc_trans_list_next( pgc_trans_rec *list, pgc_trans_rec * cur );
int		pgc_trans_list_size( pgc_trans_rec *list, size_t *size );
pgc_trans_rec*	pgc_trans_list_append( pgc_trans_rec * list, pgc_trans_rec * trans );
pgc_trans_rec*	pgc_trans_list_remove( pgc_trans_rec * lst, pgc_trans_rec * trans );
void		pgc_trans_print( pgc_trans_rec * trans, FILE *fp );

int set_translation_unit( pgc_trans_unit_rec *unit, unsigned char * p, size_t size, size_t src_s, size_t src_e );

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
#endif // TRANSINTRN_H_INCLUDED
