/*

Copyright (c) 2006 Yuuhei TERAMOTO <tera@terre-sys.com>

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.

*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#include <stdio.h>
#include "iconv.h"
#ifdef HAVE_ERRNO_H
#include <errno.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#include "phonogram_conv.h"

/*
 * phonogram_conv test tool.
 * Suppose that encode of stdin is euc-jp.
 */

static void output_trans( char *inbuf, pgc_trans trans );

int main(
int argc,
char *argv[]
)
{
    int exit_status = EXIT_SUCCESS;
    pgc_descriptor pgcd = NULL;
    iconv_t ic_eucutf8 = (iconv_t)-1, ic_utf8utf16 = (iconv_t)-1;
    size_t utf16bom=1;
    int ii;
    int eot=1;
    char encode[32];
    encode[0] = 0;


    for( ii = 1 ; ii < argc ; ii++ ){
	if( argv[ii][0] == '-' ){
	    if( argv[ii][1] == 't' ){
		eot = 0;
	    }else if( argv[ii][1] == 'e' ){
		strcpy( encode, argv[++ii] );
	    }
	}
    }
    if( encode[0] == 0 ){
	strcpy( encode, "EUC-JP" );
    }
    
    ic_eucutf8 = iconv_open( "UTF-8", encode );
    if( ic_eucutf8 == (iconv_t)-1 ){
	fprintf( stderr, "iconv_open() EUC-JP to UTF-8 fail. errno:%d\n", errno );
	goto err;
    }
    ic_utf8utf16 = iconv_open( "UTF-16", "UTF-8" );
    if( ic_utf8utf16 == (iconv_t)-1 ){
	fprintf( stderr, "iconv_open() UTF-8 to UTF-16 fail. errno:%d\n", errno );
	goto err;
    }

    pgcd = pgc_open( "./hirazen.data", encode );
    if( pgcd == NULL ){
	fprintf( stderr, "phongram_conv_open() fail. errno:%d\n", errno );
	goto err;
    }
    while( 1 ){
	char buf[256];
	char buf2[256*6];
	char buf3[256*2];
	char *pp, *inbuf, *outbuf;
	PGC_UTFCHAR *inbuf2;
	size_t inlen, inbytesleft, outbytesleft;
	pgc_trans trans;
	int res;

	if( fgets( buf, sizeof(buf), stdin ) == NULL ){
	    break;
	}
 	pp = strrchr( buf, '\n' );
	if( pp != NULL ){
	    *pp = 0;
	}
	inbuf = buf;
	inbytesleft = strlen(buf);
	if( inbytesleft == 0 ){
	    continue;
	}
	outbuf = buf2;
	outbytesleft = sizeof(buf2);
	if( iconv( ic_eucutf8, &inbuf, &inbytesleft, &outbuf, &outbytesleft ) == -1 ){
	    fprintf( stderr, "iconv() EUC to UTF-8 fail. errno:%d\n", errno );
	    goto err;
	}
	inbuf = buf2;
	inbytesleft = sizeof(buf2) - outbytesleft;
	outbuf = buf3;
	outbytesleft = sizeof(buf3);
	if( iconv( ic_utf8utf16, &inbuf, &inbytesleft, &outbuf, &outbytesleft ) == -1 ){
	    fprintf( stderr, "iconv() UTF-8 to UTF-16 fail. errno:%d\n", errno );
	    goto err;
	}
	inbuf2 = (PGC_UTFCHAR*)buf3 + utf16bom;
	inlen = ( sizeof(buf3) - outbytesleft ) / sizeof(PGC_UTFCHAR) - utf16bom;
	res = romaji_kana_convert( pgcd, inbuf2, inlen, eot, &trans );
	if( res == PGC_ACCEPTED ){
	    fprintf( stderr, "pgc_convert() ACCEPTED\n" );
	}else if( res == PGC_INPROCESS ){
	    fprintf( stderr, "pgc_convert() INPROCESS\n" );
	}else if( res == PGC_REJECTED ){
	    fprintf( stderr, "pgc_convert() REJECTED\n" );
	}else if( res < 0 ){
	    fprintf( stderr, "pgc_convert() fail. errno:%d\n", errno );
	    goto err;
	}
	output_trans( buf, trans );
	fprintf( stdout, "\n" );
//	pgc_trans_print( trans, stderr );
	pgc_trans_destroy( trans );
	utf16bom = 0;
    }
end:
    if( ic_eucutf8 != (iconv_t)-1 ){
	iconv_close( ic_eucutf8 );
    }
    if( ic_utf8utf16 != (iconv_t)-1 ){
	iconv_close( ic_utf8utf16 );
    }
    if( pgcd != NULL ){
	pgc_close( pgcd );
    }
    exit( exit_status );
err:
    if( exit_status == EXIT_SUCCESS ){
	exit_status = EXIT_FAILURE;
    }
    goto end;
}

void output_trans( char * inbuf, pgc_trans trans )
{
    size_t size, sp, ep;
    char *pp,*qq,*s1,*s2;

    pp = NULL; qq = NULL;
    if( pgc_trans_get_string( trans, 0, PGC_TRANS_LAST, &sp, &ep, NULL, 0 ) == 0 ){
	size = ep - sp;
	pp = malloc( size + 1 );
	if( pp != NULL ){
	    pgc_trans_get_string( trans, 0, PGC_TRANS_LAST, &sp, &ep, pp, size );
	    pp[size] = 0;
	    if( pgc_trans_get_source_pos( trans, 0, PGC_TRANS_LAST, &sp, &ep ) == 0 ){
		qq = inbuf + ep;
	    }
	}
    }
    if( pp == NULL ){
	s1 = "";
    }else{
	s1 = pp;
    }
    if( qq == NULL ){
	s2 = "";
    }else{
	s2 = qq;
    }
    fprintf( stdout, "%s\t%s\n", s1, s2 );
    free( pp );
}

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */



