/*

Copyright (c) 2006 Kenji ABE <abek@terre-sys.com>

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.

*/

#ifndef IM_CONV_H
#define	IM_CONV_H

#include "imdef.h"

#ifdef	__cplusplus
extern "C" {
#endif

typedef enum IM_CONV_MODE_tag {
	IM_CONV_MODE_NORMAL = 0,
	IM_CONV_MODE_PREDICT,
} IM_CONV_MODE;

extern Bool im_conv_init(void);
extern void im_conv_term(void);

extern im_conv_t im_conv_create(void);
extern void im_conv_free(im_conv_t conv);

extern void im_conv_reset(im_conv_t conv);

extern Bool im_conv_set_string(im_conv_t conv, const UTFCHAR *str, int len, IM_CONV_MODE mode);

extern int im_conv_length(im_conv_t conv);

extern int im_conv_cur_pos(im_conv_t conv);
extern int im_conv_cur_cand_index(im_conv_t conv);
extern int im_conv_cur_cand_count(im_conv_t conv);
extern Bool im_conv_cur_get_unconverted_range(im_conv_t conv, int *start, int *end);

extern Bool im_conv_cur_move_to_head(im_conv_t conv);
extern Bool im_conv_cur_move_to_tail(im_conv_t conv);
extern Bool im_conv_cur_move_prev(im_conv_t conv);
extern Bool im_conv_cur_move_next(im_conv_t conv);

extern Bool im_conv_cur_resize(im_conv_t conv, int delta);

extern Bool im_conv_cur_select_next(im_conv_t conv);
extern Bool im_conv_cur_select_prev(im_conv_t conv);
extern Bool im_conv_cur_select_cand(im_conv_t conv, int cand_no);
extern Bool im_conv_cur_select_unconverted(im_conv_t conv);

extern Bool im_conv_cur_set_string(im_conv_t conv, const UTFCHAR *str, int length);

extern IMText *im_conv_commit(im_conv_t conv, iml_session_t *session);

extern IMText *im_conv_make_preedit_text(im_conv_t conv, iml_session_t *session);
extern IMText *im_conv_make_cur_cand_text(im_conv_t conv, int cand_no, iml_session_t *session);

#ifdef __cplusplus
}
#endif

#endif /* IM_CONV_H */

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
