/*

Copyright (c) 2006 Kenji ABE <abek@terre-sys.com>

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.

*/

#include <stdlib.h>

#include "SunIM.h"

#include "dynbuff.h"

#define UNIT_SIZE (8)

dyn_buffer_t
dyn_buffer_create(void)
{
    return calloc(1, sizeof(dyn_buffer));
}

void
dyn_buffer_free(
    dyn_buffer_t buff
)
{
    if (buff) {
	if (buff->p) {
	    free(buff->p);
	}
	free(buff);
    }
}

int
dyn_buffer_ensure_size(
    dyn_buffer_t buff,
    size_t size
)
{
    if (buff == NULL) {
	return 0;
    }

    if (buff->capacity < size) {
	size_t s;
	void *p;

	s = size -1;
	s /= UNIT_SIZE;
	++s;
	s *= UNIT_SIZE;
	ASSERT(s >= size);
	ASSERT(s >= buff->capacity);

	p = realloc(buff->p, s);
	if (p) {
	    buff->p = p;
	    buff->capacity = s;
	}
/*	if (buff->p == NULL) {
	    buff->p = malloc(s);
	    if (buff->p) {
		buff->capacity = s;
	    }
	} else {
	    void *p = realloc(buff->p, s);
	    if (p) {
		buff->p = p;
		buff->capacity = s;
	    }
	}
*/
    }

    return size <= buff->capacity;
}

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
