/*

Copyright (c) 2006 Kenji ABE <abek@terre-sys.com>

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.

*/

#ifndef CONV_DEF_H
#define	CONV_DEF_H

#include <iconv.h>

#include "IMProtocolStruct.h"

#include "dynbuff.h"

#ifdef	__cplusplus
extern "C" {
#endif

typedef struct conv_data_t *conv_handle;

enum CONVERT_TYPE {
	CONVERT_TO_UTF16 = 0x01,
	CONVERT_FROM_UTF16 = 0x02,
	CONVERT_BOTH = CONVERT_TO_UTF16 | CONVERT_FROM_UTF16,
};

enum CONVERT_RESULT {
	CONVERT_FAIL = 0,
	CONVERT_SUCCESS = 1,
};

typedef struct {
    enum CONVERT_RESULT result;
    int src_length;
    int dest_length;
} conv_result;

conv_handle create_converter(const char *encoding, enum CONVERT_TYPE type);
void destroy_converter(conv_handle conv);

enum CONVERT_RESULT
convert_to_utf16(
    conv_handle conv,
    const char *src_buff,
    int src_buff_len,
    dyn_buffer_t dest_buff,
    conv_result *result
);

enum CONVERT_RESULT
convert_from_utf16(
    conv_handle conv,
    const UTFCHAR *src_buff,
    int src_buff_len,
    dyn_buffer_t dest_buff,
    conv_result *result
);

#ifdef __cplusplus
}
#endif

#endif /* CONV_DEF_H */

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
