/*
  Copyright 1990-2001 Sun Microsystems, Inc. All Rights Reserved.

  Permission is hereby granted, free of charge, to any person obtaining a
  copy of this software and associated documentation files (the
  "Software"), to deal in the Software without restriction, including
  without limitation the rights to use, copy, modify, merge, publish,
  distribute, sublicense, and/or sell copies of the Software, and to
  permit persons to whom the Software is furnished to do so, subject to
  the following conditions: The above copyright notice and this
  permission notice shall be included in all copies or substantial
  portions of the Software.


  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
  IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
  CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
  THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
  ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


  Except as contained in this notice, the names of The Open Group and/or
  Sun Microsystems, Inc. shall not be used in advertising or otherwise to
  promote the sale, use or other dealings in this Software without prior
  written authorization from The Open Group and/or Sun Microsystems,
  Inc., as applicable.


  X Window System is a trademark of The Open Group

  OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
  logo, LBX, X Window System, and Xinerama are trademarks of the Open
  Group. All other trademarks and registered trademarks mentioned herein
  are the property of their respective owners. No right, title or
  interest in or to any trademark, service mark, logo or trade name of
  Sun Microsystems, Inc. or its licensors is granted.

*/
#ifndef  SUNIMMTHD_H
#define  SUNIMMTHD_H

#include <stdio.h>
#include <sys/types.h>
#include <dirent.h>
#include <fcntl.h>
#include <unistd.h>
#include <utime.h>
#include <sys/stat.h>
#include <sys/uio.h>
#include <sys/time.h>
#include "IMProtocolStruct.h"

#if defined(sun)
#include <thread.h>
#elif defined(WIN32)
#include <windows.h>
#else
#include <pthread.h>
#endif

#ifdef ENABLE_EIMIL
#include <EIMIL.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef struct _iml_nsc *iml_nsc_t;
typedef struct _iml_hkc *iml_hkc_t;
typedef struct _iml_desktop_t *iml_desktop_list;
typedef struct _iml_session *iml_session;
typedef struct _iml_if_t *iml_if;
typedef struct _iml_aux *iml_aux;
typedef iml_session iml_session_list;

typedef void *(*iml_nsc_create_t) (const char *, int , void *);
typedef void (*iml_nsc_free_t) (iml_nsc_t);
typedef int (*iml_nsc_open_t) (iml_nsc_t, const char *, int, ...);
typedef size_t (*iml_nsc_read_t) (iml_nsc_t, int, void *, size_t);
typedef size_t (*iml_nsc_write_t) (iml_nsc_t, int, void *, size_t);
typedef int (*iml_nsc_close_t) (iml_nsc_t, int);
typedef int (*iml_nsc_mkdir_t) (iml_nsc_t, const char *, mode_t);
typedef int (*iml_nsc_rmdir_t) (iml_nsc_t, const char *);
typedef int (*iml_nsc_symlink_t) (iml_nsc_t, const char *, const char *);
typedef int (*iml_nsc_stat_t) (iml_nsc_t, const char *, struct stat *);
typedef int (*iml_nsc_lstat_t) (iml_nsc_t, const char *, struct stat *);
typedef off_t (*iml_nsc_lseek_t) (iml_nsc_t, int, off_t, int);
typedef int (*iml_nsc_unlink_t) (iml_nsc_t, const char *);
typedef int (*iml_nsc_rename_t) (iml_nsc_t, const char *, const char *);
typedef int (*iml_nsc_fcntl_t) (iml_nsc_t, int, int, int);
typedef int (*iml_nsc_truncate_t) (iml_nsc_t, const char *, off_t);
typedef int (*iml_nsc_ftruncate_t) (iml_nsc_t, int, off_t);
typedef DIR *(*iml_nsc_opendir_t) (iml_nsc_t, const char *);
typedef struct dirent *(*iml_nsc_readdir_t) (iml_nsc_t, DIR *);
typedef int (*iml_nsc_closedir_t) (iml_nsc_t, DIR *);
typedef int (*iml_nsc_access_t) (iml_nsc_t, const char *, int);
typedef int (*iml_nsc_chmod_t) (iml_nsc_t, const char *, mode_t);
typedef int (*iml_nsc_chown_t) (iml_nsc_t, const char *, uid_t, gid_t);
typedef long (*iml_nsc_fpathconf_t) (iml_nsc_t, int, int);
typedef int (*iml_nsc_fstat_t) (iml_nsc_t, int, struct stat *);
typedef int (*iml_nsc_link_t) (iml_nsc_t, const char *, const char *);
typedef long (*iml_nsc_pathconf_t) (iml_nsc_t, char *, int);
typedef ssize_t (*iml_nsc_readv_t) (iml_nsc_t, int, const struct iovec *, int);
typedef ssize_t (*iml_nsc_writev_t) (iml_nsc_t, int, const struct iovec *, int);
typedef long (*iml_nsc_ulimit_t) (iml_nsc_t, int, long);
typedef mode_t (*iml_nsc_umask_t) (iml_nsc_t, mode_t);
typedef int (*iml_nsc_utime_t) (iml_nsc_t, const char *, const struct utimbuf *);
typedef int (*iml_nsc_utimes_t) (iml_nsc_t, char *, struct timeval *);

typedef struct _iml_file_status {
  char* path_name;
  int ns_id;
  char **d_name;
  int **d_reclen;
  int nitems;
  int fd;
  DIR *dirp;
  struct _iml_file_status *next;
} iml_file_status_t;

typedef iml_file_status_t *file_status_list;

typedef struct _iml_nsc_private {
  int location;
  int ns_type;
  void *ns_owner;
  file_status_list fslist;
} iml_nsc_private;

typedef struct _iml_nsc {
    iml_nsc_private *value;
} iml_nsc;

typedef struct _iml_hkc_private {
  int hk_type;
  void *hk_owner;
} iml_hkc_private;

typedef void *(*iml_hkc_create_t) (const char *, int , void *);
typedef void (*iml_hkc_free_t) (iml_hkc_t);

typedef struct _iml_hkc {
    iml_hkc_private *value;
} iml_hkc;

typedef struct _iml_nsl {
    char *path_name;
    void *calldata;
} iml_nsl;

typedef struct _iml_nsc_basic_fioset {
    int (*open) (iml_nsc_t, const char *, int, ...);
    size_t (*read) (iml_nsc_t, int, void *, size_t);
    int (*stat) (iml_nsc_t, const char *, struct stat *);
    size_t (*write) (iml_nsc_t, int, void *, size_t);
    int (*close) (iml_nsc_t, int);
    int (*mkdir) (iml_nsc_t, const char *, mode_t);
    int (*rmdir) (iml_nsc_t, const char *);
    int (*symlink) (iml_nsc_t, const char *, const char *);
    int (*lstat) (iml_nsc_t, const char *, struct stat *);
    int (*creat) (iml_nsc_t, const char *, mode_t);
    off_t (*lseek) (iml_nsc_t, int, off_t, int);
    int (*unlink) (iml_nsc_t, const char *);
    int (*rename) (iml_nsc_t, const char *, const char *);
    int (*fcntl) (iml_nsc_t, int, int, int);
    int (*truncate) (iml_nsc_t, const char *, off_t);
    DIR *(*opendir) (iml_nsc_t, const char *);
    struct dirent *(*readdir) (iml_nsc_t, DIR *);
    int (*closedir) (iml_nsc_t, DIR *);
    int (*fstat) (iml_nsc_t, int, struct stat *);
    int (*ftruncate) (iml_nsc_t, int, off_t);
} iml_nsc_basic_fioset_t;

typedef int listener_id_t;

typedef struct _iml_listener {
    iml_session s;
    char* listener_name ;
    listener_id_t listener_id ; /* identify the listener */
    void* (*listener)(listener_id_t listener_id, 
                      int size, /* Size of the file read */
		      void* public_data, /* buf contain the data retrieved */
		      void* private_data /* data passed via addlistener */
    );
    void* private_data ; /* store the "value" passed by addlistner */
    struct _iml_listener *next;	/* link */
} iml_listener_t ;

typedef iml_listener_t *iml_listener_list;

typedef struct _iml_desktop_t {
    /* public */
    iml_if If;				/* parent IF */

    char *user_name;			/* user info */
    char *host_name;			/* user info */
    char *display_id;			/* user info */

    void *specific_data;		/* specific data for desktop */

    iml_session_list session_list;
    int session_count;

    /* private */
    struct _iml_desktop_t *next;	/* link */

/*
 * Added to bottom for binary compatibility 
 */
    /* public */
    listener_id_t (*addListenerToDesktop)(iml_session, void *, void *); 
    iml_listener_t *(*lookupListenerFromDesktop)(iml_session, int) ;
    void (*deleteListenerFromDesktop)(iml_session, int);

    /* private */
    int listener_id;
    int listener_count;
    iml_listener_list l_list ;

    char *client_group;

}   iml_desktop_t;

typedef struct _iml_methods {
    iml_inst *(*iml_make_preedit_start_inst) (iml_session);
    iml_inst *(*iml_make_preedit_draw_inst) (iml_session, IMText *);
    iml_inst *(*iml_make_preedit_draw_with_chgpos_inst) (iml_session, IMText *, int, int, int);
    iml_inst *(*iml_make_preedit_erase_inst) (iml_session);
    iml_inst *(*iml_make_preedit_caret_inst) (iml_session, int);
    iml_inst *(*iml_make_preedit_done_inst) (iml_session);

    iml_inst *(*iml_make_status_start_inst) (iml_session);
    iml_inst *(*iml_make_status_draw_inst) (iml_session, IMText *);
    iml_inst *(*iml_make_status_done_inst) (iml_session);

    iml_inst *(*iml_make_lookup_start_inst) (iml_session, IMLookupStartCallbackStruct *);
    iml_inst *(*iml_make_lookup_draw_inst) (iml_session, IMLookupDrawCallbackStruct *);
    iml_inst *(*iml_make_lookup_done_inst) (iml_session);

    iml_inst *(*iml_make_start_conversion_inst) (iml_session);
    iml_inst *(*iml_make_end_conversion_inst) (iml_session);

    iml_inst *(*iml_make_commit_inst) (iml_session, IMText *);
    iml_inst *(*iml_make_keypress_inst) (iml_session, IMKeyEventStruct *);

    iml_inst *(*iml_make_aux_start_inst) (iml_session, IMAuxStartCallbackStruct *);
    iml_inst *(*iml_make_aux_draw_inst) (iml_session, IMAuxDrawCallbackStruct *);
    iml_inst *(*iml_make_aux_done_inst) (iml_session, IMAuxDoneCallbackStruct *);
    void *(*iml_new) (iml_session, int);
    void *(*iml_new2) (iml_session, int);
    void *(*iml_delete) (iml_session);
    void *(*iml_delete2) (iml_session);

    iml_inst *(*iml_link_inst_tail) (iml_inst **, iml_inst *);
    iml_inst *(*iml_execute) (iml_session, iml_inst **);

    int (*iml_add_listener)(iml_session, char *, void *, void *);
    int (*iml_delete_listener)(iml_session, int listener_id);

    void *(*iml_getvalue) (iml_session, char *, void *);
    void (*iml_setvalue) (iml_session, char *, void *);

}   iml_methods_t;

/* Convenient functions, which are the wrapper of low level of iml methods */
typedef struct _iml_methods_wrapper {
  void (*iml_commit) (iml_session, UTFCHAR *);
  void (*iml_forward_keypress) (iml_session, IMKeyEventStruct *);
  void (*iml_conversion_on) (iml_session);
  void (*iml_conversion_off) (iml_session);
  void (*iml_status_start) (iml_session);
  void (*iml_status_end) (iml_session);
  void (*iml_status_draw) (iml_session, UTFCHAR *);
  void (*iml_preedit_start) (iml_session);
  void (*iml_preedit_end) (iml_session);
  void (*iml_preedit_draw) (iml_session, UTFCHAR *, int);
  void (*iml_lookup_start) (iml_session, LayoutInfo *);
  void (*iml_lookup_end) (iml_session);
  void (*iml_lookup_draw) (iml_session, int, UTFCHAR **,
			   IMFeedbackList **, UTFCHAR **,
			   IMFeedbackList **, UTFCHAR *,
			   IMFeedbackList *, int, int);
  void (*iml_aux_start) (iml_session, char *);
  void (*iml_aux_done) (iml_session, char *);
  void (*iml_aux_draw) (iml_session, char *, int, int *, int, int *, UTFCHAR **);
} iml_methods_wrapper_t;

typedef struct _if_methods {
    Bool(*if_OpenIF) (iml_if);
    Bool(*if_CloseIF) (iml_if);
    Bool(*if_GetIFValues) (iml_if, IMArgList, int);
    Bool(*if_SetIFValues) (iml_if, IMArgList, int);

    Bool(*if_OpenDesktop) (iml_desktop_t *, IMArgList, int);
    Bool(*if_CloseDesktop) (iml_desktop_t *);

    Bool(*if_CreateSC) (iml_session, IMArgList, int);
    Bool(*if_DestroySC) (iml_session);
    Bool(*if_GetSCValues) (iml_session, IMArgList, int);
    Bool(*if_SetSCValues) (iml_session, IMArgList, int);

    IMText *(*if_ResetSC) (iml_session);

    void (*if_SetSCFocus) (iml_session);
    void (*if_UnsetSCFocus) (iml_session);

    void (*if_SendEvent) (iml_session, IMInputEvent *);
}   if_methods_t;

enum IM_HOTKEY_SCOPE {
  GLOBAL_HOTKEY = 0x0,
  SESSION_SPECIFIC_HOTKEY = 0x1
};

enum IML_CONTEXT_ID {
  IML_NSC_TYPE_LE = 1,
  IML_NSC_TYPE_DESKTOP,
  IML_HKC_TYPE_LE,
  IML_HKC_TYPE_DESKTOP,
  IML_CONTEXT_NUM
};

enum IML_NS_LOCATION_ID {
  NS_LOCAL = 1,
  NS_REMOTE,
  NS_DATABASE,
  NS_LOCATION_NUM
};

/*
 * Per interface data structure
 */
typedef struct _IMHotkeyStruct {
  char *label;
  int state_flag;
  int action_flag;
  int nkeys;
  IMKeyEventStruct *keys;
} IMHotkeyStruct;

typedef struct _IMHotkeyProfileStruct {
  IMLEName *name;
  int profile_id;
  int scope;
  int num_hotkeys;
  IMHotkeyStruct *hks;
} IMHotkeyProfileStruct;

typedef struct _IMHotkeyManagerStruct {
  int num_hotkey_profiles;
  IMHotkeyProfileStruct *hkps;
} IMHotkeyManagerStruct;

typedef struct _IMNsMapStruct {
  char *if_name;
  char *src_entry;
  char *dest_entry;
  char *location;
} IMNsMapStruct;

typedef struct _iml_if_t {
    /* public */
    char *if_name;				/* id */
    char *if_version;				/* version */
    char *locale;				/* locale */

    iml_methods_t *m;				/* link for iml methods */

    iml_desktop_list desktop_list;		/* list for child desktop */
    int desktop_count;

    char *ifpath_name;				/* location of if module */

    /* private */
    if_methods_t *ifm;

    void *dl_module;

    IMLEName *lename;
    IMLocale *locale_list;
    IMObjectDescriptorStruct *object_list;
    Bool xsunim;
    Bool need_thread_lock;
#ifdef	USE_SUNIM_ADAPTER
    Bool need_adapter;
#endif	/* USE_SUNIM_ADAPTER */

#ifdef ENABLE_EIMIL
    EIMIL_handle eh;
#endif

/*
 * Added to bottom for binary compatibility
 */
    IMHotkeyManagerStruct *hkm;

    void *(*nsc_get_function) (const char *);
    void *(*hkc_get_function) (const char *);

    /* Method for updating the supported language list per LE */
    int (*updateSupportedLocales) (iml_desktop_t *, IMLEName *, IMLocale *, int);

    /* Method for switching hotkey profiles from LE */
    int (*switchLEProfile) (iml_session, int, IMLEName *);

    int num_nsm_entries;
    IMNsMapStruct *ns_map;

    Bool need_keyrelease;
    IMEInfo *imeinfo_list;
    Bool need_capslock;

    iml_methods_wrapper_t *m_wrapper; /* convenient functions */
}   iml_if_t;

typedef enum {
	IF_VERSION = 1,
	IF_METHOD_TABLE,
	IF_LE_NAME,
	IF_SUPPORTED_LOCALES,
	IF_SUPPORTED_OBJECTS,
#ifdef	USE_SUNIM_ADAPTER
	IF_NEED_THREAD_LOCK,
	IF_HAVE_LOCALE_DEPENDENCY,
#else	/* USE_SUNIM_ADAPTER */
	IF_NEED_THREAD_LOCK,
#endif	/* USE_SUNIM_ADAPTER */

	/* EIMIL extension */
	IF_EIMIL_HANDLE = 0x100,

	/* LE extension */
	IF_SUPPORTED_KEYRELEASE,
	IF_SUPPORTED_IMEINFO,

	/* HOTKEY */
	IF_HOTKEY_INFO,
	IF_SUPPORTED_CAPSLOCK,

}   IF_Attribute;

typedef enum {
	SC_REALIZE = 1,
	SC_TRIGGER_ON_NOTIFY,
	SC_TRIGGER_OFF_NOTIFY,
	SC_SUPPORTED_CHARACTER_SUBSETS,

	SC_PREFERED_OBJECTS = 64,
	SC_SUPPORTED_CLASSES = 65,
	SC_LOOKUP_NROWS = 100,		/* for compatibility purpose */
	SC_LOOKUP_NCOLS,			/* for compatibility purpose */
	SC_LOOKUP_LABELTYPE,		/* for compatibility purpose */

	SC_CLIENT_LOCALE = 200,
	SC_CLIENT_CHARACTER_SUBSETS,
	SC_CLIENT_INPUT_METHOD_NAME,
	SC_CLIENT_INPUT_METHOD_ENGINE,
	SC_CLIENT_KBD_LAYOUT
}   SC_Attribute;

typedef enum {
	UI_USER_NAME = 1,
	UI_HOST_NAME,
	UI_DISPLAY_ID,
	UI_PROTOCOL_TYPE,
	UI_CLIENT_TYPE,
	UI_OS_NAME,
	UI_OS_ARCH,
	UI_OS_VERSION,
	UI_XSERVER_VENDOR,
	UI_AUTH_PASSWD,
	UI_CLIENT_GROUP
}   UI_Attribute;

#define	MAX_UI_ATTRIBUTE	UI_CLIENT_GROUP

#define UI_PROTOCOL_TYPE_IIIMP	"IIIMP"
#define UI_PROTOCOL_TYPE_XIMP	"XIMP"
#define UI_PROTOCOL_TYPE_XIMCP	"XIMCP"

#define UI_CLIENT_TYPE_JAVA	"JAVA"
#define UI_CLIENT_TYPE_X	"X"
#define UI_CLIENT_TYPE_UNKNOWN	"Unknown"

#ifdef __cplusplus
}
#endif

#endif				/* SUNIMMTHD_H */
/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
