/*
Copyright 1990-2001 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#include "xiiimp.h"
#include "guiIM.h"
#include "composeIM.h"
#include "status.h"
#include "iiimpIM.h"

static Bool
setup_local_status_ext(XicCommon ic)
{
  LocalStatusExt *hook;

  if (!ic->local_icpart) return False;

  hook = (LocalStatusExt *)(ic->local_icpart->status_ext);
  if (hook) return (True);

  hook = (LocalStatusExt *)Xmalloc(sizeof(LocalStatusExt));
  if(!hook)
    return (False);
  memset(hook, 0, sizeof(LocalStatusExt));

  ic->local_icpart->status_ext = hook;
  return(True);
}

/* public */
void
Ximp_Local_Status_Create(XicCommon ic) {
  setup_local_status_ext(ic);
  return;
}

void
Ximp_Local_Status_Start(XicCommon ic) {
  LocalStatusExt *hook;

  if (!ic->local_icpart) return;

  hook = (LocalStatusExt *)(ic->local_icpart->status_ext);
  if (!hook) {
    if (!setup_local_status_ext(ic))
      return;
    hook = (LocalStatusExt *)(ic->local_icpart->status_ext);
  }
  XIC_GUI(ic, change_status)((XIC)ic, STATUS_START, NULL);
}

void
Ximp_Local_Status_Draw(XicCommon ic) {
  LocalStatusExt *hook;
  XIMDrawTextStruct status_draw;

  if (!(ic->ximp_icpart->value_mask & XIMP_CLIENT_WIN) ||
      !ic->core.client_window || !ic->local_icpart)
    return;

  hook = (LocalStatusExt *)(ic->local_icpart->status_ext);
  if (!hook) {
    Ximp_Local_Status_Start(ic);
    hook = (LocalStatusExt *)(ic->local_icpart->status_ext);
    if (!hook) return;
  }
  if (hook->text.length == 0) return;

  if (XIM_USE_UNICODE(ic->core.im)) {
    XIMText status_text;
    size_t native_len = 64;	/* enough */
    char buffer[64], *pbuffer;
    memset(&buffer, 0, 64);
    pbuffer = buffer;

    memset(&status_text, 0, sizeof(XIMText)) ;
    if (IMConvertFromUTF8(hook->text.string.multi_byte,
			  strlen(hook->text.string.multi_byte),
			  (char**)&pbuffer, &native_len) != -1) {
      status_text.string.multi_byte = buffer;
      status_text.length = 64 - native_len;
    } else {
      status_text.string.multi_byte = hook->text.string.multi_byte;
      status_text.length = strlen(hook->text.string.multi_byte);
    }
    status_draw.call_data = (XPointer)&status_text;
    status_draw.feedback_list = 0;
    XIC_GUI(ic, change_status)((XIC)ic, STATUS_DRAW, (XPointer)&status_draw);
  } else {
    status_draw.call_data = (XPointer)&hook->text;
    status_draw.feedback_list = 0;
    XIC_GUI(ic, change_status)((XIC)ic, STATUS_DRAW, (XPointer)&status_draw);
  }
  return;
}

void
Ximp_Local_Status_Window(XicCommon ic) {
  XIC_GUI(ic, change_status)((XIC)ic, STATUS_WIN, (XPointer)NULL);
  return;
}

void
Ximp_Local_Status_Done(XicCommon ic) {
  /* do nothing */
  return;
}

void
Ximp_Local_Status_Destroy(XicCommon ic) {
  LocalStatusExt *hook;

  if (!ic->local_icpart) return;

  hook = (LocalStatusExt *)(ic->local_icpart->status_ext);
  if (!hook) return;

  Xfree(hook);
  ic->local_icpart->status_ext = 0;
  return;
}

void
Ximp_Local_Status_Set(XicCommon ic) {
  LocalIMState *imstate;
  LocalStatusExt *hook;
  char	*state_name;

  if (!ic->local_icpart) return;

  imstate = ic->local_icpart->imstate;
  hook = (LocalStatusExt *)(ic->local_icpart->status_ext);
  if (!hook) {
    if (!setup_local_status_ext(ic))
      return;
    hook = (LocalStatusExt *)(ic->local_icpart->status_ext);
  }

  state_name = imstate->name;
  hook->text.string.multi_byte = state_name;
  hook->text.length = strlen(state_name);
  hook->text.feedback = 0;
  hook->text.encoding_is_wchar = False;
  return;
}

#if 0
static Bool
_Ximp_local_repaint_status(d, w, ev, client_data)
    Display *d;
    Window w;
    XEvent *ev;
    XPointer client_data;
{
  XicCommon ic = (XicCommon)client_data;
  LocalStatusExt  *hook = (LocalStatusExt *)(ic->local_icpart->status_ext);

  if(!hook)
    return (True);

  Ximp_Local_Status_Draw(ic);

  return(True);
}
#endif

void
Ximp_Local_Status_Reset(XicCommon ic) {
  Ximp_Local_Status_Set(ic);
  Ximp_Local_Status_Draw(ic);
  return;
}
