/*
Copyright 1990-2001 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifndef _commonIM_h
#define _commonIM_h

#ifndef __XLIBINT_HH
#define __XLIBINT_HH
#include <X11/Xlibint.h>
#endif /* __XLIBINT_HH */
#include "Xlcint.h"
#include "XlcPublic.h"

#include "XIM.h"

#define XIM_COMPOSE_KEYCODE 0

/* forward declaration */
typedef struct _XimCommon *XimCommon;
typedef struct _XicCommon *XicCommon;

typedef struct _XIMXimpRec *XIMXimp;
typedef struct _XIMPopupRec *XIMPopup;
typedef struct _XIMGUIRec *XIMGUI;
typedef struct _XIMDLRec *XIMDL;
typedef struct _XIMComposeIMRec *XIMComposeIM;
typedef struct _XIMIIimpIMRec *XIMIIimpIM;

typedef struct _XICXimpRec *XICXimp;
typedef struct _XICPopupRec *XICPopup;
typedef struct _XICGUIRec *XICGUI;
typedef struct _XICComposeIMRec *XICComposeIM;
typedef struct _XICIIimpIMRec *XICIIIMP;

typedef struct _SwitcherInfo SwitcherInfo;
typedef struct _SwitcherContext SwitcherContext;

typedef struct _XimCommon {
  XIMMethods	methods;
  XIMCoreRec	core;
  XIMXimp	ximp_impart;	/* has to be just after XIMCoreRec */

  XlcConv	mtow_conv;
  XlcConv	wtom_conv;

  XIMPopup	popup_impart;
  XIMGUI	gui_impart;
  XIMDL		dl_impart;

  Bool		isUnicode;	/* always use UTF16 encoding */
  XIMUnicodeCharacterSubsets	*unicode_char_subsets;

  /* XIM private part */
  XIMComposeIM	local_impart;	/* must be null when IIIMP only */
  XIMIIimpIM	iiimp_impart;	/* must be null when localIM only */

  SwitcherInfo *switcher_info;
} XimCommonRec;

#define XIM_USE_UNICODE(im) ((XimCommon)im)->isUnicode

#define XIM_POPUP(im, field) ((XimCommon)im)->popup_impart->field
#define XIM_IIIMP(im, field) ((XimCommon)im)->iiimp_impart->field
#define XIM_COMPOSE(im, field) ((XimCommon)im)->local_impart->field
#define XIM_GUI(im, field) ((XimCommon)im)->gui_impart->field

#define XIM_IS_IIIMP(im) ((XimCommon)im)->iiimp_impart
#define XIM_IS_COMPOSE(im) ((XimCommon)im)->local_impart
#define XIM_IS_SWITCH(im) (XIM_IS_IIIMP(im) && XIM_IS_COMPOSE(im))

typedef enum {
  Switch_ON = 1,
  Switch_OFF = 2,
  Switch_NOP = 3
} SwitchMode;

typedef SwitchMode (*SwitchKeyEventProc)(XicCommon, XEvent*);

typedef struct _SwitchFilter {
  struct _SwitchFilter *next;
  SwitchKeyEventProc is_switch_key;
  XFilterEventProc key_filter;
  XICMethods ic_methods;
} SwitchFilterEventRec, *SwitchFilterEventList;

typedef struct _XicCommon {
  XICMethods	methods;
  XICCoreRec	core;
  XICXimp	ximp_icpart;

  XICPopup	popup_icpart;
  XICGUI	gui_icpart;

  /* XIC private part */
  XICComposeIM	local_icpart;	/* must be null when IIIMP only */
  XICIIIMP	iiimp_icpart;	/* must be null when localIM only */

  XIMCallback	switchim_notify_callback;
  XIMCallback	commit_string_callback;
  XIMCallback	forward_event_callback;

  XIMUnicodeCharacterSubsetID	subset_id;

  XIMCallback	lookup_start_callback;
  XIMCallback	lookup_draw_callback;
  XIMCallback	lookup_done_callback;

  Bool (*active_filter)(Display *, Window, XEvent *, XPointer);
  XICMethods active_methods;
  struct _SwitchFilter *switch_filters;

  SwitcherContext *switcher_context; /* per context */
  char *current_language;
#ifdef HAS_IIIM_PROPERTIES
  char *current_le;
  int kbd_layout;
#endif /* HAS_IIIM_PROPERTIES */  
  Window client_toplevel;		/* Save client top level window */
} XicCommonRec;

#define XIC_POPUP(ic, field) ((XicCommon)ic)->popup_icpart->field
#define XIC_IIIMP(ic, field) ((XicCommon)ic)->iiimp_icpart->field
#define XIC_COMPOSE(ic, field) ((XicCommon)ic)->local_icpart->field
#define XIC_GUI(ic, field) ((XicCommon)ic)->gui_icpart->field

extern Status  CommonOpenIM(XIM xim, XLCd lcd, Display *dpy, XrmDatabase rdb,
			    char *res_name, char *res_class);
extern Status CommonCreateIC(XIC xic, XIMArg *arg);
extern Status CommonDestroyIC(XIC xic);
extern Status CommonCloseIM(XIM xim);

#endif
