#ifndef IIIMPUTIL_HH_
#define IIIMPUTIL_HH_
#include <string>
#include <iiimp.h>
#include "basictype.hh"
#include "IMBasicObject.hh"
#include "IMHandler.hh"
#include "ICHandler.hh"

extern ICAttribute convert_iiimp_icattr(
    IIIMP_icattribute *pattr
);
extern IIIMP_string* convert_IMText_to_iiimp_string(
    IIIMP_data_s *data_s,
    IMText *pimtext
);
extern IIIMP_text* convert_IMText_to_iiimp_text(
    IIIMP_data_s *data_s,
    IMText *pimtext
);
extern IIIMP_contents* convert_IMText_to_iiimp_contents_string(
    IIIMP_data_s *data_s,
    IMText *pimtext
);
extern IIIMP_contents* convert_IMText_to_iiimp_contents_text(
    IIIMP_data_s *data_s,
    IMText *pimtext
);

extern IIIMP_card16 convert_IMObject_type_to_iiimp_predefined_attribid(
    enum IMObject::OBJTYPE otype
);

extern bool iiimp_string_compare_with_ascii(
    IIIMP_string *iiimp_str,
    const char *str
);

#define CONV_IIIMP_STR(ps) (((ps)->len > 0) ? u16string((ps)->ptr, (ps)->len) : u16string(""))

#endif /* not IIIMPUTIL_HH_ */

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
