#ifndef _CHARCODE_H
#define _CHARCODE_H


/* ---------------------- xcintool .h ------------------------ */
#ifndef WCH_SIZE
#define WCH_SIZE  4
typedef union
{
    unsigned char s[WCH_SIZE];
    wchar_t wch;   // int type defined in stdlib.h
} wch_t;
#endif
/* -------------------- xcintool.h ------------------ */
typedef unsigned char ubyte_t;
typedef signed char byte_t;  // xcintool.h

/* -------------------- module.h --------------------- */

#define  N_CCODE_RULE           5       /* # of rules of encoding */
#define  N_ASCII_KEY            95      /* Num of printable ASCII char */

/* For encoding check. */
typedef struct {
    short n;
    ubyte_t begin[N_CCODE_RULE], end[N_CCODE_RULE];
} charcode_t;


typedef struct 
{
    unsigned int total_char;
    ubyte_t n_ch_encoding;
    charcode_t ccode[WCH_SIZE];
} ccode_info_t;    

/* -------------- */

#define N_CCODE_RULE 5  /* # of rules of encoding  (module.h) */
#define RESTBIT 6       /* for unicode conversion */

typedef struct
{
    short n;
    ubyte_t begin[N_CCODE_RULE], end[N_CCODE_RULE];
    short num[N_CCODE_RULE], ac_num[N_CCODE_RULE];
    short total_num;
    unsigned long base;
} ccode_t;

void ccode_init(charcode_t *, int);
void ccode_info(ccode_info_t *);
int ccode_to_char(int, unsigned char *, int);
void load_syscin(const char *);
int isBigEndian();
wchar_t endianConversion(wchar_t, int);
wchar_t UTF8toUnicode( wchar_t );
int UTFCHARLen( UTFCHAR*);
int UTFCHARCpy( UTFCHAR *, UTFCHAR *);
int utf8_to_utf16(char *, char *, int);

#endif
