/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.codeassist;

import java.util.Locale;
import java.util.Map;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.codeassist.ISearchRequestor;
import org.eclipse.jdt.internal.codeassist.ISelectionRequestor;
import org.eclipse.jdt.internal.codeassist.SelectionEngine;
import org.eclipse.jdt.internal.codeassist.impl.AssistParser;
import org.eclipse.jdt.internal.codeassist.impl.Engine;
import org.eclipse.jdt.internal.codeassist.select.SelectionNodeFound;
import org.eclipse.jdt.internal.codeassist.select.SelectionOnImportReference;
import org.eclipse.jdt.internal.codeassist.select.SelectionOnPackageReference;
import org.eclipse.jdt.internal.codeassist.select.SelectionOnQualifiedTypeReference;
import org.eclipse.jdt.internal.codeassist.select.SelectionOnSingleTypeReference;
import org.eclipse.jdt.internal.codeassist.select.SelectionParser;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.ISourceType;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MemberTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.eclipse.jdt.internal.compiler.parser.ScannerHelper;
import org.eclipse.jdt.internal.compiler.parser.SourceTypeConverter;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.core.SearchableEnvironment;
import org.eclipse.jdt.internal.core.SelectionRequestor;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.jdt.internal.core.SourceTypeElementInfo;
import org.eclipse.jdt.internal.core.util.ASTNodeFinder;

public final class SelectionEngine
extends Engine
implements ISearchRequestor {
    public static boolean DEBUG = false;
    public static boolean PERF = false;
    SelectionParser parser;
    ISelectionRequestor requestor;
    boolean acceptedAnswer;
    private int actualSelectionStart;
    private int actualSelectionEnd;
    private char[] selectedIdentifier;
    private char[][][] acceptedClasses;
    private int[] acceptedClassesModifiers;
    private char[][][] acceptedInterfaces;
    private int[] acceptedInterfacesModifiers;
    private char[][][] acceptedEnums;
    private int[] acceptedEnumsModifiers;
    private char[][][] acceptedAnnotations;
    private int[] acceptedAnnotationsModifiers;
    int acceptedClassesCount;
    int acceptedInterfacesCount;
    int acceptedEnumsCount;
    int acceptedAnnotationsCount;
    boolean noProposal = true;
    CategorizedProblem problem = null;

    public SelectionEngine(SearchableEnvironment nameEnvironment, ISelectionRequestor requestor, Map settings) {
        super(settings);
        this.requestor = requestor;
        this.nameEnvironment = nameEnvironment;
        ProblemReporter problemReporter = new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), this.compilerOptions, new DefaultProblemFactory(Locale.getDefault())){

            public CategorizedProblem createProblem(char[] fileName, int problemId, String[] problemArguments, String[] messageArguments, int severity, int problemStartPosition, int problemEndPosition, int lineNumber, int columnNumber) {
                CategorizedProblem pb = super.createProblem(fileName, problemId, problemArguments, messageArguments, severity, problemStartPosition, problemEndPosition, lineNumber, columnNumber);
                if (SelectionEngine.this.problem == null && pb.isError() && (pb.getID() & 0x40000000) == 0) {
                    SelectionEngine.this.problem = pb;
                }
                return pb;
            }
        };
        this.lookupEnvironment = new LookupEnvironment(this, this.compilerOptions, problemReporter, nameEnvironment);
        this.parser = new SelectionParser(problemReporter);
    }

    public void acceptType(char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, int modifiers, AccessRestriction accessRestriction) {
        char[] typeName;
        char[] cArray = typeName = enclosingTypeNames == null ? simpleTypeName : CharOperation.concat(CharOperation.concatWith(enclosingTypeNames, '.'), simpleTypeName, '.');
        if (CharOperation.equals(simpleTypeName, this.selectedIdentifier)) {
            char[] flatEnclosingTypeNames;
            char[] cArray2 = flatEnclosingTypeNames = enclosingTypeNames == null || enclosingTypeNames.length == 0 ? null : CharOperation.concatWith(enclosingTypeNames, '.');
            if (this.mustQualifyType(packageName, simpleTypeName, flatEnclosingTypeNames, modifiers)) {
                int length = 0;
                int kind = modifiers & 0x6200;
                switch (kind) {
                    case 8192: 
                    case 8704: {
                        char[][] acceptedAnnotation = new char[][]{packageName, typeName};
                        if (this.acceptedAnnotations == null) {
                            this.acceptedAnnotations = new char[10][][];
                            this.acceptedAnnotationsModifiers = new int[10];
                            this.acceptedAnnotationsCount = 0;
                        }
                        if ((length = this.acceptedAnnotations.length) == this.acceptedAnnotationsCount) {
                            int newLength = (length + 1) * 2;
                            char[][][] cArrayArray = new char[newLength][][];
                            this.acceptedAnnotations = cArrayArray;
                            System.arraycopy(this.acceptedAnnotations, 0, cArrayArray, 0, length);
                            this.acceptedAnnotationsModifiers = new int[newLength];
                            System.arraycopy(this.acceptedAnnotationsModifiers, 0, this.acceptedAnnotationsModifiers, 0, length);
                        }
                        this.acceptedAnnotationsModifiers[this.acceptedAnnotationsCount] = modifiers;
                        this.acceptedAnnotations[this.acceptedAnnotationsCount++] = acceptedAnnotation;
                        break;
                    }
                    case 16384: {
                        char[][] acceptedEnum = new char[][]{packageName, typeName};
                        if (this.acceptedEnums == null) {
                            this.acceptedEnums = new char[10][][];
                            this.acceptedEnumsModifiers = new int[10];
                            this.acceptedEnumsCount = 0;
                        }
                        if ((length = this.acceptedEnums.length) == this.acceptedEnumsCount) {
                            int newLength = (length + 1) * 2;
                            char[][][] cArrayArray = new char[newLength][][];
                            this.acceptedEnums = cArrayArray;
                            System.arraycopy(this.acceptedEnums, 0, cArrayArray, 0, length);
                            this.acceptedEnumsModifiers = new int[newLength];
                            System.arraycopy(this.acceptedEnumsModifiers, 0, this.acceptedEnumsModifiers, 0, length);
                        }
                        this.acceptedEnumsModifiers[this.acceptedEnumsCount] = modifiers;
                        this.acceptedEnums[this.acceptedEnumsCount++] = acceptedEnum;
                        break;
                    }
                    case 512: {
                        char[][] acceptedInterface = new char[][]{packageName, typeName};
                        if (this.acceptedInterfaces == null) {
                            this.acceptedInterfaces = new char[10][][];
                            this.acceptedInterfacesModifiers = new int[10];
                            this.acceptedInterfacesCount = 0;
                        }
                        if ((length = this.acceptedInterfaces.length) == this.acceptedInterfacesCount) {
                            int newLength = (length + 1) * 2;
                            char[][][] cArrayArray = new char[newLength][][];
                            this.acceptedInterfaces = cArrayArray;
                            System.arraycopy(this.acceptedInterfaces, 0, cArrayArray, 0, length);
                            this.acceptedInterfacesModifiers = new int[newLength];
                            System.arraycopy(this.acceptedInterfacesModifiers, 0, this.acceptedInterfacesModifiers, 0, length);
                        }
                        this.acceptedInterfacesModifiers[this.acceptedInterfacesCount] = modifiers;
                        this.acceptedInterfaces[this.acceptedInterfacesCount++] = acceptedInterface;
                        break;
                    }
                    default: {
                        char[][] acceptedClass = new char[][]{packageName, typeName};
                        if (this.acceptedClasses == null) {
                            this.acceptedClasses = new char[10][][];
                            this.acceptedClassesModifiers = new int[10];
                            this.acceptedClassesCount = 0;
                        }
                        if ((length = this.acceptedClasses.length) == this.acceptedClassesCount) {
                            int newLength = (length + 1) * 2;
                            char[][][] cArrayArray = new char[newLength][][];
                            this.acceptedClasses = cArrayArray;
                            System.arraycopy(this.acceptedClasses, 0, cArrayArray, 0, length);
                            this.acceptedClassesModifiers = new int[newLength];
                            System.arraycopy(this.acceptedClassesModifiers, 0, this.acceptedClassesModifiers, 0, length);
                        }
                        this.acceptedClassesModifiers[this.acceptedClassesCount] = modifiers;
                        this.acceptedClasses[this.acceptedClassesCount++] = acceptedClass;
                        break;
                    }
                }
            } else {
                this.noProposal = false;
                this.requestor.acceptType(packageName, typeName, modifiers, false, null, this.actualSelectionStart, this.actualSelectionEnd);
                this.acceptedAnswer = true;
            }
        }
    }

    public void acceptPackage(char[] packageName) {
    }

    private void acceptQualifiedTypes() {
        int i;
        if (this.acceptedClasses != null) {
            this.acceptedAnswer = true;
            i = 0;
            while (i < this.acceptedClassesCount) {
                this.noProposal = false;
                this.requestor.acceptType(this.acceptedClasses[i][0], this.acceptedClasses[i][1], this.acceptedClassesModifiers[i], false, null, this.actualSelectionStart, this.actualSelectionEnd);
                ++i;
            }
            this.acceptedClasses = null;
            this.acceptedClassesModifiers = null;
            this.acceptedClassesCount = 0;
        }
        if (this.acceptedInterfaces != null) {
            this.acceptedAnswer = true;
            i = 0;
            while (i < this.acceptedInterfacesCount) {
                this.noProposal = false;
                this.requestor.acceptType(this.acceptedInterfaces[i][0], this.acceptedInterfaces[i][1], this.acceptedInterfacesModifiers[i], false, null, this.actualSelectionStart, this.actualSelectionEnd);
                ++i;
            }
            this.acceptedInterfaces = null;
            this.acceptedInterfacesModifiers = null;
            this.acceptedInterfacesCount = 0;
        }
        if (this.acceptedAnnotations != null) {
            this.acceptedAnswer = true;
            i = 0;
            while (i < this.acceptedAnnotationsCount) {
                this.noProposal = false;
                this.requestor.acceptType(this.acceptedAnnotations[i][0], this.acceptedAnnotations[i][1], this.acceptedAnnotationsModifiers[i], false, null, this.actualSelectionStart, this.actualSelectionEnd);
                ++i;
            }
            this.acceptedAnnotations = null;
            this.acceptedAnnotationsModifiers = null;
            this.acceptedAnnotationsCount = 0;
        }
        if (this.acceptedEnums != null) {
            this.acceptedAnswer = true;
            i = 0;
            while (i < this.acceptedEnumsCount) {
                this.noProposal = false;
                this.requestor.acceptType(this.acceptedEnums[i][0], this.acceptedEnums[i][1], this.acceptedEnumsModifiers[i], false, null, this.actualSelectionStart, this.actualSelectionEnd);
                ++i;
            }
            this.acceptedEnums = null;
            this.acceptedEnumsModifiers = null;
            this.acceptedEnumsCount = 0;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean checkSelection(char[] source, int selectionStart, int selectionEnd) {
        Scanner scanner = new Scanner();
        scanner.setSource(source);
        int lastIdentifierStart = -1;
        int lastIdentifierEnd = -1;
        char[] lastIdentifier = null;
        if (selectionStart > selectionEnd) {
            int token;
            int nextCharacterPosition;
            int end;
            block37: {
                end = source.length - 1;
                int currentPosition = selectionStart - 1;
                nextCharacterPosition = selectionStart;
                int currentCharacter = 32;
                try {
                    while (currentPosition > 0) {
                        if (source[currentPosition] == '\\' && source[currentPosition + 1] == 'u') {
                            int pos = currentPosition + 2;
                            int c1 = 0;
                            int c2 = 0;
                            int c3 = 0;
                            int c4 = 0;
                            while (source[pos] == 'u') {
                                ++pos;
                            }
                            int endOfUnicode = pos + 3;
                            if (end < endOfUnicode) {
                                if (endOfUnicode < source.length) {
                                    end = endOfUnicode;
                                } else {
                                    return false;
                                }
                            }
                            if ((c1 = ScannerHelper.getNumericValue(source[pos++])) > 15 || c1 < 0 || (c2 = ScannerHelper.getNumericValue(source[pos++])) > 15 || c2 < 0 || (c3 = ScannerHelper.getNumericValue(source[pos++])) > 15 || c3 < 0 || (c4 = ScannerHelper.getNumericValue(source[pos++])) > 15 || c4 < 0) {
                                return false;
                            }
                            currentCharacter = (char)(((c1 * 16 + c2) * 16 + c3) * 16 + c4);
                            nextCharacterPosition = pos;
                        } else {
                            currentCharacter = source[currentPosition];
                            nextCharacterPosition = currentPosition + 1;
                        }
                        switch (currentCharacter) {
                            case 10: 
                            case 13: 
                            case 34: 
                            case 39: 
                            case 47: {
                                break block37;
                            }
                            default: {
                                --currentPosition;
                            }
                        }
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    return false;
                }
            }
            scanner.resetTo(nextCharacterPosition, end);
            block21: do {
                try {
                    token = scanner.getNextToken();
                }
                catch (InvalidInputException invalidInputException) {
                    return false;
                }
                switch (token) {
                    case 26: 
                    case 41: 
                    case 42: {
                        if (scanner.startPosition > selectionStart || selectionStart > scanner.currentPosition) continue block21;
                        if (scanner.currentPosition == scanner.eofPosition) {
                            int temp = scanner.eofPosition;
                            scanner.eofPosition = scanner.source.length;
                            while (scanner.getNextCharAsJavaIdentifierPart()) {
                            }
                            scanner.eofPosition = temp;
                        }
                        lastIdentifierStart = scanner.startPosition;
                        lastIdentifierEnd = scanner.currentPosition - 1;
                        lastIdentifier = scanner.getCurrentTokenSource();
                    }
                }
            } while (token != 68);
        } else {
            scanner.resetTo(selectionStart, selectionEnd);
            boolean expectingIdentifier = true;
            try {
                int token;
                block23: do {
                    token = scanner.getNextToken();
                    switch (token) {
                        case 26: 
                        case 41: 
                        case 42: {
                            if (!expectingIdentifier) {
                                return false;
                            }
                            lastIdentifier = scanner.getCurrentTokenSource();
                            lastIdentifierStart = scanner.startPosition;
                            lastIdentifierEnd = scanner.currentPosition - 1;
                            if (lastIdentifierEnd > selectionEnd) {
                                lastIdentifierEnd = selectionEnd;
                                lastIdentifier = CharOperation.subarray(lastIdentifier, 0, lastIdentifierEnd - lastIdentifierStart + 1);
                            }
                            expectingIdentifier = false;
                            break;
                        }
                        case 3: {
                            if (expectingIdentifier) {
                                return false;
                            }
                            expectingIdentifier = true;
                            break;
                        }
                        case 68: {
                            if (!expectingIdentifier) continue block23;
                            return false;
                        }
                        case 7: {
                            if (this.checkTypeArgument(scanner)) continue block23;
                            return false;
                        }
                        case 53: {
                            if (scanner.startPosition == scanner.initialPosition) continue block23;
                            return false;
                        }
                        default: {
                            return false;
                        }
                    }
                } while (token != 68);
            }
            catch (InvalidInputException invalidInputException) {
                return false;
            }
        }
        if (lastIdentifierStart > 0) {
            this.actualSelectionStart = lastIdentifierStart;
            this.actualSelectionEnd = lastIdentifierEnd;
            this.selectedIdentifier = lastIdentifier;
            return true;
        }
        return false;
    }

    private boolean checkTypeArgument(Scanner scanner) throws InvalidInputException {
        char[] typeRef;
        int length;
        int token;
        int depth = 1;
        StringBuffer buffer = new StringBuffer();
        do {
            token = scanner.getNextToken();
            switch (token) {
                case 7: {
                    ++depth;
                    buffer.append(scanner.getCurrentTokenSource());
                    break;
                }
                case 12: {
                    --depth;
                    buffer.append(scanner.getCurrentTokenSource());
                    break;
                }
                case 8: {
                    depth -= 2;
                    buffer.append(scanner.getCurrentTokenSource());
                    break;
                }
                case 11: {
                    depth -= 3;
                    buffer.append(scanner.getCurrentTokenSource());
                    break;
                }
                case 41: 
                case 99: {
                    buffer.append(' ');
                    buffer.append(scanner.getCurrentTokenSource());
                    buffer.append(' ');
                    break;
                }
                case 30: {
                    if (depth != 1) break;
                    length = buffer.length();
                    typeRef = new char[length];
                    buffer.getChars(0, length, typeRef, 0);
                    try {
                        Signature.createTypeSignature(typeRef, true);
                        buffer = new StringBuffer();
                        break;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        return false;
                    }
                }
                default: {
                    buffer.append(scanner.getCurrentTokenSource());
                }
            }
            if (depth >= 0) continue;
            return false;
        } while (depth != 0 && token != 68);
        if (depth == 0) {
            length = buffer.length() - 1;
            typeRef = new char[length];
            buffer.getChars(0, length, typeRef, 0);
            try {
                Signature.createTypeSignature(typeRef, true);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }
        return false;
    }

    public AssistParser getParser() {
        return this.parser;
    }

    private boolean isLocal(ReferenceBinding binding) {
        if (binding instanceof ParameterizedTypeBinding) {
            return this.isLocal(((ParameterizedTypeBinding)binding).genericType());
        }
        if (!(binding instanceof SourceTypeBinding)) {
            return false;
        }
        if (binding instanceof LocalTypeBinding) {
            return true;
        }
        if (binding instanceof MemberTypeBinding) {
            return this.isLocal(((MemberTypeBinding)binding).enclosingType);
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public void select(ICompilationUnit sourceUnit, int selectionSourceStart, int selectionSourceEnd) {
        source = sourceUnit.getContents();
        if (SelectionEngine.DEBUG) {
            System.out.print("SELECTION IN ");
            System.out.print(sourceUnit.getFileName());
            System.out.print(" FROM ");
            System.out.print(selectionSourceStart);
            System.out.print(" TO ");
            System.out.println(selectionSourceEnd);
            System.out.println("SELECTION - Source :");
            System.out.println(source);
        }
        if (!this.checkSelection(source, selectionSourceStart, selectionSourceEnd)) {
            return;
        }
        if (SelectionEngine.DEBUG) {
            System.out.print("SELECTION - Checked : \"");
            System.out.print(new String(source, this.actualSelectionStart, this.actualSelectionEnd - this.actualSelectionStart + 1));
            System.out.println('\"');
        }
        try {
            this.acceptedAnswer = false;
            result = new CompilationResult(sourceUnit, 1, 1, this.compilerOptions.maxProblemsPerUnit);
            parsedUnit = this.parser.dietParse(sourceUnit, result, this.actualSelectionStart, this.actualSelectionEnd);
            if (parsedUnit == null) ** GOTO lbl93
            if (SelectionEngine.DEBUG) {
                System.out.println("SELECTION - Diet AST :");
                System.out.println(parsedUnit.toString());
            }
            if (parsedUnit.currentPackage instanceof SelectionOnPackageReference) {
                tokens = ((SelectionOnPackageReference)parsedUnit.currentPackage).tokens;
                this.noProposal = false;
                this.requestor.acceptPackage(CharOperation.concatWith(tokens, '.'));
lbl29:
                // 3 sources

                return;
            }
            try {
                block35: {
                    block37: {
                        imports = parsedUnit.imports;
                        if (imports == null) break block37;
                        i = 0;
                        length = imports.length;
                        while (i < length) {
                            block38: {
                                importReference = imports[i];
                                if (!(importReference instanceof SelectionOnImportReference)) break block38;
                                tokens = ((SelectionOnImportReference)importReference).tokens;
                                this.noProposal = false;
                                this.requestor.acceptPackage(CharOperation.concatWith(tokens, '.'));
                                this.nameEnvironment.findTypes(CharOperation.concatWith(tokens, '.'), false, false, 0, this);
                                this.lookupEnvironment.buildTypeBindings(parsedUnit, null);
                                this.unitScope = parsedUnit.scope;
                                if (this.unitScope != null) {
                                    tokenCount = tokens.length;
                                    lastToken = tokens[tokenCount - 1];
                                    qualifierTokens = CharOperation.subarray(tokens, 0, tokenCount - 1);
                                    if (qualifierTokens != null && qualifierTokens.length > 0 && (binding = this.unitScope.getTypeOrPackage(qualifierTokens)) != null && binding instanceof ReferenceBinding) {
                                        ref = (ReferenceBinding)binding;
                                        this.selectMemberTypeFromImport(parsedUnit, lastToken, ref, importReference.isStatic());
                                        if (importReference.isStatic()) {
                                            this.selectStaticFieldFromStaticImport(parsedUnit, lastToken, ref);
                                            this.selectStaticMethodFromStaticImport(parsedUnit, lastToken, ref);
                                        }
                                    }
                                }
                                if (!this.acceptedAnswer) {
                                    this.acceptQualifiedTypes();
                                    if (!this.acceptedAnswer) {
                                        this.nameEnvironment.findTypes(this.selectedIdentifier, false, false, 0, this);
                                        if (!this.acceptedAnswer) {
                                            this.acceptQualifiedTypes();
                                        }
                                    }
                                }
                                if (this.noProposal && this.problem != null) {
                                    this.requestor.acceptError(this.problem);
                                }
                                ** GOTO lbl29
                            }
                            ++i;
                        }
                    }
                    if (parsedUnit.types != null || parsedUnit.isPackageInfo()) {
                        if (!this.selectDeclaration(parsedUnit)) ** break;
                        ** continue;
                        this.lookupEnvironment.buildTypeBindings(parsedUnit, null);
                        this.unitScope = parsedUnit.scope;
                        if (this.unitScope != null) {
                            try {
                                this.lookupEnvironment.completeTypeBindings(parsedUnit, true);
                                parsedUnit.scope.faultInTypes();
                                node = null;
                                if (parsedUnit.types != null) {
                                    node = this.parseBlockStatements(parsedUnit, selectionSourceStart);
                                }
                                if (SelectionEngine.DEBUG) {
                                    System.out.println("SELECTION - AST :");
                                    System.out.println(parsedUnit.toString());
                                }
                                parsedUnit.resolve();
                                if (node != null) {
                                    this.selectLocalDeclaration(node);
                                }
                            }
                            catch (SelectionNodeFound e) {
                                if (e.binding == null) break block35;
                                if (SelectionEngine.DEBUG) {
                                    System.out.println("SELECTION - Selection binding:");
                                    System.out.println(e.binding.toString());
                                }
                                this.selectFrom(e.binding, parsedUnit, e.isDeclaration);
                            }
                        }
                    }
                }
                if (!this.acceptedAnswer) {
                    this.nameEnvironment.findTypes(this.selectedIdentifier, false, false, 0, this);
                    if (!this.acceptedAnswer) {
                        this.acceptQualifiedTypes();
                    }
                }
                if (this.noProposal && this.problem != null) {
                    this.requestor.acceptError(this.problem);
                }
            }
            catch (IndexOutOfBoundsException e) {
                if (SelectionEngine.DEBUG) {
                    System.out.println("Exception caught by SelectionEngine:");
                    e.printStackTrace(System.out);
                }
            }
            catch (AbortCompilation e) {
                if (SelectionEngine.DEBUG) {
                    System.out.println("Exception caught by SelectionEngine:");
                    e.printStackTrace(System.out);
                }
            }
        }
        finally {
            this.reset();
        }
    }

    private void selectMemberTypeFromImport(CompilationUnitDeclaration parsedUnit, char[] lastToken, ReferenceBinding ref, boolean staticOnly) {
        int fieldLength = lastToken.length;
        ReferenceBinding[] memberTypes = ref.memberTypes();
        int j = 0;
        while (j < memberTypes.length) {
            ReferenceBinding memberType = memberTypes[j];
            if (fieldLength <= memberType.sourceName.length && (!staticOnly || memberType.isStatic()) && CharOperation.equals(lastToken, memberType.sourceName, true)) {
                this.selectFrom(memberType, parsedUnit, false);
            }
            ++j;
        }
    }

    private void selectStaticFieldFromStaticImport(CompilationUnitDeclaration parsedUnit, char[] lastToken, ReferenceBinding ref) {
        int fieldLength = lastToken.length;
        FieldBinding[] fields = ref.fields();
        int j = 0;
        while (j < fields.length) {
            FieldBinding field = fields[j];
            if (fieldLength <= field.name.length && !field.isSynthetic() && field.isStatic() && CharOperation.equals(lastToken, field.name, true)) {
                this.selectFrom(field, parsedUnit, false);
            }
            ++j;
        }
    }

    private void selectStaticMethodFromStaticImport(CompilationUnitDeclaration parsedUnit, char[] lastToken, ReferenceBinding ref) {
        int methodLength = lastToken.length;
        MethodBinding[] methods = ref.methods();
        int j = 0;
        while (j < methods.length) {
            MethodBinding method = methods[j];
            if (!method.isSynthetic() && !method.isDefaultAbstract() && !method.isConstructor() && method.isStatic() && methodLength <= method.selector.length && CharOperation.equals(lastToken, method.selector, true)) {
                this.selectFrom(method, parsedUnit, false);
            }
            ++j;
        }
    }

    private void selectFrom(Binding binding, CompilationUnitDeclaration parsedUnit, boolean isDeclaration) {
        if (binding instanceof TypeVariableBinding) {
            TypeVariableBinding typeVariableBinding = (TypeVariableBinding)binding;
            Binding enclosingElement = typeVariableBinding.declaringElement;
            this.noProposal = false;
            if (enclosingElement instanceof SourceTypeBinding) {
                SourceTypeBinding enclosingType = (SourceTypeBinding)enclosingElement;
                if (this.isLocal(enclosingType) && this.requestor instanceof SelectionRequestor) {
                    ((SelectionRequestor)this.requestor).acceptLocalTypeParameter(typeVariableBinding);
                } else {
                    this.requestor.acceptTypeParameter(enclosingType.qualifiedPackageName(), enclosingType.qualifiedSourceName(), typeVariableBinding.sourceName(), false, this.actualSelectionStart, this.actualSelectionEnd);
                }
            } else if (enclosingElement instanceof MethodBinding) {
                MethodBinding enclosingMethod = (MethodBinding)enclosingElement;
                if (this.isLocal(enclosingMethod.declaringClass) && this.requestor instanceof SelectionRequestor) {
                    ((SelectionRequestor)this.requestor).acceptLocalMethodTypeParameter(typeVariableBinding);
                } else {
                    this.requestor.acceptMethodTypeParameter(enclosingMethod.declaringClass.qualifiedPackageName(), enclosingMethod.declaringClass.qualifiedSourceName(), enclosingMethod.isConstructor() ? enclosingMethod.declaringClass.sourceName() : enclosingMethod.selector, enclosingMethod.sourceStart(), enclosingMethod.sourceEnd(), typeVariableBinding.sourceName(), false, this.actualSelectionStart, this.actualSelectionEnd);
                }
            }
            this.acceptedAnswer = true;
        } else if (binding instanceof ReferenceBinding) {
            ReferenceBinding typeBinding = (ReferenceBinding)binding;
            if (typeBinding instanceof ProblemReferenceBinding) {
                typeBinding = typeBinding.closestMatch();
            }
            if (typeBinding == null) {
                return;
            }
            if (this.isLocal(typeBinding) && this.requestor instanceof SelectionRequestor) {
                this.noProposal = false;
                ((SelectionRequestor)this.requestor).acceptLocalType(typeBinding);
            } else {
                this.noProposal = false;
                this.requestor.acceptType(typeBinding.qualifiedPackageName(), typeBinding.qualifiedSourceName(), typeBinding.modifiers, false, typeBinding.computeUniqueKey(), this.actualSelectionStart, this.actualSelectionEnd);
            }
            this.acceptedAnswer = true;
        } else if (binding instanceof MethodBinding) {
            MethodBinding methodBinding = (MethodBinding)binding;
            this.noProposal = false;
            boolean isValuesOrValueOf = false;
            if (binding instanceof SyntheticMethodBinding) {
                SyntheticMethodBinding syntheticMethodBinding = (SyntheticMethodBinding)binding;
                if (syntheticMethodBinding.kind == 7 || syntheticMethodBinding.kind == 8) {
                    isValuesOrValueOf = true;
                }
            }
            if (!isValuesOrValueOf && !methodBinding.isSynthetic()) {
                TypeBinding[] parameterTypes = methodBinding.original().parameters;
                int length = parameterTypes.length;
                char[][] parameterPackageNames = new char[length][];
                char[][] parameterTypeNames = new char[length][];
                String[] parameterSignatures = new String[length];
                int i = 0;
                while (i < length) {
                    parameterPackageNames[i] = parameterTypes[i].qualifiedPackageName();
                    parameterTypeNames[i] = parameterTypes[i].qualifiedSourceName();
                    parameterSignatures[i] = new String(SelectionEngine.getSignature(parameterTypes[i])).replace('/', '.');
                    ++i;
                }
                TypeVariableBinding[] typeVariables = methodBinding.original().typeVariables;
                length = typeVariables == null ? 0 : typeVariables.length;
                char[][] typeParameterNames = new char[length][];
                char[][][] typeParameterBoundNames = new char[length][][];
                int i2 = 0;
                while (i2 < length) {
                    int j;
                    int boundCount;
                    TypeVariableBinding typeVariable = typeVariables[i2];
                    typeParameterNames[i2] = typeVariable.sourceName;
                    if (typeVariable.firstBound == null) {
                        typeParameterBoundNames[i2] = new char[0][];
                    } else if (typeVariable.firstBound == typeVariable.superclass) {
                        boundCount = 1 + (typeVariable.superInterfaces == null ? 0 : typeVariable.superInterfaces.length);
                        typeParameterBoundNames[i2] = new char[boundCount][];
                        typeParameterBoundNames[i2][0] = typeVariable.superclass.sourceName;
                        j = 1;
                        while (j < boundCount) {
                            typeParameterBoundNames[i2][j] = typeVariables[i2].superInterfaces[j - 1].sourceName;
                            ++j;
                        }
                    } else {
                        boundCount = typeVariable.superInterfaces == null ? 0 : typeVariable.superInterfaces.length;
                        typeParameterBoundNames[i2] = new char[boundCount][];
                        j = 0;
                        while (j < boundCount) {
                            typeParameterBoundNames[i2][j] = typeVariables[i2].superInterfaces[j].sourceName;
                            ++j;
                        }
                    }
                    ++i2;
                }
                ReferenceBinding declaringClass = methodBinding.declaringClass;
                if (this.isLocal(declaringClass) && this.requestor instanceof SelectionRequestor) {
                    ((SelectionRequestor)this.requestor).acceptLocalMethod(methodBinding);
                } else {
                    this.requestor.acceptMethod(declaringClass.qualifiedPackageName(), declaringClass.qualifiedSourceName(), declaringClass.enclosingType() == null ? null : new String(SelectionEngine.getSignature(declaringClass.enclosingType())), methodBinding.isConstructor() ? declaringClass.sourceName() : methodBinding.selector, parameterPackageNames, parameterTypeNames, parameterSignatures, typeParameterNames, typeParameterBoundNames, methodBinding.isConstructor(), isDeclaration, methodBinding.computeUniqueKey(), this.actualSelectionStart, this.actualSelectionEnd);
                }
            }
            this.acceptedAnswer = true;
        } else if (binding instanceof FieldBinding) {
            FieldBinding fieldBinding = (FieldBinding)binding;
            ReferenceBinding declaringClass = fieldBinding.declaringClass;
            if (declaringClass != null) {
                this.noProposal = false;
                if (this.isLocal(declaringClass) && this.requestor instanceof SelectionRequestor) {
                    ((SelectionRequestor)this.requestor).acceptLocalField(fieldBinding);
                } else {
                    this.requestor.acceptField(declaringClass.qualifiedPackageName(), declaringClass.qualifiedSourceName(), fieldBinding.name, false, fieldBinding.computeUniqueKey(), this.actualSelectionStart, this.actualSelectionEnd);
                }
                this.acceptedAnswer = true;
            }
        } else if (binding instanceof LocalVariableBinding) {
            if (this.requestor instanceof SelectionRequestor) {
                ((SelectionRequestor)this.requestor).acceptLocalVariable((LocalVariableBinding)binding);
                this.acceptedAnswer = true;
            } else {
                this.selectFrom(((LocalVariableBinding)binding).type, parsedUnit, false);
            }
        } else if (binding instanceof ArrayBinding) {
            this.selectFrom(((ArrayBinding)binding).leafComponentType, parsedUnit, false);
        } else if (binding instanceof PackageBinding) {
            PackageBinding packageBinding = (PackageBinding)binding;
            this.noProposal = false;
            this.requestor.acceptPackage(packageBinding.readableName());
            this.acceptedAnswer = true;
        } else if (binding instanceof BaseTypeBinding) {
            this.acceptedAnswer = true;
        }
    }

    private void selectLocalDeclaration(ASTNode node) {
        class Visitor
        extends ASTVisitor {
            final /* synthetic */ SelectionEngine this$0;
            private final /* synthetic */ char[] val$assistIdentifier;

            Visitor(SelectionEngine selectionEngine, char[] cArray) {
                this.this$0 = selectionEngine;
                this.val$assistIdentifier = cArray;
            }

            public boolean visit(ConstructorDeclaration constructorDeclaration, ClassScope scope) {
                if (constructorDeclaration.selector == this.val$assistIdentifier) {
                    if (constructorDeclaration.binding != null) {
                        throw new SelectionNodeFound(constructorDeclaration.binding);
                    }
                    if (constructorDeclaration.scope != null) {
                        throw new SelectionNodeFound(new MethodBinding(constructorDeclaration.modifiers, constructorDeclaration.selector, null, null, null, constructorDeclaration.scope.referenceType().binding));
                    }
                }
                return true;
            }

            public boolean visit(FieldDeclaration fieldDeclaration, MethodScope scope) {
                if (fieldDeclaration.name == this.val$assistIdentifier) {
                    throw new SelectionNodeFound(fieldDeclaration.binding);
                }
                return true;
            }

            public boolean visit(TypeDeclaration localTypeDeclaration, BlockScope scope) {
                if (localTypeDeclaration.name == this.val$assistIdentifier) {
                    throw new SelectionNodeFound(localTypeDeclaration.binding);
                }
                return true;
            }

            public boolean visit(TypeDeclaration memberTypeDeclaration, ClassScope scope) {
                if (memberTypeDeclaration.name == this.val$assistIdentifier) {
                    throw new SelectionNodeFound(memberTypeDeclaration.binding);
                }
                return true;
            }

            public boolean visit(MethodDeclaration methodDeclaration, ClassScope scope) {
                if (methodDeclaration.selector == this.val$assistIdentifier) {
                    if (methodDeclaration.binding != null) {
                        throw new SelectionNodeFound(methodDeclaration.binding);
                    }
                    if (methodDeclaration.scope != null) {
                        throw new SelectionNodeFound(new MethodBinding(methodDeclaration.modifiers, methodDeclaration.selector, null, null, null, methodDeclaration.scope.referenceType().binding));
                    }
                }
                return true;
            }

            public boolean visit(TypeDeclaration typeDeclaration, CompilationUnitScope scope) {
                if (typeDeclaration.name == this.val$assistIdentifier) {
                    throw new SelectionNodeFound(typeDeclaration.binding);
                }
                return true;
            }

            public boolean visit(TypeParameter typeParameter, BlockScope scope) {
                if (typeParameter.name == this.val$assistIdentifier) {
                    throw new SelectionNodeFound(typeParameter.binding);
                }
                return true;
            }

            public boolean visit(TypeParameter typeParameter, ClassScope scope) {
                if (typeParameter.name == this.val$assistIdentifier) {
                    throw new SelectionNodeFound(typeParameter.binding);
                }
                return true;
            }
        }
        char[] assistIdentifier = this.getParser().assistIdentifier();
        if (assistIdentifier == null) {
            return;
        }
        if (node instanceof AbstractMethodDeclaration) {
            ((AbstractMethodDeclaration)node).traverse((ASTVisitor)new Visitor(this, assistIdentifier), (ClassScope)null);
        } else {
            ((FieldDeclaration)node).traverse((ASTVisitor)new Visitor(this, assistIdentifier), null);
        }
    }

    public void selectType(ISourceType sourceType, char[] typeName, SourceTypeElementInfo[] topLevelTypes, boolean searchInEnvironment) {
        try {
            this.acceptedAnswer = false;
            if (CharOperation.indexOf('<', typeName) != -1) {
                char[] typeSig = Signature.createCharArrayTypeSignature(typeName, false);
                typeSig = Signature.getTypeErasure(typeSig);
                typeName = Signature.toCharArray(typeSig);
            }
            ISourceType outerType = sourceType;
            ISourceType parent = sourceType.getEnclosingType();
            while (parent != null) {
                outerType = parent;
                parent = parent.getEnclosingType();
            }
            CompilationResult result = new CompilationResult(outerType.getFileName(), 1, 1, this.compilerOptions.maxProblemsPerUnit);
            if (!(sourceType instanceof SourceTypeElementInfo)) {
                return;
            }
            try {
                block22: {
                    CompilationUnitDeclaration parsedUnit;
                    SourceType typeHandle = (SourceType)((SourceTypeElementInfo)sourceType).getHandle();
                    int flags = 15;
                    if (typeHandle.isAnonymous() || typeHandle.isLocal()) {
                        flags |= 0x20;
                    }
                    if ((parsedUnit = SourceTypeConverter.buildCompilationUnit(topLevelTypes, flags, this.parser.problemReporter(), result)) != null && parsedUnit.types != null) {
                        TypeDeclaration typeDecl;
                        if (DEBUG) {
                            System.out.println("SELECTION - Diet AST :");
                            System.out.println(parsedUnit.toString());
                        }
                        if ((typeDecl = new ASTNodeFinder(parsedUnit).findType(typeHandle)) != null) {
                            FieldDeclaration field = new FieldDeclaration();
                            int dot = CharOperation.lastIndexOf('.', typeName);
                            if (dot == -1) {
                                this.selectedIdentifier = typeName;
                                field.type = new SelectionOnSingleTypeReference(typeName, -1L);
                            } else {
                                char[][] previousIdentifiers = CharOperation.splitOn('.', typeName, 0, dot);
                                char[] selectionIdentifier = CharOperation.subarray(typeName, dot + 1, typeName.length);
                                this.selectedIdentifier = selectionIdentifier;
                                field.type = new SelectionOnQualifiedTypeReference(previousIdentifiers, selectionIdentifier, new long[previousIdentifiers.length + 1]);
                            }
                            field.name = "<fakeField>".toCharArray();
                            typeDecl.fields = new FieldDeclaration[]{field};
                            this.lookupEnvironment.buildTypeBindings(parsedUnit, null);
                            this.unitScope = parsedUnit.scope;
                            if (this.unitScope != null) {
                                try {
                                    this.lookupEnvironment.completeTypeBindings(parsedUnit, true);
                                    parsedUnit.scope.faultInTypes();
                                    parsedUnit.resolve();
                                }
                                catch (SelectionNodeFound e) {
                                    if (e.binding == null) break block22;
                                    if (DEBUG) {
                                        System.out.println("SELECTION - Selection binding :");
                                        System.out.println(e.binding.toString());
                                    }
                                    this.selectFrom(e.binding, parsedUnit, e.isDeclaration);
                                }
                            }
                        }
                    }
                }
                if (!this.acceptedAnswer && searchInEnvironment && this.selectedIdentifier != null) {
                    this.nameEnvironment.findTypes(typeName, false, false, 0, this);
                    if (!this.acceptedAnswer) {
                        this.acceptQualifiedTypes();
                    }
                }
                if (this.noProposal && this.problem != null) {
                    this.requestor.acceptError(this.problem);
                }
            }
            catch (AbortCompilation abortCompilation) {}
        }
        finally {
            this.reset();
        }
    }

    private boolean selectDeclaration(CompilationUnitDeclaration compilationUnit) {
        char[] assistIdentifier = this.getParser().assistIdentifier();
        if (assistIdentifier == null) {
            return false;
        }
        ImportReference currentPackage = compilationUnit.currentPackage;
        char[] packageName = currentPackage == null ? CharOperation.NO_CHAR : CharOperation.concatWith(currentPackage.tokens, '.');
        TypeDeclaration[] types = compilationUnit.types;
        int i = 0;
        int length = types == null ? 0 : types.length;
        while (i < length) {
            if (this.selectDeclaration(types[i], assistIdentifier, packageName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean selectDeclaration(TypeDeclaration typeDeclaration, char[] assistIdentifier, char[] packageName) {
        if (typeDeclaration.name == assistIdentifier) {
            char[] qualifiedSourceName = null;
            TypeDeclaration enclosingType = typeDeclaration;
            while (enclosingType != null) {
                qualifiedSourceName = CharOperation.concat(enclosingType.name, qualifiedSourceName, '.');
                enclosingType = enclosingType.enclosingType;
            }
            char[] uniqueKey = typeDeclaration.binding != null ? typeDeclaration.binding.computeUniqueKey() : null;
            this.requestor.acceptType(packageName, qualifiedSourceName, typeDeclaration.modifiers, true, uniqueKey, this.actualSelectionStart, this.actualSelectionEnd);
            this.noProposal = false;
            return true;
        }
        TypeDeclaration[] memberTypes = typeDeclaration.memberTypes;
        int i = 0;
        int length = memberTypes == null ? 0 : memberTypes.length;
        while (i < length) {
            if (this.selectDeclaration(memberTypes[i], assistIdentifier, packageName)) {
                return true;
            }
            ++i;
        }
        FieldDeclaration[] fields = typeDeclaration.fields;
        int i2 = 0;
        int length2 = fields == null ? 0 : fields.length;
        while (i2 < length2) {
            if (fields[i2].name == assistIdentifier) {
                char[] qualifiedSourceName = null;
                TypeDeclaration enclosingType = typeDeclaration;
                while (enclosingType != null) {
                    qualifiedSourceName = CharOperation.concat(enclosingType.name, qualifiedSourceName, '.');
                    enclosingType = enclosingType.enclosingType;
                }
                FieldDeclaration field = fields[i2];
                this.requestor.acceptField(packageName, qualifiedSourceName, field.name, true, field.binding != null ? field.binding.computeUniqueKey() : null, this.actualSelectionStart, this.actualSelectionEnd);
                this.noProposal = false;
                return true;
            }
            ++i2;
        }
        AbstractMethodDeclaration[] methods = typeDeclaration.methods;
        int i3 = 0;
        int length3 = methods == null ? 0 : methods.length;
        while (i3 < length3) {
            AbstractMethodDeclaration method = methods[i3];
            if (method.selector == assistIdentifier) {
                char[] qualifiedSourceName = null;
                TypeDeclaration enclosingType = typeDeclaration;
                while (enclosingType != null) {
                    qualifiedSourceName = CharOperation.concat(enclosingType.name, qualifiedSourceName, '.');
                    enclosingType = enclosingType.enclosingType;
                }
                this.requestor.acceptMethod(packageName, qualifiedSourceName, null, method.selector, null, null, null, null, null, method.isConstructor(), true, method.binding != null ? method.binding.computeUniqueKey() : null, this.actualSelectionStart, this.actualSelectionEnd);
                this.noProposal = false;
                return true;
            }
            TypeParameter[] methodTypeParameters = method.typeParameters();
            int j = 0;
            int length22 = methodTypeParameters == null ? 0 : methodTypeParameters.length;
            while (j < length22) {
                TypeParameter methodTypeParameter = methodTypeParameters[j];
                if (methodTypeParameter.name == assistIdentifier) {
                    char[] qualifiedSourceName = null;
                    TypeDeclaration enclosingType = typeDeclaration;
                    while (enclosingType != null) {
                        qualifiedSourceName = CharOperation.concat(enclosingType.name, qualifiedSourceName, '.');
                        enclosingType = enclosingType.enclosingType;
                    }
                    this.requestor.acceptMethodTypeParameter(packageName, qualifiedSourceName, method.selector, method.sourceStart, method.sourceEnd, methodTypeParameter.name, true, this.actualSelectionStart, this.actualSelectionEnd);
                    this.noProposal = false;
                    return true;
                }
                ++j;
            }
            ++i3;
        }
        TypeParameter[] typeParameters = typeDeclaration.typeParameters;
        int i4 = 0;
        int length4 = typeParameters == null ? 0 : typeParameters.length;
        while (i4 < length4) {
            TypeParameter typeParameter = typeParameters[i4];
            if (typeParameter.name == assistIdentifier) {
                char[] qualifiedSourceName = null;
                TypeDeclaration enclosingType = typeDeclaration;
                while (enclosingType != null) {
                    qualifiedSourceName = CharOperation.concat(enclosingType.name, qualifiedSourceName, '.');
                    enclosingType = enclosingType.enclosingType;
                }
                this.requestor.acceptTypeParameter(packageName, qualifiedSourceName, typeParameter.name, true, this.actualSelectionStart, this.actualSelectionEnd);
                this.noProposal = false;
                return true;
            }
            ++i4;
        }
        return false;
    }
}

