/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.dialogs;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.CommandManager;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.jdt.internal.ui.text.JavaWordIterator;
import org.eclipse.jface.bindings.BindingManager;
import org.eclipse.jface.bindings.Scheme;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.keys.IBindingService;

public class TextFieldNavigationHandler {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static void install(Text text) {
        if (TextFieldNavigationHandler.isSubWordNavigationEnabled()) {
            new FocusHandler(new TextNavigable(text));
        }
    }

    public static void install(StyledText styledText) {
        if (TextFieldNavigationHandler.isSubWordNavigationEnabled()) {
            new FocusHandler(new StyledTextNavigable(styledText));
        }
    }

    public static void install(Combo combo) {
        if (TextFieldNavigationHandler.isSubWordNavigationEnabled()) {
            new FocusHandler(new ComboNavigable(combo));
        }
    }

    private static boolean isSubWordNavigationEnabled() {
        IPreferenceStore preferenceStore = JavaPlugin.getDefault().getCombinedPreferenceStore();
        return preferenceStore.getBoolean("subWordNavigation");
    }

    private static class ComboNavigable
    extends WorkaroundNavigable {
        private final Combo fCombo;

        public ComboNavigable(Combo combo) {
            this.fCombo = combo;
            this.fLastSelection = this.getSelection();
            this.fCaretPosition = this.fLastSelection.y;
            this.fCombo.addKeyListener((KeyListener)new KeyAdapter(this){
                final /* synthetic */ ComboNavigable this$1;
                {
                    this.this$1 = comboNavigable;
                }

                public void keyReleased(KeyEvent e) {
                    this.this$1.selectionChanged();
                }
            });
            this.fCombo.addMouseListener((MouseListener)new MouseAdapter(this){
                final /* synthetic */ ComboNavigable this$1;
                {
                    this.this$1 = comboNavigable;
                }

                public void mouseUp(MouseEvent e) {
                    this.this$1.selectionChanged();
                }
            });
        }

        public Control getControl() {
            return this.fCombo;
        }

        public String getText() {
            return this.fCombo.getText();
        }

        public void setText(String text) {
            this.fCombo.setText(text);
        }

        public Point getSelection() {
            return this.fCombo.getSelection();
        }

        public int getCaretPosition() {
            this.selectionChanged();
            return this.fCaretPosition;
        }

        public void setSelection(int start, int end) {
            this.fCombo.setSelection(new Point(start, end));
        }
    }

    private static class FocusHandler
    implements FocusListener {
        private static final String EMPTY_TEXT = "";
        private final JavaWordIterator fIterator = new JavaWordIterator();
        private final Navigable fNavigable;
        private KeyAdapter fKeyListener;

        private FocusHandler(Navigable navigable) {
            this.fNavigable = navigable;
            Control control = navigable.getControl();
            control.addFocusListener((FocusListener)this);
            if (control.isFocusControl()) {
                this.activate();
            }
            control.addDisposeListener(new DisposeListener(this){
                final /* synthetic */ FocusHandler this$1;
                {
                    this.this$1 = focusHandler;
                }

                public void widgetDisposed(DisposeEvent e) {
                    FocusHandler.access$0(this.this$1);
                }
            });
        }

        public void focusGained(FocusEvent e) {
            this.activate();
        }

        public void focusLost(FocusEvent e) {
            this.deactivate();
        }

        private void activate() {
            this.fNavigable.getControl().addKeyListener((KeyListener)this.getKeyListener());
        }

        private void deactivate() {
            if (this.fKeyListener != null) {
                Control control = this.fNavigable.getControl();
                if (!control.isDisposed()) {
                    control.removeKeyListener((KeyListener)this.fKeyListener);
                }
                this.fKeyListener = null;
            }
        }

        private KeyAdapter getKeyListener() {
            if (this.fKeyListener == null) {
                this.fKeyListener = new KeyAdapter(this){
                    private final boolean IS_WORKAROUND;
                    private List fSubmissions;
                    final /* synthetic */ FocusHandler this$1;
                    {
                        this.this$1 = focusHandler;
                        this.IS_WORKAROUND = FocusHandler.access$1(focusHandler) instanceof ComboNavigable || FocusHandler.access$1(focusHandler) instanceof TextNavigable && TextNavigable.BUG_106024_TEXT_SELECTION;
                    }

                    public void keyPressed(KeyEvent e) {
                        if (this.IS_WORKAROUND) {
                            if (e.keyCode == 0x1000003 && e.stateMask == SWT.MOD2) {
                                int caretPosition = FocusHandler.access$1(this.this$1).getCaretPosition();
                                if (caretPosition != 0) {
                                    Point selection = FocusHandler.access$1(this.this$1).getSelection();
                                    if (caretPosition == selection.x) {
                                        FocusHandler.access$1(this.this$1).setSelection(selection.y, caretPosition - 1);
                                    } else {
                                        FocusHandler.access$1(this.this$1).setSelection(selection.x, caretPosition - 1);
                                    }
                                }
                                e.doit = false;
                                return;
                            }
                            if (e.keyCode == 0x1000004 && e.stateMask == SWT.MOD2) {
                                String text = FocusHandler.access$1(this.this$1).getText();
                                int caretPosition = FocusHandler.access$1(this.this$1).getCaretPosition();
                                if (caretPosition != text.length()) {
                                    Point selection = FocusHandler.access$1(this.this$1).getSelection();
                                    if (caretPosition == selection.y) {
                                        FocusHandler.access$1(this.this$1).setSelection(selection.x, caretPosition + 1);
                                    } else {
                                        FocusHandler.access$1(this.this$1).setSelection(selection.y, caretPosition + 1);
                                    }
                                }
                                e.doit = false;
                                return;
                            }
                        }
                        int accelerator = SWTKeySupport.convertEventToUnmodifiedAccelerator((KeyEvent)e);
                        KeySequence keySequence = KeySequence.getInstance((KeyStroke)SWTKeySupport.convertAcceleratorToKeyStroke((int)accelerator));
                        this.getSubmissions();
                        Iterator<E> iter = this.getSubmissions().iterator();
                        while (iter.hasNext()) {
                            Submission submission = (Submission)iter.next();
                            TriggerSequence[] triggerSequences = submission.getTriggerSequences();
                            int i = 0;
                            while (i < triggerSequences.length) {
                                if (triggerSequences[i].equals((Object)keySequence)) {
                                    e.doit = false;
                                    submission.execute();
                                    return;
                                }
                                ++i;
                            }
                        }
                    }

                    private List getSubmissions() {
                        if (this.fSubmissions != null) {
                            return this.fSubmissions;
                        }
                        this.fSubmissions = new ArrayList<E>();
                        IWorkbench iWorkbench = PlatformUI.getWorkbench();
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = class$0 = Class.forName("org.eclipse.ui.commands.ICommandService");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        ICommandService commandService = (ICommandService)iWorkbench.getAdapter((Class)clazz);
                        IWorkbench iWorkbench2 = PlatformUI.getWorkbench();
                        Class<?> clazz2 = class$1;
                        if (clazz2 == null) {
                            try {
                                clazz2 = class$1 = Class.forName("org.eclipse.ui.keys.IBindingService");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        IBindingService bindingService = (IBindingService)iWorkbench2.getAdapter((Class)clazz2);
                        if (commandService == null || bindingService == null) {
                            return this.fSubmissions;
                        }
                        BindingManager localBindingManager = new BindingManager(new ContextManager(), new CommandManager());
                        Scheme[] definedSchemes = bindingService.getDefinedSchemes();
                        if (definedSchemes != null) {
                            try {
                                int i = 0;
                                while (i < definedSchemes.length) {
                                    Scheme scheme = definedSchemes[i];
                                    Scheme localSchemeCopy = localBindingManager.getScheme(scheme.getId());
                                    localSchemeCopy.define(scheme.getName(), scheme.getDescription(), scheme.getParentId());
                                    ++i;
                                }
                            }
                            catch (NotDefinedException e) {
                                JavaPlugin.log(e);
                            }
                        }
                        localBindingManager.setLocale(bindingService.getLocale());
                        localBindingManager.setPlatform(bindingService.getPlatform());
                        localBindingManager.setBindings(bindingService.getBindings());
                        try {
                            Scheme activeScheme = bindingService.getActiveScheme();
                            if (activeScheme != null) {
                                localBindingManager.setActiveScheme(activeScheme);
                            }
                        }
                        catch (NotDefinedException e) {
                            JavaPlugin.log(e);
                        }
                        this.fSubmissions.add(new Submission(this, this.getKeyBindings(localBindingManager, commandService, "org.eclipse.ui.edit.text.select.wordNext")){
                            final /* synthetic */ 6 this$2;
                            {
                                super($anonymous0);
                                this.this$2 = var1_1;
                            }

                            public void execute() {
                                FocusHandler.access$2(6.access$0(this.this$2)).setText(FocusHandler.access$1(6.access$0(this.this$2)).getText());
                                int caretPosition = FocusHandler.access$1(6.access$0(this.this$2)).getCaretPosition();
                                int newCaret = FocusHandler.access$2(6.access$0(this.this$2)).following(caretPosition);
                                if (newCaret != -1) {
                                    Point selection = FocusHandler.access$1(6.access$0(this.this$2)).getSelection();
                                    if (caretPosition == selection.y) {
                                        FocusHandler.access$1(6.access$0(this.this$2)).setSelection(selection.x, newCaret);
                                    } else {
                                        FocusHandler.access$1(6.access$0(this.this$2)).setSelection(selection.y, newCaret);
                                    }
                                }
                                FocusHandler.access$2(6.access$0(this.this$2)).setText("");
                            }
                        });
                        this.fSubmissions.add(new Submission(this, this.getKeyBindings(localBindingManager, commandService, "org.eclipse.ui.edit.text.select.wordPrevious")){
                            final /* synthetic */ 6 this$2;
                            {
                                super($anonymous0);
                                this.this$2 = var1_1;
                            }

                            public void execute() {
                                FocusHandler.access$2(6.access$0(this.this$2)).setText(FocusHandler.access$1(6.access$0(this.this$2)).getText());
                                int caretPosition = FocusHandler.access$1(6.access$0(this.this$2)).getCaretPosition();
                                int newCaret = FocusHandler.access$2(6.access$0(this.this$2)).preceding(caretPosition);
                                if (newCaret != -1) {
                                    Point selection = FocusHandler.access$1(6.access$0(this.this$2)).getSelection();
                                    if (caretPosition == selection.x) {
                                        FocusHandler.access$1(6.access$0(this.this$2)).setSelection(selection.y, newCaret);
                                    } else {
                                        FocusHandler.access$1(6.access$0(this.this$2)).setSelection(selection.x, newCaret);
                                    }
                                }
                                FocusHandler.access$2(6.access$0(this.this$2)).setText("");
                            }
                        });
                        this.fSubmissions.add(new Submission(this, this.getKeyBindings(localBindingManager, commandService, "org.eclipse.ui.edit.text.goto.wordNext")){
                            final /* synthetic */ 6 this$2;
                            {
                                super($anonymous0);
                                this.this$2 = var1_1;
                            }

                            public void execute() {
                                FocusHandler.access$2(6.access$0(this.this$2)).setText(FocusHandler.access$1(6.access$0(this.this$2)).getText());
                                int caretPosition = FocusHandler.access$1(6.access$0(this.this$2)).getCaretPosition();
                                int newCaret = FocusHandler.access$2(6.access$0(this.this$2)).following(caretPosition);
                                if (newCaret != -1) {
                                    FocusHandler.access$1(6.access$0(this.this$2)).setSelection(newCaret, newCaret);
                                }
                                FocusHandler.access$2(6.access$0(this.this$2)).setText("");
                            }
                        });
                        this.fSubmissions.add(new Submission(this, this.getKeyBindings(localBindingManager, commandService, "org.eclipse.ui.edit.text.goto.wordPrevious")){
                            final /* synthetic */ 6 this$2;
                            {
                                super($anonymous0);
                                this.this$2 = var1_1;
                            }

                            public void execute() {
                                FocusHandler.access$2(6.access$0(this.this$2)).setText(FocusHandler.access$1(6.access$0(this.this$2)).getText());
                                int caretPosition = FocusHandler.access$1(6.access$0(this.this$2)).getCaretPosition();
                                int newCaret = FocusHandler.access$2(6.access$0(this.this$2)).preceding(caretPosition);
                                if (newCaret != -1) {
                                    FocusHandler.access$1(6.access$0(this.this$2)).setSelection(newCaret, newCaret);
                                }
                                FocusHandler.access$2(6.access$0(this.this$2)).setText("");
                            }
                        });
                        this.fSubmissions.add(new Submission(this, this.getKeyBindings(localBindingManager, commandService, "org.eclipse.ui.edit.text.deleteNextWord")){
                            final /* synthetic */ 6 this$2;
                            {
                                super($anonymous0);
                                this.this$2 = var1_1;
                            }

                            public void execute() {
                                int end;
                                int start;
                                Point selection = FocusHandler.access$1(6.access$0(this.this$2)).getSelection();
                                String text = FocusHandler.access$1(6.access$0(this.this$2)).getText();
                                if (selection.x != selection.y) {
                                    start = selection.x;
                                    end = selection.y;
                                } else {
                                    FocusHandler.access$2(6.access$0(this.this$2)).setText(text);
                                    start = FocusHandler.access$1(6.access$0(this.this$2)).getCaretPosition();
                                    end = FocusHandler.access$2(6.access$0(this.this$2)).following(start);
                                    FocusHandler.access$2(6.access$0(this.this$2)).setText("");
                                    if (end == -1) {
                                        return;
                                    }
                                }
                                FocusHandler.access$1(6.access$0(this.this$2)).setText(String.valueOf(text.substring(0, start)) + text.substring(end));
                                FocusHandler.access$1(6.access$0(this.this$2)).setSelection(start, start);
                            }
                        });
                        this.fSubmissions.add(new Submission(this, this.getKeyBindings(localBindingManager, commandService, "org.eclipse.ui.edit.text.deletePreviousWord")){
                            final /* synthetic */ 6 this$2;
                            {
                                super($anonymous0);
                                this.this$2 = var1_1;
                            }

                            public void execute() {
                                int end;
                                int start;
                                Point selection = FocusHandler.access$1(6.access$0(this.this$2)).getSelection();
                                String text = FocusHandler.access$1(6.access$0(this.this$2)).getText();
                                if (selection.x != selection.y) {
                                    start = selection.x;
                                    end = selection.y;
                                } else {
                                    FocusHandler.access$2(6.access$0(this.this$2)).setText(text);
                                    end = FocusHandler.access$1(6.access$0(this.this$2)).getCaretPosition();
                                    start = FocusHandler.access$2(6.access$0(this.this$2)).preceding(end);
                                    FocusHandler.access$2(6.access$0(this.this$2)).setText("");
                                    if (start == -1) {
                                        return;
                                    }
                                }
                                FocusHandler.access$1(6.access$0(this.this$2)).setText(String.valueOf(text.substring(0, start)) + text.substring(end));
                                FocusHandler.access$1(6.access$0(this.this$2)).setSelection(start, start);
                            }
                        });
                        return this.fSubmissions;
                    }

                    private TriggerSequence[] getKeyBindings(BindingManager localBindingManager, ICommandService commandService, String commandID) {
                        Command command = commandService.getCommand(commandID);
                        ParameterizedCommand pCmd = new ParameterizedCommand(command, null);
                        return localBindingManager.getActiveBindingsDisregardingContextFor(pCmd);
                    }

                    static /* synthetic */ FocusHandler access$0(6 var0) {
                        return var0.this$1;
                    }
                };
            }
            return this.fKeyListener;
        }

        static /* synthetic */ void access$0(FocusHandler focusHandler) {
            focusHandler.deactivate();
        }

        static /* synthetic */ Navigable access$1(FocusHandler focusHandler) {
            return focusHandler.fNavigable;
        }

        static /* synthetic */ JavaWordIterator access$2(FocusHandler focusHandler) {
            return focusHandler.fIterator;
        }
    }

    private static abstract class Navigable {
        private Navigable() {
        }

        public abstract Control getControl();

        public abstract String getText();

        public abstract void setText(String var1);

        public abstract Point getSelection();

        public abstract void setSelection(int var1, int var2);

        public abstract int getCaretPosition();
    }

    private static class StyledTextNavigable
    extends Navigable {
        private final StyledText fStyledText;

        public StyledTextNavigable(StyledText styledText) {
            this.fStyledText = styledText;
        }

        public Control getControl() {
            return this.fStyledText;
        }

        public String getText() {
            return this.fStyledText.getText();
        }

        public void setText(String text) {
            this.fStyledText.setText(text);
        }

        public Point getSelection() {
            return this.fStyledText.getSelection();
        }

        public int getCaretPosition() {
            return this.fStyledText.getCaretOffset();
        }

        public void setSelection(int start, int end) {
            this.fStyledText.setSelection(start, end);
        }
    }

    private static abstract class Submission {
        private TriggerSequence[] fTriggerSequences;

        public Submission(TriggerSequence[] triggerSequences) {
            this.fTriggerSequences = triggerSequences;
        }

        public TriggerSequence[] getTriggerSequences() {
            return this.fTriggerSequences;
        }

        public abstract void execute();
    }

    private static class TextNavigable
    extends WorkaroundNavigable {
        static final boolean BUG_106024_TEXT_SELECTION = "win32".equals(SWT.getPlatform()) || "carbon".equals(SWT.getPlatform());
        private final Text fText;

        public TextNavigable(Text text) {
            this.fText = text;
            if (BUG_106024_TEXT_SELECTION) {
                this.fLastSelection = this.getSelection();
                this.fCaretPosition = this.fLastSelection.y;
                this.fText.addKeyListener((KeyListener)new KeyAdapter(this){
                    final /* synthetic */ TextNavigable this$1;
                    {
                        this.this$1 = textNavigable;
                    }

                    public void keyReleased(KeyEvent e) {
                        this.this$1.selectionChanged();
                    }
                });
                this.fText.addMouseListener((MouseListener)new MouseAdapter(this){
                    final /* synthetic */ TextNavigable this$1;
                    {
                        this.this$1 = textNavigable;
                    }

                    public void mouseUp(MouseEvent e) {
                        this.this$1.selectionChanged();
                    }
                });
            }
        }

        public Control getControl() {
            return this.fText;
        }

        public String getText() {
            return this.fText.getText();
        }

        public void setText(String text) {
            this.fText.setText(text);
        }

        public Point getSelection() {
            return this.fText.getSelection();
        }

        public int getCaretPosition() {
            if (BUG_106024_TEXT_SELECTION) {
                this.selectionChanged();
                return this.fCaretPosition;
            }
            return this.fText.getCaretPosition();
        }

        public void setSelection(int start, int end) {
            this.fText.setSelection(start, end);
        }
    }

    private static abstract class WorkaroundNavigable
    extends Navigable {
        Point fLastSelection;
        int fCaretPosition;

        private WorkaroundNavigable() {
        }

        void selectionChanged() {
            Point selection = this.getSelection();
            if (!selection.equals((Object)this.fLastSelection)) {
                this.fCaretPosition = selection.x == selection.y ? selection.x : (this.fLastSelection.y == selection.y ? selection.x : selection.y);
            }
            this.fLastSelection = selection;
        }
    }
}

