/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.ModifierRewrite;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.JDTRefactoringDescriptor;
import org.eclipse.jdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine2;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.CreateCompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.jdt.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.structure.ConstructorReferenceFinder;
import org.eclipse.jdt.internal.corext.refactoring.structure.ImportRewriteUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.MemberVisibilityAdjustor;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.JavadocUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.IRefactoringStatusEntryComparator;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.RefactoringStatusEntry;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public final class MoveInnerToTopRefactoring
extends ScriptableRefactoring {
    private static final String ATTRIBUTE_FIELD = "field";
    private static final String ATTRIBUTE_MANDATORY = "mandatory";
    private static final String ATTRIBUTE_POSSIBLE = "possible";
    private static final String ATTRIBUTE_FINAL = "final";
    private static final String ATTRIBUTE_FIELD_NAME = "fieldName";
    private static final String ATTRIBUTE_PARAMETER_NAME = "parameterName";
    private TextChangeManager fChangeManager;
    private CodeGenerationSettings fCodeGenerationSettings;
    private boolean fCreateInstanceField;
    private String fEnclosingInstanceFieldName;
    private boolean fIsInstanceFieldCreationMandatory;
    private boolean fIsInstanceFieldCreationPossible;
    private boolean fMarkInstanceFieldAsFinal;
    private String fNameForEnclosingInstanceConstructorParameter;
    private String fNewSourceOfInputType;
    private CompilationUnitRewrite fSourceRewrite;
    private Collection fStaticImports;
    private IType fType;
    private String fQualifiedTypeName;
    private Collection fTypeImports;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    private static void addTypeParameters(CompilationUnit unit, IType type, Map map) throws JavaModelException {
        Assert.isNotNull((Object)unit);
        Assert.isNotNull((Object)type);
        Assert.isNotNull((Object)map);
        AbstractTypeDeclaration declaration = ASTNodeSearchUtil.getAbstractTypeDeclarationNode(type, unit);
        if (declaration instanceof TypeDeclaration) {
            ITypeBinding binding = null;
            TypeParameter parameter = null;
            Iterator iterator = ((TypeDeclaration)declaration).typeParameters().iterator();
            while (iterator.hasNext()) {
                parameter = (TypeParameter)iterator.next();
                binding = parameter.resolveBinding();
                if (binding == null || map.containsKey(binding.getKey())) continue;
                map.put(binding.getKey(), binding);
            }
            IType declaring = type.getDeclaringType();
            if (declaring != null && !Flags.isStatic((int)type.getFlags())) {
                MoveInnerToTopRefactoring.addTypeParameters(unit, declaring, map);
            }
        }
    }

    private static boolean containsNonStatic(FieldAccess[] accesses) {
        int i = 0;
        while (i < accesses.length) {
            if (!MoveInnerToTopRefactoring.isStatic(accesses[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean containsNonStatic(MethodInvocation[] invocations) {
        int i = 0;
        while (i < invocations.length) {
            if (!MoveInnerToTopRefactoring.isStatic(invocations[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean containsNonStatic(SimpleName[] fieldNames) {
        int i = 0;
        while (i < fieldNames.length) {
            if (!MoveInnerToTopRefactoring.isStaticFieldName(fieldNames[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean containsStatusEntry(RefactoringStatus status, RefactoringStatusEntry other) {
        return status.getEntries(new IRefactoringStatusEntryComparator(){

            public final int compare(RefactoringStatusEntry entry1, RefactoringStatusEntry entry2) {
                return entry1.getMessage().compareTo(entry2.getMessage());
            }
        }, other).length > 0;
    }

    private static AbstractTypeDeclaration findTypeDeclaration(IType enclosing, AbstractTypeDeclaration[] declarations) {
        String typeName = enclosing.getElementName();
        int i = 0;
        while (i < declarations.length) {
            AbstractTypeDeclaration declaration = declarations[i];
            if (declaration.getName().getIdentifier().equals(typeName)) {
                return declaration;
            }
            ++i;
        }
        return null;
    }

    private static AbstractTypeDeclaration findTypeDeclaration(IType type, CompilationUnit unit) {
        List types = MoveInnerToTopRefactoring.getDeclaringTypes(type);
        types.add(type);
        AbstractTypeDeclaration[] declarations = unit.types().toArray(new AbstractTypeDeclaration[unit.types().size()]);
        AbstractTypeDeclaration declaration = null;
        Iterator iterator = types.iterator();
        while (iterator.hasNext()) {
            IType enclosing = (IType)iterator.next();
            declaration = MoveInnerToTopRefactoring.findTypeDeclaration(enclosing, declarations);
            Assert.isNotNull((Object)declaration);
            declarations = MoveInnerToTopRefactoring.getAbstractTypeDeclarations(declaration);
        }
        Assert.isNotNull(declaration);
        return declaration;
    }

    public static AbstractTypeDeclaration[] getAbstractTypeDeclarations(AbstractTypeDeclaration declaration) {
        int typeCount = 0;
        ListIterator iterator = declaration.bodyDeclarations().listIterator();
        while (iterator.hasNext()) {
            if (!(iterator.next() instanceof AbstractTypeDeclaration)) continue;
            ++typeCount;
        }
        AbstractTypeDeclaration[] declarations = new AbstractTypeDeclaration[typeCount];
        int next = 0;
        ListIterator iterator2 = declaration.bodyDeclarations().listIterator();
        while (iterator2.hasNext()) {
            Object object = iterator2.next();
            if (!(object instanceof AbstractTypeDeclaration)) continue;
            declarations[next++] = (AbstractTypeDeclaration)object;
        }
        return declarations;
    }

    private static ITypeBinding getDeclaringTypeBinding(FieldAccess fieldAccess) {
        IVariableBinding varBinding = fieldAccess.resolveFieldBinding();
        if (varBinding == null) {
            return null;
        }
        return varBinding.getDeclaringClass();
    }

    private static ITypeBinding getDeclaringTypeBinding(MethodInvocation methodInvocation) {
        IMethodBinding binding = methodInvocation.resolveMethodBinding();
        if (binding == null) {
            return null;
        }
        return binding.getDeclaringClass();
    }

    private static List getDeclaringTypes(IType type) {
        IType declaringType = type.getDeclaringType();
        if (declaringType == null) {
            return new ArrayList(0);
        }
        List result = MoveInnerToTopRefactoring.getDeclaringTypes(declaringType);
        result.add(declaringType);
        return result;
    }

    private static String[] getFieldNames(IType type) {
        try {
            IField[] fields = type.getFields();
            ArrayList<String> result = new ArrayList<String>(fields.length);
            int i = 0;
            while (i < fields.length) {
                result.add(fields[i].getElementName());
                ++i;
            }
            return result.toArray(new String[result.size()]);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    private static Set getMergedSet(Set s1, Set s2) {
        HashSet result = new HashSet();
        result.addAll(s1);
        result.addAll(s2);
        return result;
    }

    private static String[] getParameterNamesOfAllConstructors(IType type) throws JavaModelException {
        IMethod[] constructors = JavaElementUtil.getAllConstructors(type);
        HashSet<String> result = new HashSet<String>();
        int i = 0;
        while (i < constructors.length) {
            result.addAll(Arrays.asList(constructors[i].getParameterNames()));
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    private static ASTNode[] getReferenceNodesIn(CompilationUnit cuNode, Map references, ICompilationUnit cu) {
        SearchMatch[] results = (SearchMatch[])references.get(cu);
        if (results == null) {
            return new ASTNode[0];
        }
        return ASTNodeSearchUtil.getAstNodes(results, cuNode);
    }

    private static boolean isCorrespondingTypeBinding(ITypeBinding binding, IType type) {
        if (binding == null) {
            return false;
        }
        return Bindings.getFullyQualifiedName(binding).equals(JavaElementUtil.createSignature((IMember)type));
    }

    private static boolean isStatic(FieldAccess access) {
        IVariableBinding fieldBinding = access.resolveFieldBinding();
        if (fieldBinding == null) {
            return false;
        }
        return JdtFlags.isStatic(fieldBinding);
    }

    private static boolean isStatic(MethodInvocation invocation) {
        IMethodBinding methodBinding = invocation.resolveMethodBinding();
        if (methodBinding == null) {
            return false;
        }
        return JdtFlags.isStatic(methodBinding);
    }

    private static boolean isStaticFieldName(SimpleName name) {
        IBinding binding = name.resolveBinding();
        if (!(binding instanceof IVariableBinding)) {
            return false;
        }
        IVariableBinding variableBinding = (IVariableBinding)binding;
        if (!variableBinding.isField()) {
            return false;
        }
        return JdtFlags.isStatic(variableBinding);
    }

    public MoveInnerToTopRefactoring(IType type, CodeGenerationSettings settings) throws JavaModelException {
        this.fType = type;
        this.fCodeGenerationSettings = settings;
        this.fMarkInstanceFieldAsFinal = true;
        if (this.fType != null) {
            this.initialize();
        }
    }

    private void initialize() throws JavaModelException {
        this.fQualifiedTypeName = JavaModelUtil.concatenateName(this.fType.getPackageFragment().getElementName(), this.fType.getElementName());
        this.fEnclosingInstanceFieldName = this.getInitialNameForEnclosingInstanceField();
        this.fSourceRewrite = new CompilationUnitRewrite(this.fType.getCompilationUnit());
        this.fIsInstanceFieldCreationPossible = !JdtFlags.isStatic((IMember)this.fType) && !this.fType.isAnnotation() && !this.fType.isEnum();
        this.fCreateInstanceField = this.fIsInstanceFieldCreationMandatory = this.fIsInstanceFieldCreationPossible && this.isInstanceFieldCreationMandatory();
    }

    private void addEnclosingInstanceDeclaration(AbstractTypeDeclaration declaration, ASTRewrite rewrite) throws CoreException {
        Assert.isNotNull((Object)declaration);
        Assert.isNotNull((Object)rewrite);
        AST ast = declaration.getAST();
        VariableDeclarationFragment fragment = ast.newVariableDeclarationFragment();
        fragment.setName(ast.newSimpleName(this.fEnclosingInstanceFieldName));
        FieldDeclaration newField = ast.newFieldDeclaration(fragment);
        newField.modifiers().addAll(ASTNodeFactory.newModifiers(ast, this.getEnclosingInstanceAccessModifiers()));
        newField.setType(this.createEnclosingType(ast));
        String comment = CodeGeneration.getFieldComment(this.fType.getCompilationUnit(), declaration.getName().getIdentifier(), this.fEnclosingInstanceFieldName, StubUtility.getLineDelimiterUsed(this.fType.getJavaProject()));
        if (comment != null && comment.length() > 0) {
            Javadoc doc = (Javadoc)rewrite.createStringPlaceholder(comment, 29);
            newField.setJavadoc(doc);
        }
        rewrite.getListRewrite((ASTNode)declaration, declaration.getBodyDeclarationsProperty()).insertFirst((ASTNode)newField, null);
    }

    private void addEnclosingInstanceTypeParameters(ITypeBinding[] parameters, AbstractTypeDeclaration declaration, ASTRewrite rewrite) {
        Assert.isNotNull((Object)parameters);
        Assert.isNotNull((Object)declaration);
        Assert.isNotNull((Object)rewrite);
        if (declaration instanceof TypeDeclaration) {
            TypeDeclaration type = (TypeDeclaration)declaration;
            List existing = type.typeParameters();
            HashSet<String> names = new HashSet<String>();
            TypeParameter parameter = null;
            Iterator iterator = existing.iterator();
            while (iterator.hasNext()) {
                parameter = (TypeParameter)iterator.next();
                names.add(parameter.getName().getIdentifier());
            }
            ListRewrite rewriter = rewrite.getListRewrite((ASTNode)type, TypeDeclaration.TYPE_PARAMETERS_PROPERTY);
            String name = null;
            int index = 0;
            while (index < parameters.length) {
                name = parameters[index].getName();
                if (!names.contains(name)) {
                    parameter = type.getAST().newTypeParameter();
                    parameter.setName(type.getAST().newSimpleName(name));
                    rewriter.insertLast((ASTNode)parameter, null);
                }
                ++index;
            }
        }
    }

    private void addImportsToTargetUnit(ICompilationUnit targetUnit, IProgressMonitor monitor) throws CoreException, JavaModelException {
        monitor.beginTask("", 2);
        try {
            Iterator iterator;
            ImportRewrite rewrite = StubUtility.createImportRewrite(targetUnit, true);
            if (this.fTypeImports != null) {
                ITypeBinding type = null;
                iterator = this.fTypeImports.iterator();
                while (iterator.hasNext()) {
                    type = (ITypeBinding)iterator.next();
                    rewrite.addImport(type);
                }
            }
            if (this.fStaticImports != null) {
                IBinding binding = null;
                iterator = this.fStaticImports.iterator();
                while (iterator.hasNext()) {
                    binding = (IBinding)iterator.next();
                    rewrite.addStaticImport(binding);
                }
            }
            this.fTypeImports = null;
            this.fStaticImports = null;
            TextEdit edits = rewrite.rewriteImports((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            JavaModelUtil.applyEdit(targetUnit, edits, false, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        finally {
            monitor.done();
        }
    }

    private void addInheritedTypeQualifications(AbstractTypeDeclaration declaration, CompilationUnitRewrite targetRewrite, TextEditGroup group) {
        Assert.isNotNull((Object)declaration);
        Assert.isNotNull((Object)targetRewrite);
        CompilationUnit unit = (CompilationUnit)declaration.getRoot();
        ITypeBinding binding = declaration.resolveBinding();
        if (binding != null) {
            Type type = null;
            if (declaration instanceof TypeDeclaration && (type = ((TypeDeclaration)declaration).getSuperclassType()) != null && unit.findDeclaringNode((IBinding)binding) != null) {
                this.addTypeQualification(type, targetRewrite, group);
            }
            List types = null;
            if (declaration instanceof TypeDeclaration) {
                types = ((TypeDeclaration)declaration).superInterfaceTypes();
            } else if (declaration instanceof EnumDeclaration) {
                types = ((EnumDeclaration)declaration).superInterfaceTypes();
            }
            if (types != null) {
                Iterator iterator = types.iterator();
                while (iterator.hasNext()) {
                    type = (Type)iterator.next();
                    if (unit.findDeclaringNode((IBinding)type.resolveBinding()) == null) continue;
                    this.addTypeQualification(type, targetRewrite, group);
                }
            }
        }
    }

    private void addParameterToConstructor(ASTRewrite rewrite, MethodDeclaration declaration) throws JavaModelException {
        Assert.isNotNull((Object)rewrite);
        Assert.isNotNull((Object)declaration);
        AST ast = declaration.getAST();
        String name = this.getNameForEnclosingInstanceConstructorParameter();
        SingleVariableDeclaration variable = ast.newSingleVariableDeclaration();
        variable.setType(this.createEnclosingType(ast));
        variable.setName(ast.newSimpleName(name));
        rewrite.getListRewrite((ASTNode)declaration, MethodDeclaration.PARAMETERS_PROPERTY).insertFirst((ASTNode)variable, null);
        JavadocUtil.addParamJavadoc(name, declaration, rewrite, this.fType.getJavaProject(), null);
    }

    private void addSimpleTypeQualification(CompilationUnitRewrite targetRewrite, ITypeBinding declaring, SimpleType simpleType, TextEditGroup group) {
        Assert.isNotNull((Object)targetRewrite);
        Assert.isNotNull((Object)declaring);
        Assert.isNotNull((Object)simpleType);
        AST ast = targetRewrite.getRoot().getAST();
        if (!(simpleType.getName() instanceof QualifiedName)) {
            targetRewrite.getASTRewrite().replace((ASTNode)simpleType, (ASTNode)ast.newQualifiedType(targetRewrite.getImportRewrite().addImport(declaring, ast), ast.newSimpleName(simpleType.getName().getFullyQualifiedName())), group);
            targetRewrite.getImportRemover().registerRemovedNode((ASTNode)simpleType);
        }
    }

    private void addTypeQualification(Type type, CompilationUnitRewrite targetRewrite, TextEditGroup group) {
        ITypeBinding declaring;
        Assert.isNotNull((Object)type);
        Assert.isNotNull((Object)targetRewrite);
        ITypeBinding binding = type.resolveBinding();
        if (binding != null && (declaring = binding.getDeclaringClass()) != null) {
            ParameterizedType parameterizedType;
            Type rawType;
            if (type instanceof SimpleType) {
                SimpleType simpleType = (SimpleType)type;
                this.addSimpleTypeQualification(targetRewrite, declaring, simpleType, group);
            } else if (type instanceof ParameterizedType && (rawType = (parameterizedType = (ParameterizedType)type).getType()) instanceof SimpleType) {
                this.addSimpleTypeQualification(targetRewrite, declaring, (SimpleType)rawType, group);
            }
        }
    }

    private RefactoringStatus checkConstructorParameterNames() {
        RefactoringStatus result = new RefactoringStatus();
        CompilationUnit cuNode = new RefactoringASTParser(3).parse((ITypeRoot)this.fType.getCompilationUnit(), false);
        MethodDeclaration[] nodes = this.getConstructorDeclarationNodes(MoveInnerToTopRefactoring.findTypeDeclaration(this.fType, cuNode));
        int i = 0;
        while (i < nodes.length) {
            MethodDeclaration constructor = nodes[i];
            Iterator iter = constructor.parameters().iterator();
            while (iter.hasNext()) {
                SingleVariableDeclaration param = (SingleVariableDeclaration)iter.next();
                if (!this.fEnclosingInstanceFieldName.equals(param.getName().getIdentifier())) continue;
                String msg = Messages.format(RefactoringCoreMessages.MoveInnerToTopRefactoring_name_used, new String[]{param.getName().getIdentifier(), this.fType.getElementName()});
                result.addError(msg, JavaStatusContext.create((ITypeRoot)this.fType.getCompilationUnit(), (ASTNode)param));
            }
            ++i;
        }
        return result;
    }

    public RefactoringStatus checkEnclosingInstanceName(String name) {
        if (!this.fCreateInstanceField) {
            return new RefactoringStatus();
        }
        RefactoringStatus result = Checks.checkFieldName(name);
        if (!Checks.startsWithLowerCase(name)) {
            result.addWarning(RefactoringCoreMessages.MoveInnerToTopRefactoring_names_start_lowercase);
        }
        if (this.fType.getField(name).exists()) {
            Object[] keys = new String[]{name, this.fType.getElementName()};
            String msg = Messages.format(RefactoringCoreMessages.MoveInnerToTopRefactoring_already_declared, keys);
            result.addError(msg, JavaStatusContext.create((IMember)this.fType.getField(name)));
        }
        return result;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 2);
        try {
            RefactoringStatus result = new RefactoringStatus();
            if (JdtFlags.isStatic((IMember)this.fType)) {
                result.merge(this.checkEnclosingInstanceName(this.fEnclosingInstanceFieldName));
            }
            if (this.fType.getPackageFragment().getCompilationUnit(JavaModelUtil.getRenamedCUName(this.fType.getCompilationUnit(), this.fType.getElementName())).exists()) {
                String message = Messages.format(RefactoringCoreMessages.MoveInnerToTopRefactoring_compilation_Unit_exists, new String[]{JavaModelUtil.getRenamedCUName(this.fType.getCompilationUnit(), this.fType.getElementName()), this.fType.getPackageFragment().getElementName()});
                result.addFatalError(message);
            }
            result.merge(this.checkEnclosingInstanceName(this.fEnclosingInstanceFieldName));
            result.merge(Checks.checkCompilationUnitName(JavaModelUtil.getRenamedCUName(this.fType.getCompilationUnit(), this.fType.getElementName())));
            result.merge(this.checkConstructorParameterNames());
            result.merge(this.checkTypeNameInPackage());
            this.fChangeManager = this.createChangeManager((IProgressMonitor)new SubProgressMonitor(pm, 1), result);
            result.merge(Checks.validateModifiesFiles(ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits()), this.getValidationContext()));
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor monitor) throws CoreException {
        return Checks.checkIfCuBroken((IMember)this.fType);
    }

    private RefactoringStatus checkTypeNameInPackage() throws JavaModelException {
        IType type = Checks.findTypeInPackage(this.fType.getPackageFragment(), this.fType.getElementName());
        if (type == null || !type.exists()) {
            return null;
        }
        String message = Messages.format(RefactoringCoreMessages.MoveInnerToTopRefactoring_type_exists, new String[]{this.fType.getElementName(), this.fType.getPackageFragment().getElementName()});
        return RefactoringStatus.createErrorStatus((String)message);
    }

    private Expression createAccessExpressionToEnclosingInstanceFieldText(ASTNode node, IBinding binding, AbstractTypeDeclaration declaration) {
        if (Modifier.isStatic((int)binding.getModifiers())) {
            return node.getAST().newName(JavaModelUtil.getTypeQualifiedName(this.fType.getDeclaringType()));
        }
        if (this.isInAnonymousTypeInsideInputType(node, declaration) || this.isInLocalTypeInsideInputType(node, declaration) || this.isInNonStaticMemberTypeInsideInputType(node, declaration)) {
            return this.createQualifiedReadAccessExpressionForEnclosingInstance(node.getAST());
        }
        return this.createReadAccessExpressionForEnclosingInstance(node.getAST());
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException {
        boolean enclosing;
        monitor.beginTask(RefactoringCoreMessages.MoveInnerToTopRefactoring_creating_change, 1);
        HashMap<String, String> arguments = new HashMap<String, String>();
        String project = null;
        IJavaProject javaProject = this.fType.getJavaProject();
        if (javaProject != null) {
            project = javaProject.getElementName();
        }
        String description = Messages.format(RefactoringCoreMessages.MoveInnerToTopRefactoring_descriptor_description_short, this.fType.getElementName());
        String header = Messages.format(RefactoringCoreMessages.MoveInnerToTopRefactoring_descriptor_description, new String[]{JavaElementLabels.getElementLabel((IJavaElement)this.fType, JavaElementLabels.ALL_FULLY_QUALIFIED), JavaElementLabels.getElementLabel(this.fType.getParent(), JavaElementLabels.ALL_FULLY_QUALIFIED)});
        JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(project, this, header);
        comment.addSetting(Messages.format(RefactoringCoreMessages.MoveInnerToTopRefactoring_original_pattern, JavaElementLabels.getElementLabel((IJavaElement)this.fType, JavaElementLabels.ALL_FULLY_QUALIFIED)));
        boolean bl = enclosing = this.fEnclosingInstanceFieldName != null && !"".equals(this.fEnclosingInstanceFieldName);
        if (enclosing) {
            comment.addSetting(Messages.format(RefactoringCoreMessages.MoveInnerToTopRefactoring_field_pattern, this.fEnclosingInstanceFieldName));
        }
        if (this.fNameForEnclosingInstanceConstructorParameter != null && !"".equals(this.fNameForEnclosingInstanceConstructorParameter)) {
            comment.addSetting(Messages.format(RefactoringCoreMessages.MoveInnerToTopRefactoring_parameter_pattern, this.fNameForEnclosingInstanceConstructorParameter));
        }
        if (enclosing && this.fMarkInstanceFieldAsFinal) {
            comment.addSetting(RefactoringCoreMessages.MoveInnerToTopRefactoring_declare_final);
        }
        JDTRefactoringDescriptor descriptor = new JDTRefactoringDescriptor("org.eclipse.jdt.ui.move.inner", project, description, comment.asString(), arguments, 786438);
        arguments.put("input", descriptor.elementToHandle((IJavaElement)this.fType));
        if (enclosing) {
            arguments.put(ATTRIBUTE_FIELD_NAME, this.fEnclosingInstanceFieldName);
        }
        if (this.fNameForEnclosingInstanceConstructorParameter != null && !"".equals(this.fNameForEnclosingInstanceConstructorParameter)) {
            arguments.put(ATTRIBUTE_PARAMETER_NAME, this.fNameForEnclosingInstanceConstructorParameter);
        }
        arguments.put(ATTRIBUTE_FIELD, Boolean.valueOf(this.fCreateInstanceField).toString());
        arguments.put(ATTRIBUTE_FINAL, Boolean.valueOf(this.fMarkInstanceFieldAsFinal).toString());
        arguments.put(ATTRIBUTE_POSSIBLE, Boolean.valueOf(this.fIsInstanceFieldCreationPossible).toString());
        arguments.put(ATTRIBUTE_MANDATORY, Boolean.valueOf(this.fIsInstanceFieldCreationMandatory).toString());
        DynamicValidationRefactoringChange result = new DynamicValidationRefactoringChange(descriptor, RefactoringCoreMessages.MoveInnerToTopRefactoring_move_to_Top);
        result.addAll((Change[])this.fChangeManager.getAllChanges());
        result.add(this.createCompilationUnitForMovedType((IProgressMonitor)new SubProgressMonitor(monitor, 1)));
        return result;
    }

    private TextChangeManager createChangeManager(IProgressMonitor monitor, RefactoringStatus status) throws CoreException {
        Assert.isNotNull((Object)monitor);
        Assert.isNotNull((Object)status);
        TextChangeManager manager = new TextChangeManager();
        try {
            monitor.beginTask(RefactoringCoreMessages.MoveInnerToTopRefactoring_creating_preview, 4);
            HashMap<ICompilationUnit, CompilationUnitRewrite> rewrites = new HashMap<ICompilationUnit, CompilationUnitRewrite>(2);
            this.fSourceRewrite.clearASTAndImportRewrites();
            rewrites.put(this.fSourceRewrite.getCu(), this.fSourceRewrite);
            MemberVisibilityAdjustor adjustor = new MemberVisibilityAdjustor((IJavaElement)this.fType.getPackageFragment(), (IMember)this.fType);
            adjustor.setRewrites(rewrites);
            adjustor.setVisibilitySeverity(2);
            adjustor.setFailureSeverity(2);
            adjustor.setStatus(status);
            adjustor.adjustVisibility((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            LinkedHashMap parameters = new LinkedHashMap();
            MoveInnerToTopRefactoring.addTypeParameters(this.fSourceRewrite.getRoot(), this.fType, parameters);
            ITypeBinding[] bindings = new ITypeBinding[parameters.values().size()];
            parameters.values().toArray(bindings);
            Map typeReferences = this.createTypeReferencesMapping((IProgressMonitor)new SubProgressMonitor(monitor, 1), status);
            Map constructorReferences = null;
            constructorReferences = JdtFlags.isStatic((IMember)this.fType) ? new HashMap(0) : this.createConstructorReferencesMapping((IProgressMonitor)new SubProgressMonitor(monitor, 1), status);
            if (this.fCreateInstanceField) {
                IType type = this.fType;
                Modifier.ModifierKeyword keyword = null;
                while ((type = type.getDeclaringType()) != null) {
                    if (adjustor.getAdjustments().containsKey(type) || !Modifier.isPrivate((int)type.getFlags())) continue;
                    adjustor.getAdjustments().put(type, new MemberVisibilityAdjustor.OutgoingMemberVisibilityAdjustment((IMember)type, keyword, RefactoringStatus.createWarningStatus((String)Messages.format(RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_type_warning, new String[]{MemberVisibilityAdjustor.getLabel((IJavaElement)type), MemberVisibilityAdjustor.getLabel(keyword)}), (RefactoringStatusContext)JavaStatusContext.create((ITypeRoot)type.getCompilationUnit(), type.getSourceRange()))));
                }
            }
            monitor.worked(1);
            Iterator iterator = MoveInnerToTopRefactoring.getMergedSet(typeReferences.keySet(), constructorReferences.keySet()).iterator();
            while (iterator.hasNext()) {
                ICompilationUnit unit = (ICompilationUnit)iterator.next();
                CompilationUnitRewrite targetRewrite = this.getCompilationUnitRewrite(unit);
                this.createCompilationUnitRewrite(bindings, targetRewrite, typeReferences, constructorReferences, adjustor.getAdjustments().containsKey(this.fType), this.fType.getCompilationUnit(), unit, false, status, monitor);
                if (unit.equals(this.fType.getCompilationUnit())) {
                    try {
                        adjustor.setStatus(new RefactoringStatus());
                        adjustor.rewriteVisibility(targetRewrite.getCu(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                    finally {
                        adjustor.setStatus(status);
                    }
                    this.fNewSourceOfInputType = this.createNewSource(targetRewrite, unit);
                    targetRewrite.clearASTAndImportRewrites();
                    this.createCompilationUnitRewrite(bindings, targetRewrite, typeReferences, constructorReferences, adjustor.getAdjustments().containsKey(this.fType), this.fType.getCompilationUnit(), unit, true, status, monitor);
                }
                adjustor.rewriteVisibility(targetRewrite.getCu(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                manager.manage(unit, (TextChange)targetRewrite.createChange());
            }
        }
        finally {
            monitor.done();
        }
        return manager;
    }

    private Change createCompilationUnitForMovedType(IProgressMonitor pm) throws CoreException {
        ICompilationUnit newCuWC = null;
        try {
            newCuWC = this.fType.getPackageFragment().getCompilationUnit(JavaModelUtil.getRenamedCUName(this.fType.getCompilationUnit(), this.fType.getElementName())).getWorkingCopy(null);
            String source = this.createSourceForNewCu(newCuWC, pm);
            CreateCompilationUnitChange createCompilationUnitChange = new CreateCompilationUnitChange(this.fType.getPackageFragment().getCompilationUnit(JavaModelUtil.getRenamedCUName(this.fType.getCompilationUnit(), this.fType.getElementName())), source, null);
            return createCompilationUnitChange;
        }
        finally {
            if (newCuWC != null) {
                newCuWC.discardWorkingCopy();
            }
        }
    }

    private void createCompilationUnitRewrite(ITypeBinding[] parameters, CompilationUnitRewrite targetRewrite, Map typeReferences, Map constructorReferences, boolean visibilityWasAdjusted, ICompilationUnit sourceUnit, ICompilationUnit targetUnit, boolean remove, RefactoringStatus status, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)parameters);
        Assert.isNotNull((Object)targetRewrite);
        Assert.isNotNull((Object)typeReferences);
        Assert.isNotNull((Object)constructorReferences);
        Assert.isNotNull((Object)sourceUnit);
        Assert.isNotNull((Object)targetUnit);
        CompilationUnit root = targetRewrite.getRoot();
        ASTRewrite rewrite = targetRewrite.getASTRewrite();
        if (targetUnit.equals(sourceUnit)) {
            AbstractTypeDeclaration declaration = MoveInnerToTopRefactoring.findTypeDeclaration(this.fType, root);
            TextEditGroup qualifierGroup = this.fSourceRewrite.createGroupDescription(RefactoringCoreMessages.MoveInnerToTopRefactoring_change_qualifier);
            ITypeBinding binding = declaration.resolveBinding();
            if (!remove) {
                if (!JdtFlags.isStatic((IMember)this.fType) && this.fCreateInstanceField) {
                    if (JavaElementUtil.getAllConstructors(this.fType).length == 0) {
                        this.createConstructor(declaration, rewrite);
                    } else {
                        this.modifyConstructors(declaration, rewrite);
                    }
                    this.addInheritedTypeQualifications(declaration, targetRewrite, qualifierGroup);
                    this.addEnclosingInstanceDeclaration(declaration, rewrite);
                }
                this.fTypeImports = new HashSet();
                this.fStaticImports = new HashSet();
                ImportRewriteUtil.collectImports(this.fType.getJavaProject(), (ASTNode)declaration, this.fTypeImports, this.fStaticImports, false);
                if (binding != null) {
                    this.fTypeImports.remove(binding);
                }
            }
            this.addEnclosingInstanceTypeParameters(parameters, declaration, rewrite);
            this.modifyAccessToEnclosingInstance(targetRewrite, declaration, status, monitor);
            if (binding != null) {
                this.modifyInterfaceMemberModifiers(binding);
                ITypeBinding declaring = binding.getDeclaringClass();
                if (declaring != null) {
                    declaration.accept((ASTVisitor)new TypeReferenceQualifier(binding, null));
                }
            }
            TextEditGroup groupMove = targetRewrite.createGroupDescription(RefactoringCoreMessages.MoveInnerToTopRefactoring_change_label);
            if (remove) {
                rewrite.remove((ASTNode)declaration, groupMove);
                targetRewrite.getImportRemover().registerRemovedNode((ASTNode)declaration);
            } else {
                int newFlags = JdtFlags.clearFlag(8, declaration.getModifiers());
                if (!visibilityWasAdjusted && (Modifier.isPrivate((int)declaration.getModifiers()) || Modifier.isProtected((int)declaration.getModifiers()))) {
                    newFlags = JdtFlags.clearFlag(6, newFlags);
                    RefactoringStatusEntry entry = new RefactoringStatusEntry(2, Messages.format(RefactoringCoreMessages.MoveInnerToTopRefactoring_change_visibility_type_warning, new String[]{BindingLabelProvider.getBindingLabel((IBinding)binding, JavaElementLabels.ALL_FULLY_QUALIFIED)}), JavaStatusContext.create((ITypeRoot)this.fSourceRewrite.getCu()));
                    if (!MoveInnerToTopRefactoring.containsStatusEntry(status, entry)) {
                        status.addEntry(entry);
                    }
                }
                ModifierRewrite.create(rewrite, (ASTNode)declaration).setModifiers(newFlags, groupMove);
            }
        }
        ASTNode[] references = MoveInnerToTopRefactoring.getReferenceNodesIn(root, typeReferences, targetUnit);
        int index = 0;
        while (index < references.length) {
            this.updateTypeReference(parameters, references[index], targetRewrite, targetUnit);
            ++index;
        }
        references = MoveInnerToTopRefactoring.getReferenceNodesIn(root, constructorReferences, targetUnit);
        index = 0;
        while (index < references.length) {
            this.updateConstructorReference(parameters, references[index], targetRewrite, targetUnit);
            ++index;
        }
    }

    private void createConstructor(AbstractTypeDeclaration declaration, ASTRewrite rewrite) throws CoreException {
        Assert.isNotNull((Object)declaration);
        Assert.isNotNull((Object)rewrite);
        AST ast = declaration.getAST();
        MethodDeclaration constructor = ast.newMethodDeclaration();
        constructor.setConstructor(true);
        constructor.setName(ast.newSimpleName(declaration.getName().getIdentifier()));
        String comment = CodeGeneration.getMethodComment(this.fType.getCompilationUnit(), this.fType.getElementName(), this.fType.getElementName(), this.getNewConstructorParameterNames(), new String[0], null, null, StubUtility.getLineDelimiterUsed(this.fType.getJavaProject()));
        if (comment != null && comment.length() > 0) {
            Javadoc doc = (Javadoc)rewrite.createStringPlaceholder(comment, 29);
            constructor.setJavadoc(doc);
        }
        if (this.fCreateInstanceField) {
            SingleVariableDeclaration variable = ast.newSingleVariableDeclaration();
            String name = this.getNameForEnclosingInstanceConstructorParameter();
            variable.setName(ast.newSimpleName(name));
            variable.setType(this.createEnclosingType(ast));
            constructor.parameters().add(variable);
            Block body = ast.newBlock();
            Assignment assignment = ast.newAssignment();
            if (this.fCodeGenerationSettings.useKeywordThis || this.fEnclosingInstanceFieldName.equals(this.fNameForEnclosingInstanceConstructorParameter)) {
                FieldAccess access = ast.newFieldAccess();
                access.setExpression((Expression)ast.newThisExpression());
                access.setName(ast.newSimpleName(this.fEnclosingInstanceFieldName));
                assignment.setLeftHandSide((Expression)access);
            } else {
                assignment.setLeftHandSide((Expression)ast.newSimpleName(this.fEnclosingInstanceFieldName));
            }
            assignment.setRightHandSide((Expression)ast.newSimpleName(name));
            ExpressionStatement statement = ast.newExpressionStatement((Expression)assignment);
            body.statements().add(statement);
            constructor.setBody(body);
        } else {
            constructor.setBody(ast.newBlock());
        }
        rewrite.getListRewrite((ASTNode)declaration, declaration.getBodyDeclarationsProperty()).insertFirst((ASTNode)constructor, null);
    }

    private Map createConstructorReferencesMapping(IProgressMonitor pm, RefactoringStatus status) throws JavaModelException {
        SearchResultGroup[] groups = ConstructorReferenceFinder.getConstructorReferences(this.fType, pm, status);
        HashMap<ICompilationUnit, SearchMatch[]> result = new HashMap<ICompilationUnit, SearchMatch[]>();
        int i = 0;
        while (i < groups.length) {
            SearchResultGroup group = groups[i];
            ICompilationUnit cu = group.getCompilationUnit();
            if (cu != null) {
                result.put(cu, group.getSearchResults());
            }
            ++i;
        }
        return result;
    }

    private Expression createEnclosingInstanceCreationString(ASTNode node, ICompilationUnit cu) throws JavaModelException {
        Assert.isTrue((node instanceof ClassInstanceCreation || node instanceof SuperConstructorInvocation ? 1 : 0) != 0);
        Assert.isNotNull((Object)cu);
        Expression expression = null;
        expression = node instanceof ClassInstanceCreation ? ((ClassInstanceCreation)node).getExpression() : ((SuperConstructorInvocation)node).getExpression();
        AST ast = node.getAST();
        if (expression != null) {
            return expression;
        }
        if (JdtFlags.isStatic((IMember)this.fType)) {
            return null;
        }
        if (this.isInsideSubclassOfDeclaringType(node)) {
            return ast.newThisExpression();
        }
        if (node.getStartPosition() >= this.fType.getSourceRange().getOffset() && ASTNodes.getExclusiveEnd(node) <= this.fType.getSourceRange().getOffset() + this.fType.getSourceRange().getLength()) {
            if (this.fCodeGenerationSettings.useKeywordThis || this.fEnclosingInstanceFieldName.equals(this.fNameForEnclosingInstanceConstructorParameter)) {
                FieldAccess access = ast.newFieldAccess();
                access.setExpression((Expression)ast.newThisExpression());
                access.setName(ast.newSimpleName(this.fEnclosingInstanceFieldName));
                return access;
            }
            return ast.newSimpleName(this.fEnclosingInstanceFieldName);
        }
        if (this.isInsideTypeNestedInDeclaringType(node)) {
            ThisExpression qualified = ast.newThisExpression();
            qualified.setQualifier((Name)ast.newSimpleName(this.fType.getDeclaringType().getElementName()));
            return qualified;
        }
        return null;
    }

    private Type createEnclosingType(AST ast) throws JavaModelException {
        Assert.isNotNull((Object)ast);
        ITypeParameter[] parameters = this.fType.getDeclaringType().getTypeParameters();
        Type type = ASTNodeFactory.newType(ast, JavaModelUtil.getTypeQualifiedName(this.fType.getDeclaringType()));
        if (parameters.length > 0) {
            ParameterizedType parameterized = ast.newParameterizedType(type);
            int index = 0;
            while (index < parameters.length) {
                parameterized.typeArguments().add(ast.newSimpleType((Name)ast.newSimpleName(parameters[index].getElementName())));
                ++index;
            }
            return parameterized;
        }
        return type;
    }

    private String createNewSource(CompilationUnitRewrite targetRewrite, ICompilationUnit unit) throws CoreException, JavaModelException {
        Assert.isNotNull((Object)targetRewrite);
        Assert.isNotNull((Object)unit);
        CompilationUnitChange change = targetRewrite.createChange();
        if (change == null) {
            change = new CompilationUnitChange("", unit);
        }
        String source = change.getPreviewContent((IProgressMonitor)new NullProgressMonitor());
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setProject(this.fType.getJavaProject());
        parser.setResolveBindings(false);
        parser.setSource(source.toCharArray());
        AbstractTypeDeclaration declaration = MoveInnerToTopRefactoring.findTypeDeclaration(this.fType, (CompilationUnit)parser.createAST(null));
        return source.substring(declaration.getStartPosition(), ASTNodes.getExclusiveEnd((ASTNode)declaration));
    }

    private Expression createQualifiedReadAccessExpressionForEnclosingInstance(AST ast) {
        ThisExpression expression = ast.newThisExpression();
        expression.setQualifier(ast.newName(new String[]{this.fType.getElementName()}));
        FieldAccess access = ast.newFieldAccess();
        access.setExpression((Expression)expression);
        access.setName(ast.newSimpleName(this.fEnclosingInstanceFieldName));
        return access;
    }

    private Expression createReadAccessExpressionForEnclosingInstance(AST ast) {
        if (this.fCodeGenerationSettings.useKeywordThis || this.fEnclosingInstanceFieldName.equals(this.fNameForEnclosingInstanceConstructorParameter)) {
            FieldAccess access = ast.newFieldAccess();
            access.setExpression((Expression)ast.newThisExpression());
            access.setName(ast.newSimpleName(this.fEnclosingInstanceFieldName));
            return access;
        }
        return ast.newSimpleName(this.fEnclosingInstanceFieldName);
    }

    private String createSourceForNewCu(ICompilationUnit unit, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)unit);
        Assert.isNotNull((Object)monitor);
        try {
            monitor.beginTask("", 2);
            String separator = StubUtility.getLineDelimiterUsed(this.fType.getJavaProject());
            String block = this.getAlignedSourceBlock(unit, this.fNewSourceOfInputType);
            String content = CodeGeneration.getCompilationUnitContent(unit, null, block, separator);
            if (content == null || block.startsWith("/*") || block.startsWith("//")) {
                StringBuffer buffer = new StringBuffer();
                if (!this.fType.getPackageFragment().isDefaultPackage()) {
                    buffer.append("package ").append(this.fType.getPackageFragment().getElementName()).append(';');
                }
                buffer.append(separator).append(separator);
                buffer.append(block);
                content = buffer.toString();
            }
            unit.getBuffer().setContents(content);
            this.addImportsToTargetUnit(unit, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        finally {
            monitor.done();
        }
        return unit.getSource();
    }

    private Map createTypeReferencesMapping(IProgressMonitor pm, RefactoringStatus status) throws JavaModelException {
        RefactoringSearchEngine2 engine = new RefactoringSearchEngine2(SearchPattern.createPattern((IJavaElement)this.fType, (int)3, (int)24));
        engine.setFiltering(true, true);
        engine.setScope(RefactoringScopeFactory.create((IJavaElement)this.fType));
        engine.setStatus(status);
        engine.searchPattern((IProgressMonitor)new SubProgressMonitor(pm, 1));
        SearchResultGroup[] groups = (SearchResultGroup[])engine.getResults();
        HashMap<ICompilationUnit, SearchMatch[]> result = new HashMap<ICompilationUnit, SearchMatch[]>();
        int i = 0;
        while (i < groups.length) {
            SearchResultGroup group = groups[i];
            ICompilationUnit cu = group.getCompilationUnit();
            if (cu != null) {
                result.put(cu, group.getSearchResults());
            }
            ++i;
        }
        return result;
    }

    private String getAlignedSourceBlock(ICompilationUnit unit, String block) {
        Assert.isNotNull((Object)block);
        String[] lines = Strings.convertIntoLines(block);
        Strings.trimIndentation(lines, unit.getJavaProject(), false);
        return Strings.concatenate(lines, StubUtility.getLineDelimiterUsed(this.fType.getJavaProject()));
    }

    private CompilationUnitRewrite getCompilationUnitRewrite(ICompilationUnit unit) {
        Assert.isNotNull((Object)unit);
        if (unit.equals(this.fType.getCompilationUnit())) {
            return this.fSourceRewrite;
        }
        return new CompilationUnitRewrite(unit);
    }

    private MethodDeclaration[] getConstructorDeclarationNodes(AbstractTypeDeclaration declaration) {
        if (declaration instanceof TypeDeclaration) {
            MethodDeclaration[] declarations = ((TypeDeclaration)declaration).getMethods();
            ArrayList<MethodDeclaration> result = new ArrayList<MethodDeclaration>(2);
            int index = 0;
            while (index < declarations.length) {
                if (declarations[index].isConstructor()) {
                    result.add(declarations[index]);
                }
                ++index;
            }
            return result.toArray(new MethodDeclaration[result.size()]);
        }
        return new MethodDeclaration[0];
    }

    public boolean getCreateInstanceField() {
        return this.fCreateInstanceField;
    }

    private int getEnclosingInstanceAccessModifiers() {
        if (this.fMarkInstanceFieldAsFinal) {
            return 18;
        }
        return 2;
    }

    public String getEnclosingInstanceName() {
        return this.fEnclosingInstanceFieldName;
    }

    private String getInitialNameForEnclosingInstanceField() {
        IType enclosingType = this.fType.getDeclaringType();
        if (enclosingType == null) {
            return "";
        }
        String[] suggestedNames = StubUtility.getFieldNameSuggestions(this.fType.getDeclaringType(), this.getEnclosingInstanceAccessModifiers(), MoveInnerToTopRefactoring.getFieldNames(this.fType));
        if (suggestedNames.length > 0) {
            return suggestedNames[0];
        }
        String name = enclosingType.getElementName();
        if (name.equals("")) {
            return "";
        }
        return String.valueOf(Character.toLowerCase(name.charAt(0))) + name.substring(1);
    }

    public IType getInputType() {
        return this.fType;
    }

    public String getName() {
        return RefactoringCoreMessages.MoveInnerToTopRefactoring_name;
    }

    private String getNameForEnclosingInstanceConstructorParameter() throws JavaModelException {
        if (this.fNameForEnclosingInstanceConstructorParameter != null) {
            return this.fNameForEnclosingInstanceConstructorParameter;
        }
        String[] suggestedNames = StubUtility.getArgumentNameSuggestions(this.fType.getDeclaringType(), MoveInnerToTopRefactoring.getParameterNamesOfAllConstructors(this.fType));
        this.fNameForEnclosingInstanceConstructorParameter = suggestedNames.length > 0 ? suggestedNames[0] : this.fEnclosingInstanceFieldName;
        return this.fNameForEnclosingInstanceConstructorParameter;
    }

    private String[] getNewConstructorParameterNames() throws JavaModelException {
        if (!this.fCreateInstanceField) {
            return new String[0];
        }
        return new String[]{this.getNameForEnclosingInstanceConstructorParameter()};
    }

    private ASTNode getNewQualifiedNameNode(ITypeBinding[] parameters, Name name) {
        AST ast = name.getAST();
        boolean raw = false;
        ITypeBinding binding = name.resolveTypeBinding();
        if (binding != null && binding.isRawType()) {
            raw = true;
        }
        if (parameters != null && parameters.length > 0 && !raw) {
            ParameterizedType type = ast.newParameterizedType((Type)ast.newSimpleType(ast.newName(this.fQualifiedTypeName)));
            int index = 0;
            while (index < parameters.length) {
                type.typeArguments().add(ast.newSimpleType((Name)ast.newSimpleName(parameters[index].getName())));
                ++index;
            }
            return type;
        }
        return ast.newName(this.fQualifiedTypeName);
    }

    private ASTNode getNewUnqualifiedTypeNode(ITypeBinding[] parameters, Name name) {
        AST ast = name.getAST();
        boolean raw = false;
        ITypeBinding binding = name.resolveTypeBinding();
        if (binding != null && binding.isRawType()) {
            raw = true;
        }
        if (parameters != null && parameters.length > 0 && !raw) {
            ParameterizedType type = ast.newParameterizedType((Type)ast.newSimpleType((Name)ast.newSimpleName(this.fType.getElementName())));
            int index = 0;
            while (index < parameters.length) {
                type.typeArguments().add(ast.newSimpleType((Name)ast.newSimpleName(parameters[index].getName())));
                ++index;
            }
            return type;
        }
        return ast.newSimpleType((Name)ast.newSimpleName(this.fType.getElementName()));
    }

    private boolean insertExpressionAsParameter(ClassInstanceCreation cic, ASTRewrite rewrite, ICompilationUnit cu, TextEditGroup group) throws JavaModelException {
        Expression expression = this.createEnclosingInstanceCreationString((ASTNode)cic, cu);
        if (expression == null) {
            return false;
        }
        rewrite.getListRewrite((ASTNode)cic, ClassInstanceCreation.ARGUMENTS_PROPERTY).insertFirst((ASTNode)expression, group);
        return true;
    }

    private boolean insertExpressionAsParameter(SuperConstructorInvocation sci, ASTRewrite rewrite, ICompilationUnit cu, TextEditGroup group) throws JavaModelException {
        Expression expression = this.createEnclosingInstanceCreationString((ASTNode)sci, cu);
        if (expression == null) {
            return false;
        }
        rewrite.getListRewrite((ASTNode)sci, SuperConstructorInvocation.ARGUMENTS_PROPERTY).insertFirst((ASTNode)expression, group);
        return true;
    }

    public boolean isCreatingInstanceFieldMandatory() {
        return this.fIsInstanceFieldCreationMandatory;
    }

    public boolean isCreatingInstanceFieldPossible() {
        return this.fIsInstanceFieldCreationPossible;
    }

    private boolean isInAnonymousTypeInsideInputType(ASTNode node, AbstractTypeDeclaration declaration) {
        AnonymousClassDeclaration anonymous;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.AnonymousClassDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (anonymous = (AnonymousClassDeclaration)ASTNodes.getParent(node, clazz)) != null && ASTNodes.isParent((ASTNode)anonymous, (ASTNode)declaration);
    }

    private boolean isInLocalTypeInsideInputType(ASTNode node, AbstractTypeDeclaration declaration) {
        TypeDeclarationStatement statement;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jdt.core.dom.TypeDeclarationStatement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (statement = (TypeDeclarationStatement)ASTNodes.getParent(node, clazz)) != null && ASTNodes.isParent((ASTNode)statement, (ASTNode)declaration);
    }

    private boolean isInNonStaticMemberTypeInsideInputType(ASTNode node, AbstractTypeDeclaration declaration) {
        AbstractTypeDeclaration nested;
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.jdt.core.dom.AbstractTypeDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (nested = (AbstractTypeDeclaration)ASTNodes.getParent(node, clazz)) != null && !declaration.equals((Object)nested) && !Modifier.isStatic((int)nested.getFlags()) && ASTNodes.isParent((ASTNode)nested, (ASTNode)declaration);
    }

    private boolean isInsideSubclassOfDeclaringType(ASTNode node) {
        AnonymousClassDeclaration anonymous;
        boolean isAnonymous;
        Assert.isTrue((node instanceof ClassInstanceCreation || node instanceof SuperConstructorInvocation ? 1 : 0) != 0);
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.jdt.core.dom.AbstractTypeDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AbstractTypeDeclaration declaration = (AbstractTypeDeclaration)ASTNodes.getParent(node, clazz);
        Assert.isNotNull((Object)declaration);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.jdt.core.dom.AnonymousClassDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        boolean bl = isAnonymous = (anonymous = (AnonymousClassDeclaration)ASTNodes.getParent(node, clazz2)) != null && ASTNodes.isParent((ASTNode)anonymous, (ASTNode)declaration);
        if (isAnonymous) {
            return anonymous != null && this.isSubclassBindingOfEnclosingType(anonymous.resolveBinding());
        }
        return this.isSubclassBindingOfEnclosingType(declaration.resolveBinding());
    }

    private boolean isInsideTypeNestedInDeclaringType(ASTNode node) {
        Assert.isTrue((node instanceof ClassInstanceCreation || node instanceof SuperConstructorInvocation ? 1 : 0) != 0);
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.jdt.core.dom.AbstractTypeDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AbstractTypeDeclaration declaration = (AbstractTypeDeclaration)ASTNodes.getParent(node, clazz);
        Assert.isNotNull((Object)declaration);
        ITypeBinding enclosing = declaration.resolveBinding();
        while (enclosing != null) {
            if (MoveInnerToTopRefactoring.isCorrespondingTypeBinding(enclosing, this.fType.getDeclaringType())) {
                return true;
            }
            enclosing = enclosing.getDeclaringClass();
        }
        return false;
    }

    private boolean isInstanceFieldCreationMandatory() throws JavaModelException {
        MemberAccessNodeCollector collector = new MemberAccessNodeCollector(this.fType.getDeclaringType().newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor()));
        MoveInnerToTopRefactoring.findTypeDeclaration(this.fType, this.fSourceRewrite.getRoot()).accept((ASTVisitor)collector);
        return MoveInnerToTopRefactoring.containsNonStatic(collector.getFieldAccesses()) || MoveInnerToTopRefactoring.containsNonStatic(collector.getMethodInvocations()) || MoveInnerToTopRefactoring.containsNonStatic(collector.getSimpleFieldNames());
    }

    public boolean isInstanceFieldMarkedFinal() {
        return this.fMarkInstanceFieldAsFinal;
    }

    private boolean isSubclassBindingOfEnclosingType(ITypeBinding binding) {
        while (binding != null) {
            if (MoveInnerToTopRefactoring.isCorrespondingTypeBinding(binding, this.fType.getDeclaringType())) {
                return true;
            }
            binding = binding.getSuperclass();
        }
        return false;
    }

    private void modifyAccessToEnclosingInstance(CompilationUnitRewrite targetRewrite, AbstractTypeDeclaration declaration, RefactoringStatus status, IProgressMonitor monitor) throws JavaModelException {
        Assert.isNotNull((Object)targetRewrite);
        Assert.isNotNull((Object)declaration);
        Assert.isNotNull((Object)monitor);
        HashSet handledMethods = new HashSet();
        HashSet handledFields = new HashSet();
        MemberAccessNodeCollector collector = new MemberAccessNodeCollector(this.fType.getDeclaringType().newSupertypeHierarchy((IProgressMonitor)new SubProgressMonitor(monitor, 1)));
        declaration.accept((ASTVisitor)collector);
        this.modifyAccessToMethodsFromEnclosingInstance(targetRewrite, handledMethods, collector.getMethodInvocations(), declaration, status);
        this.modifyAccessToFieldsFromEnclosingInstance(targetRewrite, handledFields, collector.getFieldAccesses(), declaration, status);
        this.modifyAccessToFieldsFromEnclosingInstance(targetRewrite, handledFields, collector.getSimpleFieldNames(), declaration, status);
    }

    private void modifyAccessToFieldsFromEnclosingInstance(CompilationUnitRewrite targetRewrite, Set handledFields, FieldAccess[] fieldAccesses, AbstractTypeDeclaration declaration, RefactoringStatus status) {
        FieldAccess access = null;
        int index = 0;
        while (index < fieldAccesses.length) {
            IVariableBinding binding;
            access = fieldAccesses[index];
            Assert.isNotNull((Object)access.getExpression());
            if (access.getExpression() instanceof ThisExpression && ((ThisExpression)access.getExpression()).getQualifier() != null && (binding = access.resolveFieldBinding()) != null) {
                targetRewrite.getASTRewrite().replace((ASTNode)access.getExpression(), (ASTNode)this.createAccessExpressionToEnclosingInstanceFieldText((ASTNode)access, (IBinding)binding, declaration), null);
                targetRewrite.getImportRemover().registerRemovedNode((ASTNode)access.getExpression());
            }
            ++index;
        }
    }

    private void modifyAccessToFieldsFromEnclosingInstance(CompilationUnitRewrite targetRewrite, Set handledFields, SimpleName[] simpleNames, AbstractTypeDeclaration declaration, RefactoringStatus status) {
        IBinding binding = null;
        SimpleName simpleName = null;
        IVariableBinding variable = null;
        int index = 0;
        while (index < simpleNames.length) {
            simpleName = simpleNames[index];
            binding = simpleName.resolveBinding();
            if (binding != null && binding instanceof IVariableBinding && !(simpleName.getParent() instanceof FieldAccess)) {
                variable = (IVariableBinding)binding;
                FieldAccess access = simpleName.getAST().newFieldAccess();
                access.setExpression(this.createAccessExpressionToEnclosingInstanceFieldText((ASTNode)simpleName, (IBinding)variable, declaration));
                access.setName(simpleName.getAST().newSimpleName(simpleName.getIdentifier()));
                targetRewrite.getASTRewrite().replace((ASTNode)simpleName, (ASTNode)access, null);
                targetRewrite.getImportRemover().registerRemovedNode((ASTNode)simpleName);
            }
            ++index;
        }
    }

    private void modifyAccessToMethodsFromEnclosingInstance(CompilationUnitRewrite targetRewrite, Set handledMethods, MethodInvocation[] methodInvocations, AbstractTypeDeclaration declaration, RefactoringStatus status) {
        IMethodBinding binding = null;
        MethodInvocation invocation = null;
        int index = 0;
        while (index < methodInvocations.length) {
            invocation = methodInvocations[index];
            binding = invocation.resolveMethodBinding();
            if (binding != null) {
                Expression target = invocation.getExpression();
                if (target == null) {
                    Expression expression = this.createAccessExpressionToEnclosingInstanceFieldText((ASTNode)invocation, (IBinding)binding, declaration);
                    targetRewrite.getASTRewrite().set((ASTNode)invocation, (StructuralPropertyDescriptor)MethodInvocation.EXPRESSION_PROPERTY, (Object)expression, null);
                } else if (invocation.getExpression() instanceof ThisExpression && ((ThisExpression)invocation.getExpression()).getQualifier() != null) {
                    targetRewrite.getASTRewrite().replace((ASTNode)target, (ASTNode)this.createAccessExpressionToEnclosingInstanceFieldText((ASTNode)invocation, (IBinding)binding, declaration), null);
                    targetRewrite.getImportRemover().registerRemovedNode((ASTNode)target);
                }
            }
            ++index;
        }
    }

    private void modifyConstructors(AbstractTypeDeclaration declaration, ASTRewrite rewrite) throws CoreException {
        MethodDeclaration[] declarations = this.getConstructorDeclarationNodes(declaration);
        int index = 0;
        while (index < declarations.length) {
            Assert.isTrue((boolean)declarations[index].isConstructor());
            this.addParameterToConstructor(rewrite, declarations[index]);
            this.setEnclosingInstanceFieldInConstructor(rewrite, declarations[index]);
            ++index;
        }
    }

    private void modifyInterfaceMemberModifiers(ITypeBinding binding) {
        ASTNode node;
        Assert.isNotNull((Object)binding);
        ITypeBinding declaring = binding.getDeclaringClass();
        while (declaring != null && !declaring.isInterface()) {
            declaring = declaring.getDeclaringClass();
        }
        if (declaring != null && (node = ASTNodes.findDeclaration((IBinding)binding, (ASTNode)this.fSourceRewrite.getRoot())) instanceof AbstractTypeDeclaration) {
            ModifierRewrite.create(this.fSourceRewrite.getASTRewrite(), node).setVisibility(1, null);
        }
    }

    public void setCreateInstanceField(boolean create) {
        Assert.isTrue((boolean)this.fIsInstanceFieldCreationPossible);
        Assert.isTrue((!this.fIsInstanceFieldCreationMandatory ? 1 : 0) != 0);
        this.fCreateInstanceField = create;
    }

    private void setEnclosingInstanceFieldInConstructor(ASTRewrite rewrite, MethodDeclaration decl) throws JavaModelException {
        AST ast = decl.getAST();
        Block body = decl.getBody();
        List statements = body.statements();
        if (statements.isEmpty()) {
            Assignment assignment = ast.newAssignment();
            assignment.setLeftHandSide(this.createReadAccessExpressionForEnclosingInstance(ast));
            assignment.setRightHandSide((Expression)ast.newSimpleName(this.getNameForEnclosingInstanceConstructorParameter()));
            rewrite.getListRewrite((ASTNode)body, Block.STATEMENTS_PROPERTY).insertFirst((ASTNode)ast.newExpressionStatement((Expression)assignment), null);
        } else {
            Statement first = (Statement)statements.get(0);
            if (first instanceof ConstructorInvocation) {
                rewrite.getListRewrite((ASTNode)first, ConstructorInvocation.ARGUMENTS_PROPERTY).insertFirst((ASTNode)ast.newSimpleName(this.fEnclosingInstanceFieldName), null);
            } else {
                int index = 0;
                if (first instanceof SuperConstructorInvocation) {
                    ++index;
                }
                Assignment assignment = ast.newAssignment();
                assignment.setLeftHandSide(this.createReadAccessExpressionForEnclosingInstance(ast));
                assignment.setRightHandSide((Expression)ast.newSimpleName(this.getNameForEnclosingInstanceConstructorParameter()));
                rewrite.getListRewrite((ASTNode)body, Block.STATEMENTS_PROPERTY).insertAt((ASTNode)ast.newExpressionStatement((Expression)assignment), index, null);
            }
        }
    }

    public void setEnclosingInstanceName(String name) {
        Assert.isNotNull((Object)name);
        this.fEnclosingInstanceFieldName = name;
    }

    public void setMarkInstanceFieldAsFinal(boolean mark) {
        this.fMarkInstanceFieldAsFinal = mark;
    }

    private void updateConstructorReference(ClassInstanceCreation creation, CompilationUnitRewrite targetRewrite, ICompilationUnit unit, TextEditGroup group) throws JavaModelException {
        Expression expression;
        Assert.isNotNull((Object)creation);
        Assert.isNotNull((Object)targetRewrite);
        Assert.isNotNull((Object)unit);
        ASTRewrite rewrite = targetRewrite.getASTRewrite();
        if (this.fCreateInstanceField) {
            this.insertExpressionAsParameter(creation, rewrite, unit, group);
        }
        if ((expression = creation.getExpression()) != null) {
            rewrite.remove((ASTNode)expression, null);
            targetRewrite.getImportRemover().registerRemovedNode((ASTNode)expression);
        }
    }

    private void updateConstructorReference(ITypeBinding[] parameters, ASTNode reference, CompilationUnitRewrite targetRewrite, ICompilationUnit cu) throws CoreException {
        TextEditGroup group = targetRewrite.createGroupDescription(RefactoringCoreMessages.MoveInnerToTopRefactoring_update_constructor_reference);
        if (reference instanceof SuperConstructorInvocation) {
            this.updateConstructorReference((SuperConstructorInvocation)reference, targetRewrite, cu, group);
        } else if (reference instanceof ClassInstanceCreation) {
            this.updateConstructorReference((ClassInstanceCreation)reference, targetRewrite, cu, group);
        } else if (reference.getParent() instanceof ClassInstanceCreation) {
            this.updateConstructorReference((ClassInstanceCreation)reference.getParent(), targetRewrite, cu, group);
        } else if (reference.getParent() instanceof ParameterizedType && reference.getParent().getParent() instanceof ClassInstanceCreation) {
            this.updateConstructorReference(parameters, (ParameterizedType)reference.getParent(), targetRewrite, cu, group);
        }
    }

    private void updateConstructorReference(ITypeBinding[] parameters, ParameterizedType type, CompilationUnitRewrite targetRewrite, ICompilationUnit cu, TextEditGroup group) throws CoreException {
        ListRewrite rewrite = targetRewrite.getASTRewrite().getListRewrite((ASTNode)type, ParameterizedType.TYPE_ARGUMENTS_PROPERTY);
        TypeParameter parameter = null;
        int index = type.typeArguments().size();
        while (index < parameters.length) {
            parameter = targetRewrite.getRoot().getAST().newTypeParameter();
            parameter.setName(targetRewrite.getRoot().getAST().newSimpleName(parameters[index].getName()));
            rewrite.insertLast((ASTNode)parameter, group);
            ++index;
        }
        if (type.getParent() instanceof ClassInstanceCreation) {
            this.updateConstructorReference((ClassInstanceCreation)type.getParent(), targetRewrite, cu, group);
        }
    }

    private void updateConstructorReference(SuperConstructorInvocation invocation, CompilationUnitRewrite targetRewrite, ICompilationUnit unit, TextEditGroup group) throws CoreException {
        Expression expression;
        Assert.isNotNull((Object)invocation);
        Assert.isNotNull((Object)targetRewrite);
        Assert.isNotNull((Object)unit);
        ASTRewrite rewrite = targetRewrite.getASTRewrite();
        if (this.fCreateInstanceField) {
            this.insertExpressionAsParameter(invocation, rewrite, unit, group);
        }
        if ((expression = invocation.getExpression()) != null) {
            rewrite.remove((ASTNode)expression, null);
            targetRewrite.getImportRemover().registerRemovedNode((ASTNode)expression);
        }
    }

    private boolean updateNameReference(ITypeBinding[] parameters, Name name, CompilationUnitRewrite targetRewrite, TextEditGroup group) {
        if (ASTNodes.asString((ASTNode)name).equals(this.fType.getFullyQualifiedName('.'))) {
            targetRewrite.getASTRewrite().replace((ASTNode)name, this.getNewQualifiedNameNode(parameters, name), group);
            targetRewrite.getImportRemover().registerRemovedNode((ASTNode)name);
            return true;
        }
        targetRewrite.getASTRewrite().replace((ASTNode)name, this.getNewUnqualifiedTypeNode(parameters, name), group);
        targetRewrite.getImportRemover().registerRemovedNode((ASTNode)name);
        return true;
    }

    private boolean updateParameterizedTypeReference(ITypeBinding[] parameters, ParameterizedType type, CompilationUnitRewrite targetRewrite, TextEditGroup group) {
        if (!(type.getParent() instanceof ClassInstanceCreation)) {
            ListRewrite rewrite = targetRewrite.getASTRewrite().getListRewrite((ASTNode)type, ParameterizedType.TYPE_ARGUMENTS_PROPERTY);
            AST ast = targetRewrite.getRoot().getAST();
            SimpleType simpleType = null;
            int index = type.typeArguments().size();
            while (index < parameters.length) {
                simpleType = ast.newSimpleType((Name)ast.newSimpleName(parameters[index].getName()));
                rewrite.insertLast((ASTNode)simpleType, group);
                ++index;
            }
        }
        return true;
    }

    private boolean updateReference(ITypeBinding[] parameters, ASTNode node, CompilationUnitRewrite rewrite, TextEditGroup group) {
        if (node.getLocationInParent() == ParameterizedType.TYPE_PROPERTY) {
            this.updateParameterizedTypeReference(parameters, (ParameterizedType)node.getParent(), rewrite, group);
            return this.updateNameReference(new ITypeBinding[0], ((SimpleType)node).getName(), rewrite, group);
        }
        if (node instanceof QualifiedName) {
            return this.updateNameReference(parameters, (Name)((QualifiedName)node), rewrite, group);
        }
        if (node instanceof SimpleType) {
            return this.updateNameReference(parameters, ((SimpleType)node).getName(), rewrite, group);
        }
        return false;
    }

    private void updateReferenceInImport(ImportDeclaration enclosingImport, ASTNode node, CompilationUnitRewrite rewrite) throws CoreException {
        IBinding binding = enclosingImport.resolveBinding();
        if (binding instanceof ITypeBinding) {
            ITypeBinding type = (ITypeBinding)binding;
            ImportRewrite rewriter = rewrite.getImportRewrite();
            if (enclosingImport.isStatic()) {
                String typeName;
                String oldImport = ASTNodes.asString(node);
                StringBuffer buffer = new StringBuffer(oldImport);
                int index = buffer.indexOf(typeName = this.fType.getDeclaringType().getElementName());
                if (index >= 0) {
                    buffer.delete(index, index + typeName.length() + 1);
                    String newImport = buffer.toString();
                    if (enclosingImport.isOnDemand()) {
                        rewriter.removeStaticImport(String.valueOf(oldImport) + ".*");
                        rewriter.addStaticImport(newImport, "*", false);
                    } else {
                        rewriter.removeStaticImport(oldImport);
                        int offset = newImport.lastIndexOf(46);
                        if (offset >= 0 && offset < newImport.length() - 1) {
                            rewriter.addStaticImport(newImport.substring(0, offset), newImport.substring(offset + 1), false);
                        }
                    }
                }
            } else {
                rewriter.removeImport(type.getQualifiedName());
            }
        }
    }

    private void updateTypeReference(ITypeBinding[] parameters, ASTNode node, CompilationUnitRewrite rewrite, ICompilationUnit cu) throws CoreException {
        ImportDeclaration enclosingImport;
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.jdt.core.dom.ImportDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((enclosingImport = (ImportDeclaration)ASTNodes.getParent(node, clazz)) != null) {
            this.updateReferenceInImport(enclosingImport, node, rewrite);
        } else {
            TextEditGroup group = rewrite.createGroupDescription(RefactoringCoreMessages.MoveInnerToTopRefactoring_update_type_reference);
            this.updateReference(parameters, node, rewrite, group);
            if (!this.fType.getPackageFragment().equals(cu.getParent())) {
                String name = String.valueOf(this.fType.getPackageFragment().getElementName()) + '.' + this.fType.getElementName();
                rewrite.getImportRemover().registerAddedImport(name);
                rewrite.getImportRewrite().addImport(name);
            }
        }
    }

    public RefactoringStatus initialize(RefactoringArguments arguments) {
        String mandatory;
        if (arguments instanceof JavaRefactoringArguments) {
            String createField;
            String parameterName;
            JavaRefactoringArguments extended = (JavaRefactoringArguments)arguments;
            String handle = extended.getAttribute("input");
            if (handle != null) {
                IJavaElement element = JDTRefactoringDescriptor.handleToElement(extended.getProject(), handle, false);
                if (element == null || !element.exists() || element.getElementType() != 7) {
                    return this.createInputFatalStatus(element, "org.eclipse.jdt.ui.move.inner");
                }
                this.fType = (IType)element;
                this.fCodeGenerationSettings = JavaPreferencesSettings.getCodeGenerationSettings(this.fType.getJavaProject());
                try {
                    this.initialize();
                }
                catch (JavaModelException exception) {
                    JavaPlugin.log(exception);
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
            }
            String fieldName = extended.getAttribute(ATTRIBUTE_FIELD_NAME);
            if (fieldName != null && !"".equals(fieldName)) {
                this.fEnclosingInstanceFieldName = fieldName;
            }
            if ((parameterName = extended.getAttribute(ATTRIBUTE_PARAMETER_NAME)) != null && !"".equals(parameterName)) {
                this.fNameForEnclosingInstanceConstructorParameter = parameterName;
            }
            if ((createField = extended.getAttribute(ATTRIBUTE_FIELD)) == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_FIELD));
            }
            this.fCreateInstanceField = Boolean.valueOf(createField);
            String markFinal = extended.getAttribute(ATTRIBUTE_FINAL);
            if (markFinal == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_FINAL));
            }
            this.fMarkInstanceFieldAsFinal = Boolean.valueOf(markFinal);
            String possible = extended.getAttribute(ATTRIBUTE_POSSIBLE);
            if (possible == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_POSSIBLE));
            }
            this.fIsInstanceFieldCreationPossible = Boolean.valueOf(possible);
            mandatory = extended.getAttribute(ATTRIBUTE_MANDATORY);
            if (mandatory == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_MANDATORY));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        this.fIsInstanceFieldCreationMandatory = Boolean.valueOf(mandatory);
        return new RefactoringStatus();
    }

    private static class MemberAccessNodeCollector
    extends ASTVisitor {
        private final List fFieldAccesses = new ArrayList(0);
        private final ITypeHierarchy fHierarchy;
        private final List fMethodAccesses = new ArrayList(0);
        private final List fSimpleNames = new ArrayList(0);

        MemberAccessNodeCollector(ITypeHierarchy hierarchy) {
            Assert.isNotNull((Object)hierarchy);
            this.fHierarchy = hierarchy;
        }

        FieldAccess[] getFieldAccesses() {
            return this.fFieldAccesses.toArray(new FieldAccess[this.fFieldAccesses.size()]);
        }

        MethodInvocation[] getMethodInvocations() {
            return this.fMethodAccesses.toArray(new MethodInvocation[this.fMethodAccesses.size()]);
        }

        SimpleName[] getSimpleFieldNames() {
            return this.fSimpleNames.toArray(new SimpleName[this.fSimpleNames.size()]);
        }

        public boolean visit(FieldAccess node) {
            IType type;
            ITypeBinding declaring = MoveInnerToTopRefactoring.getDeclaringTypeBinding(node);
            if (declaring != null && (type = (IType)declaring.getJavaElement()) != null && this.fHierarchy.contains(type)) {
                this.fFieldAccesses.add(node);
            }
            return super.visit(node);
        }

        public boolean visit(MethodInvocation node) {
            IType type;
            ITypeBinding declaring = MoveInnerToTopRefactoring.getDeclaringTypeBinding(node);
            if (declaring != null && (type = (IType)declaring.getJavaElement()) != null && this.fHierarchy.contains(type)) {
                this.fMethodAccesses.add(node);
            }
            return super.visit(node);
        }

        public boolean visit(SimpleName node) {
            if (node.getParent() instanceof QualifiedName) {
                return super.visit(node);
            }
            IBinding binding = node.resolveBinding();
            if (binding instanceof IVariableBinding) {
                IType type;
                IVariableBinding variable = (IVariableBinding)binding;
                ITypeBinding declaring = variable.getDeclaringClass();
                if (variable.isField() && declaring != null && (type = (IType)declaring.getJavaElement()) != null && this.fHierarchy.contains(type)) {
                    this.fSimpleNames.add(node);
                    return false;
                }
            }
            return super.visit(node);
        }

        public boolean visit(ThisExpression node) {
            IType type;
            ITypeBinding binding;
            Name qualifier = node.getQualifier();
            if (qualifier != null && (binding = qualifier.resolveTypeBinding()) != null && (type = (IType)binding.getJavaElement()) != null && this.fHierarchy.contains(type)) {
                this.fSimpleNames.add(qualifier);
                return false;
            }
            return super.visit(node);
        }
    }

    private class TypeReferenceQualifier
    extends ASTVisitor {
        private final TextEditGroup fGroup;
        private final ITypeBinding fTypeBinding;

        public TypeReferenceQualifier(ITypeBinding type, TextEditGroup group) {
            Assert.isNotNull((Object)type);
            Assert.isNotNull((Object)type.getDeclaringClass());
            this.fTypeBinding = type;
            this.fGroup = group;
        }

        public boolean visit(ClassInstanceCreation node) {
            Assert.isNotNull((Object)node);
            if (MoveInnerToTopRefactoring.this.fCreateInstanceField) {
                AST ast = node.getAST();
                Type type = node.getType();
                ITypeBinding binding = type.resolveBinding();
                if (binding != null && binding.getDeclaringClass() != null && !Bindings.equals((IBinding)binding, (IBinding)this.fTypeBinding) && MoveInnerToTopRefactoring.this.fSourceRewrite.getRoot().findDeclaringNode((IBinding)binding) != null) {
                    if (!Modifier.isStatic((int)binding.getModifiers())) {
                        SimpleName expression = null;
                        if (((MoveInnerToTopRefactoring)MoveInnerToTopRefactoring.this).fCodeGenerationSettings.useKeywordThis || MoveInnerToTopRefactoring.this.fEnclosingInstanceFieldName.equals(MoveInnerToTopRefactoring.this.fNameForEnclosingInstanceConstructorParameter)) {
                            FieldAccess access = ast.newFieldAccess();
                            access.setExpression((Expression)ast.newThisExpression());
                            access.setName(ast.newSimpleName(MoveInnerToTopRefactoring.this.fEnclosingInstanceFieldName));
                            expression = access;
                        } else {
                            expression = ast.newSimpleName(MoveInnerToTopRefactoring.this.fEnclosingInstanceFieldName);
                        }
                        if (node.getExpression() != null) {
                            MoveInnerToTopRefactoring.this.fSourceRewrite.getImportRemover().registerRemovedNode((ASTNode)node.getExpression());
                        }
                        MoveInnerToTopRefactoring.this.fSourceRewrite.getASTRewrite().set((ASTNode)node, (StructuralPropertyDescriptor)ClassInstanceCreation.EXPRESSION_PROPERTY, (Object)expression, this.fGroup);
                    } else {
                        MoveInnerToTopRefactoring.this.addTypeQualification(type, MoveInnerToTopRefactoring.this.fSourceRewrite, this.fGroup);
                    }
                }
            }
            return true;
        }

        public boolean visit(QualifiedType node) {
            Assert.isNotNull((Object)node);
            return false;
        }

        public boolean visit(SimpleType node) {
            ITypeBinding declaring;
            ITypeBinding binding;
            Assert.isNotNull((Object)node);
            if (!(node.getParent() instanceof ClassInstanceCreation) && (binding = node.resolveBinding()) != null && (declaring = binding.getDeclaringClass()) != null && !Bindings.equals((IBinding)declaring, (IBinding)this.fTypeBinding.getDeclaringClass()) && !Bindings.equals((IBinding)binding, (IBinding)this.fTypeBinding) && MoveInnerToTopRefactoring.this.fSourceRewrite.getRoot().findDeclaringNode((IBinding)binding) != null && Modifier.isStatic((int)binding.getModifiers())) {
                MoveInnerToTopRefactoring.this.addTypeQualification((Type)node, MoveInnerToTopRefactoring.this.fSourceRewrite, this.fGroup);
            }
            return super.visit(node);
        }

        public boolean visit(ThisExpression node) {
            Assert.isNotNull((Object)node);
            Name name = node.getQualifier();
            if (name != null && name.isSimpleName()) {
                AST ast = node.getAST();
                SimpleName expression = null;
                if (((MoveInnerToTopRefactoring)MoveInnerToTopRefactoring.this).fCodeGenerationSettings.useKeywordThis || MoveInnerToTopRefactoring.this.fEnclosingInstanceFieldName.equals(MoveInnerToTopRefactoring.this.fNameForEnclosingInstanceConstructorParameter)) {
                    FieldAccess access = ast.newFieldAccess();
                    access.setExpression((Expression)ast.newThisExpression());
                    access.setName(ast.newSimpleName(MoveInnerToTopRefactoring.this.fEnclosingInstanceFieldName));
                    expression = access;
                } else {
                    expression = ast.newSimpleName(MoveInnerToTopRefactoring.this.fEnclosingInstanceFieldName);
                }
                MoveInnerToTopRefactoring.this.fSourceRewrite.getASTRewrite().replace((ASTNode)node, (ASTNode)expression, null);
            }
            return super.visit(node);
        }
    }
}

