/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.changes;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.changes.DeleteFileChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.DeleteFolderChange;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ui.ide.undo.ResourceDescription;

public class UndoDeleteResourceChange
extends Change {
    private final ResourceDescription fResourceDescription;

    public UndoDeleteResourceChange(ResourceDescription resourceDescription) {
        this.fResourceDescription = resourceDescription;
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public Object getModifiedElement() {
        return null;
    }

    public String getName() {
        return Messages.format(RefactoringCoreMessages.UndoDeleteResourceChange_change_name, this.fResourceDescription.getName());
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (!this.fResourceDescription.isValid()) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.UndoDeleteResourceChange_cannot_restore, this.fResourceDescription.getName()));
        }
        if (this.fResourceDescription.verifyExistence(true)) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.UndoDeleteResourceChange_already_exists, this.fResourceDescription.getName()));
        }
        return new RefactoringStatus();
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        IResource created = this.fResourceDescription.createResource(pm);
        created.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        if (created instanceof IFile) {
            return new DeleteFileChange((IFile)created, false);
        }
        if (created instanceof IFolder) {
            return new DeleteFolderChange((IFolder)created, false);
        }
        return null;
    }

    public String toString() {
        return "Remove " + this.fResourceDescription.getName();
    }
}

