/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ComponentState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.LenientPlatformDependencyMetadata;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.LenientPlatformResolveMetadata;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ModuleResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.NodeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.PotentialEdge;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.VirtualPlatformState;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.immutable.ImmutableAttributesSchema;
import org.gradle.internal.Describables;
import org.gradle.internal.component.external.model.DefaultModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.DefaultModuleComponentIdentifier;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.model.AbstractComponentGraphResolveState;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentArtifactResolveMetadata;
import org.gradle.internal.component.model.ComponentConfigurationIdentifier;
import org.gradle.internal.component.model.ComponentGraphResolveState;
import org.gradle.internal.component.model.ComponentIdGenerator;
import org.gradle.internal.component.model.DefaultVariantMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.GraphSelectionCandidates;
import org.gradle.internal.component.model.ImmutableModuleSources;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.ModuleSources;
import org.gradle.internal.component.model.VariantArtifactResolveState;
import org.gradle.internal.component.model.VariantGraphResolveMetadata;
import org.gradle.internal.component.model.VariantGraphResolveState;
import org.gradle.internal.component.model.VariantResolveMetadata;
import org.gradle.internal.lazy.Lazy;
import org.jspecify.annotations.Nullable;

public class LenientPlatformGraphResolveState
extends AbstractComponentGraphResolveState<LenientPlatformResolveMetadata> {
    private final ComponentIdGenerator idGenerator;
    private final NodeState platformNode;
    private final ResolveState resolveState;
    private final VirtualPlatformState virtualPlatformState;

    public static LenientPlatformGraphResolveState of(ComponentIdGenerator componentIdGenerator, ModuleComponentIdentifier moduleComponentIdentifier, ModuleVersionIdentifier moduleVersionIdentifier, VirtualPlatformState virtualPlatformState, NodeState platformNode, ResolveState resolveState) {
        LenientPlatformResolveMetadata metadata = new LenientPlatformResolveMetadata(moduleComponentIdentifier, moduleVersionIdentifier);
        return new LenientPlatformGraphResolveState(componentIdGenerator.nextComponentId(), metadata, componentIdGenerator, virtualPlatformState, platformNode, resolveState);
    }

    private LenientPlatformGraphResolveState(long instanceId, LenientPlatformResolveMetadata metadata, ComponentIdGenerator idGenerator, VirtualPlatformState virtualPlatformState, NodeState platformNode, ResolveState resolveState) {
        super(instanceId, metadata, resolveState.getAttributeDesugaring());
        this.idGenerator = idGenerator;
        this.platformNode = platformNode;
        this.resolveState = resolveState;
        this.virtualPlatformState = virtualPlatformState;
    }

    public ComponentGraphResolveState copyWithIds(ModuleComponentIdentifier componentIdentifier, ModuleVersionIdentifier moduleVersionIdentifier) {
        return new LenientPlatformGraphResolveState(this.idGenerator.nextComponentId(), ((LenientPlatformResolveMetadata)this.getMetadata()).copyWithIds(componentIdentifier, moduleVersionIdentifier), this.idGenerator, this.virtualPlatformState, this.platformNode, this.resolveState);
    }

    @Override
    public ComponentArtifactResolveMetadata getArtifactMetadata() {
        return new LenientPlatformArtifactResolveMetadata((LenientPlatformResolveMetadata)this.getMetadata());
    }

    @Override
    public List<ResolvedVariantResult> getAllSelectableVariantResults() {
        return Collections.emptyList();
    }

    @Override
    public LenientPlatformGraphSelectionCandidates getCandidatesForGraphVariantSelection() {
        return new LenientPlatformGraphSelectionCandidates(this);
    }

    private static class LenientPlatformArtifactResolveMetadata
    implements ComponentArtifactResolveMetadata {
        private final LenientPlatformResolveMetadata metadata;

        LenientPlatformArtifactResolveMetadata(LenientPlatformResolveMetadata metadata) {
            this.metadata = metadata;
        }

        @Override
        public ComponentIdentifier getId() {
            return this.metadata.getId();
        }

        @Override
        public ModuleVersionIdentifier getModuleVersionId() {
            return this.metadata.getModuleVersionId();
        }

        @Override
        public ModuleSources getSources() {
            return ImmutableModuleSources.of();
        }

        @Override
        public ImmutableAttributes getAttributes() {
            return ImmutableAttributes.EMPTY;
        }

        @Override
        public ImmutableAttributesSchema getAttributesSchema() {
            return this.metadata.getAttributesSchema();
        }
    }

    public static class LenientPlatformGraphSelectionCandidates
    implements GraphSelectionCandidates {
        private final LenientPlatformGraphResolveState component;
        private final Lazy<LenientPlatformVariantGraphResolveState> implicitVariantState;

        public LenientPlatformGraphSelectionCandidates(LenientPlatformGraphResolveState component) {
            this.component = component;
            this.implicitVariantState = Lazy.locking().of(() -> LenientPlatformGraphSelectionCandidates.createImplicitVariant(component));
        }

        @Override
        public List<? extends VariantGraphResolveState> getVariantsForAttributeMatching() {
            return Collections.emptyList();
        }

        @Override
        public VariantGraphResolveState getLegacyVariant() {
            return (VariantGraphResolveState)this.implicitVariantState.get();
        }

        private static LenientPlatformVariantGraphResolveState createImplicitVariant(LenientPlatformGraphResolveState component) {
            ImplicitVariantDependencyFactory dependencyFactory = new ImplicitVariantDependencyFactory(component.virtualPlatformState, component.resolveState, component.platformNode, ((LenientPlatformResolveMetadata)component.getMetadata()).getModuleVersionId());
            return new LenientPlatformVariantGraphResolveState(component.idGenerator.nextVariantId(), ((LenientPlatformResolveMetadata)component.getMetadata()).getId(), new LenientPlatformVariantGraphResolveMetadata("default", false, dependencyFactory));
        }

        public VariantGraphResolveState getVariantForSourceNode(NodeState from, @Nullable ComponentIdentifier platformId) {
            SourceAwareVariantDependencyFactory dependencyFactory = new SourceAwareVariantDependencyFactory(this.component.virtualPlatformState, this.component.resolveState, from, platformId);
            return new LenientPlatformVariantGraphResolveState(this.component.idGenerator.nextVariantId(), ((LenientPlatformResolveMetadata)this.component.getMetadata()).getId(), new LenientPlatformVariantGraphResolveMetadata("default", true, dependencyFactory));
        }
    }

    private static class SourceAwareVariantDependencyFactory
    implements VariantDependencyFactory {
        private final VirtualPlatformState virtualPlatformState;
        private final ResolveState resolveState;
        private final NodeState from;
        private final ComponentIdentifier platformId;

        public SourceAwareVariantDependencyFactory(VirtualPlatformState virtualPlatformState, ResolveState resolveState, NodeState from, @Nullable ComponentIdentifier platformId) {
            this.virtualPlatformState = virtualPlatformState;
            this.resolveState = resolveState;
            this.from = from;
            this.platformId = platformId;
        }

        @Override
        public List<? extends ModuleDependencyMetadata> getDependencies() {
            List<ModuleDependencyMetadata> result = null;
            List<String> candidateVersions = this.virtualPlatformState.getCandidateVersions();
            Set<ModuleResolveState> modules = this.virtualPlatformState.getParticipatingModules();
            for (ModuleResolveState module : modules) {
                ComponentState selected = module.getSelected();
                if (selected == null) continue;
                String componentVersion = selected.getId().getVersion();
                for (String target : candidateVersions) {
                    ModuleComponentIdentifier leafId = DefaultModuleComponentIdentifier.newId(module.getId(), target);
                    ModuleComponentSelector leafSelector = DefaultModuleComponentSelector.newSelector(module.getId(), target);
                    ComponentIdentifier platformId = this.virtualPlatformState.getSelectedPlatformId();
                    if (platformId == null) {
                        platformId = this.platformId;
                    }
                    if (!componentVersion.equals(target)) {
                        PotentialEdge potentialEdge = PotentialEdge.of(this.resolveState, this.from, leafId, leafSelector, platformId, this.virtualPlatformState.isForced(), false);
                        if (potentialEdge.state == null) continue;
                        result = this.registerPlatformEdge(result, modules, leafId, leafSelector, platformId, this.virtualPlatformState.isForced());
                        break;
                    }
                    result = this.registerPlatformEdge(result, modules, leafId, leafSelector, platformId, this.virtualPlatformState.isForced());
                    break;
                }
                this.virtualPlatformState.attachOrphanEdges();
            }
            return result == null ? Collections.emptyList() : result;
        }

        private List<ModuleDependencyMetadata> registerPlatformEdge(@Nullable List<ModuleDependencyMetadata> result, Set<ModuleResolveState> modules, ModuleComponentIdentifier leafId, ModuleComponentSelector leafSelector, ComponentIdentifier platformId, boolean force) {
            if (result == null) {
                result = new ArrayList<ModuleDependencyMetadata>(modules.size());
            }
            result.add(new LenientPlatformDependencyMetadata(this.resolveState, this.from, leafSelector, leafId, platformId, force, false));
            return result;
        }
    }

    private static class ImplicitVariantDependencyFactory
    implements VariantDependencyFactory {
        private final VirtualPlatformState virtualPlatformState;
        private final ResolveState resolveState;
        private final NodeState platformNode;
        private final ModuleVersionIdentifier moduleVersionIdentifier;

        public ImplicitVariantDependencyFactory(VirtualPlatformState virtualPlatformState, ResolveState resolveState, NodeState platformNode, ModuleVersionIdentifier moduleVersionIdentifier) {
            this.virtualPlatformState = virtualPlatformState;
            this.resolveState = resolveState;
            this.platformNode = platformNode;
            this.moduleVersionIdentifier = moduleVersionIdentifier;
        }

        @Override
        public List<? extends ModuleDependencyMetadata> getDependencies() {
            ImmutableList.Builder dependencies = new ImmutableList.Builder();
            Set<ModuleResolveState> participatingModules = this.virtualPlatformState.getParticipatingModules();
            for (ModuleResolveState module : participatingModules) {
                dependencies.add((Object)new LenientPlatformDependencyMetadata(this.resolveState, this.platformNode, DefaultModuleComponentSelector.newSelector(module.getId(), this.moduleVersionIdentifier.getVersion()), DefaultModuleComponentIdentifier.newId(module.getId(), this.moduleVersionIdentifier.getVersion()), this.virtualPlatformState.getSelectedPlatformId(), this.virtualPlatformState.isForced(), true));
            }
            return dependencies.build();
        }
    }

    static interface VariantDependencyFactory {
        public List<? extends ModuleDependencyMetadata> getDependencies();
    }

    private static class LenientPlatformVariantArtifactResolveState
    implements VariantArtifactResolveState {
        private final ModuleComponentIdentifier componentId;
        private final VariantGraphResolveMetadata variant;

        public LenientPlatformVariantArtifactResolveState(ModuleComponentIdentifier componentId, VariantGraphResolveMetadata variant) {
            this.componentId = componentId;
            this.variant = variant;
        }

        @Override
        public ImmutableList<ComponentArtifactMetadata> getAdhocArtifacts(List<IvyArtifactName> dependencyArtifacts) {
            ImmutableList.Builder artifacts = ImmutableList.builderWithExpectedSize((int)dependencyArtifacts.size());
            for (IvyArtifactName dependencyArtifact : dependencyArtifacts) {
                artifacts.add((Object)new DefaultModuleComponentArtifactMetadata(this.componentId, dependencyArtifact));
            }
            return artifacts.build();
        }

        @Override
        public Set<? extends VariantResolveMetadata> getArtifactVariants() {
            String name = this.variant.getName();
            return ImmutableSet.of((Object)new DefaultVariantMetadata(name, new ComponentConfigurationIdentifier((ComponentIdentifier)this.componentId, name), Describables.of((Object)this.componentId, (Object)"variant", (Object)name), this.variant.getAttributes(), (ImmutableList<? extends ComponentArtifactMetadata>)ImmutableList.of(), this.variant.getCapabilities()));
        }
    }

    private static class LenientPlatformVariantGraphResolveState
    implements VariantGraphResolveState {
        private final long instanceId;
        private final LenientPlatformVariantGraphResolveMetadata metadata;
        private final LenientPlatformVariantArtifactResolveState artifactResolveState;

        public LenientPlatformVariantGraphResolveState(long instanceId, ModuleComponentIdentifier componentId, LenientPlatformVariantGraphResolveMetadata metadata) {
            this.instanceId = instanceId;
            this.metadata = metadata;
            this.artifactResolveState = new LenientPlatformVariantArtifactResolveState(componentId, metadata);
        }

        @Override
        public long getInstanceId() {
            return this.instanceId;
        }

        @Override
        public String getName() {
            return this.metadata.getName();
        }

        @Override
        public ImmutableAttributes getAttributes() {
            return this.metadata.getAttributes();
        }

        @Override
        public ImmutableCapabilities getCapabilities() {
            return this.metadata.getCapabilities();
        }

        @Override
        public List<? extends DependencyMetadata> getDependencies() {
            return this.metadata.getDependencies();
        }

        @Override
        public List<? extends ExcludeMetadata> getExcludes() {
            return Collections.emptyList();
        }

        @Override
        public VariantGraphResolveMetadata getMetadata() {
            return this.metadata;
        }

        @Override
        public VariantArtifactResolveState prepareForArtifactResolution() {
            return this.artifactResolveState;
        }
    }

    private static class LenientPlatformVariantGraphResolveMetadata
    implements VariantGraphResolveMetadata {
        private final String name;
        private final boolean transitive;
        private final VariantDependencyFactory dependencyFactory;

        public LenientPlatformVariantGraphResolveMetadata(String name, boolean transitive, VariantDependencyFactory dependencyFactory) {
            this.name = name;
            this.transitive = transitive;
            this.dependencyFactory = dependencyFactory;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public ImmutableAttributes getAttributes() {
            return ImmutableAttributes.EMPTY;
        }

        @Override
        public ImmutableCapabilities getCapabilities() {
            return ImmutableCapabilities.EMPTY;
        }

        public List<? extends ModuleDependencyMetadata> getDependencies() {
            return this.dependencyFactory.getDependencies();
        }

        @Override
        public boolean isTransitive() {
            return this.transitive;
        }

        @Override
        public boolean isExternalVariant() {
            return false;
        }
    }
}

