/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.context;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import org.gradle.api.internal.specs.ExplainingSpec;
import org.gradle.internal.jvm.JavaInfo;
import org.gradle.internal.jvm.Jvm;
import org.gradle.launcher.daemon.context.DaemonContext;
import org.gradle.launcher.daemon.context.DaemonRequestContext;
import org.gradle.launcher.daemon.toolchain.DaemonJvmCriteria;

public class DaemonCompatibilitySpec
implements ExplainingSpec<DaemonContext> {
    private final DaemonRequestContext desiredContext;

    public DaemonCompatibilitySpec(DaemonRequestContext desiredContext) {
        this.desiredContext = desiredContext;
    }

    public boolean isSatisfiedBy(DaemonContext potentialContext) {
        return this.whyUnsatisfied(potentialContext) == null;
    }

    public String whyUnsatisfied(DaemonContext context) {
        if (!this.jvmCompatible(context)) {
            return "JVM is incompatible.\n" + this.description(context);
        }
        if (!this.daemonOptsMatch(context)) {
            return "At least one daemon option is different.\n" + this.description(context);
        }
        if (!this.priorityMatches(context)) {
            return "Process priority is different.\n" + this.description(context);
        }
        if (!this.agentStatusMatches(context)) {
            return "Agent status is different.\n" + this.description(context);
        }
        if (!this.nativeServicesModeMatches(context)) {
            return "Native services mode is different.\n" + this.description(context);
        }
        return null;
    }

    private String description(DaemonContext context) {
        return "Wanted: " + this + "\nActual: " + context + "\n";
    }

    private boolean daemonOptsMatch(DaemonContext potentialContext) {
        return potentialContext.getDaemonOpts().containsAll(this.desiredContext.getDaemonOpts()) && potentialContext.getDaemonOpts().size() == this.desiredContext.getDaemonOpts().size();
    }

    private boolean jvmCompatible(DaemonContext potentialContext) {
        DaemonJvmCriteria criteria = this.desiredContext.getJvmCriteria();
        if (criteria instanceof DaemonJvmCriteria.Spec) {
            return ((DaemonJvmCriteria.Spec)criteria).isCompatibleWith(potentialContext.getJavaVersion());
        }
        try {
            JavaInfo desiredJavaInfo;
            File potentialJavaHome = potentialContext.getJavaHome();
            if (criteria instanceof DaemonJvmCriteria.JavaHome) {
                desiredJavaInfo = Jvm.forHome((File)((DaemonJvmCriteria.JavaHome)criteria).getJavaHome());
            } else if (criteria instanceof DaemonJvmCriteria.LauncherJvm) {
                desiredJavaInfo = Jvm.current();
            } else {
                throw new IllegalStateException("Unknown DaemonJvmCriteria type: " + criteria.getClass().getName());
            }
            if (potentialJavaHome.exists() && desiredJavaInfo != null) {
                File potentialJava = Jvm.forHome((File)potentialJavaHome).getJavaExecutable();
                File desiredJava = desiredJavaInfo.getJavaExecutable();
                return Files.isSameFile(potentialJava.toPath(), desiredJava.toPath());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private boolean priorityMatches(DaemonContext context) {
        return this.desiredContext.getPriority() == context.getPriority();
    }

    private boolean agentStatusMatches(DaemonContext context) {
        return this.desiredContext.shouldApplyInstrumentationAgent() == context.shouldApplyInstrumentationAgent();
    }

    private boolean nativeServicesModeMatches(DaemonContext context) {
        return this.desiredContext.getNativeServicesMode() == context.getNativeServicesMode();
    }

    public String toString() {
        return this.desiredContext.toString();
    }
}

