/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath;

import javax.annotation.Nonnull;
import org.gradle.internal.classpath.types.InstrumentingTypeRegistry;
import org.gradle.internal.instrumentation.api.metadata.InstrumentationMetadata;
import org.gradle.internal.lazy.Lazy;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;

public class ClassData
implements InstrumentationMetadata {
    private final InstrumentingTypeRegistry typeRegistry;
    private final Lazy<ClassNode> classNode = Lazy.unsafe().of(() -> {
        ClassNode classNode = new ClassNode();
        reader.accept((ClassVisitor)classNode, 0);
        return classNode;
    });
    private final byte[] classContent;

    public ClassData(ClassReader reader, byte[] content, InstrumentingTypeRegistry typeRegistry) {
        this.classContent = content;
        this.typeRegistry = typeRegistry;
    }

    public byte[] getClassContent() {
        return this.classContent;
    }

    public ClassNode readClassAsNode() {
        return (ClassNode)this.classNode.get();
    }

    public boolean isInstanceOf(@Nonnull String type, @Nonnull String superType) {
        return this.typeRegistry.getSuperTypes(type).contains(superType);
    }
}

