/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;
import org.gradle.api.Project;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.project.ProjectHierarchyUtils;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.properties.GradleProperties;
import org.gradle.initialization.BuildLoader;
import org.gradle.internal.Cast;
import org.gradle.internal.Pair;
import org.gradle.internal.reflect.JavaPropertyReflectionUtil;
import org.gradle.internal.reflect.PropertyMutator;
import org.gradle.internal.resource.local.FileResourceListener;
import org.gradle.util.internal.GUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectPropertySettingBuildLoader
implements BuildLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProjectPropertySettingBuildLoader.class);
    private final GradleProperties gradleProperties;
    private final FileResourceListener fileResourceListener;
    private final BuildLoader buildLoader;

    public ProjectPropertySettingBuildLoader(GradleProperties gradleProperties, BuildLoader buildLoader, FileResourceListener fileResourceListener) {
        this.buildLoader = buildLoader;
        this.gradleProperties = gradleProperties;
        this.fileResourceListener = fileResourceListener;
    }

    @Override
    public void load(SettingsInternal settings, GradleInternal gradle) {
        this.buildLoader.load(settings, gradle);
        ProjectInternal rootProject = gradle.getRootProject();
        this.setProjectProperties(rootProject, new CachingPropertyApplicator(rootProject.getClass()));
    }

    private void setProjectProperties(Project project, CachingPropertyApplicator applicator) {
        this.addPropertiesToProject(project, applicator);
        for (Project childProject : ProjectHierarchyUtils.getChildProjectsForInternalUse(project)) {
            this.setProjectProperties(childProject, applicator);
        }
    }

    private void addPropertiesToProject(Project project, CachingPropertyApplicator applicator) {
        File projectPropertiesFile = new File(project.getProjectDir(), "gradle.properties");
        LOGGER.debug("Looking for project properties from: {}", (Object)projectPropertiesFile);
        this.fileResourceListener.fileObserved(projectPropertiesFile);
        if (projectPropertiesFile.isFile()) {
            Properties projectProperties = GUtil.loadProperties((File)projectPropertiesFile);
            LOGGER.debug("Adding project properties (if not overwritten by user properties): {}", projectProperties.keySet());
            this.configurePropertiesOf(project, applicator, (Map)Cast.uncheckedCast((Object)projectProperties));
        } else {
            LOGGER.debug("project property file does not exists. We continue!");
            this.configurePropertiesOf(project, applicator, Collections.emptyMap());
        }
    }

    private void configurePropertiesOf(Project project, CachingPropertyApplicator applicator, Map<String, Object> properties) {
        for (Map.Entry entry : this.gradleProperties.mergeProperties(properties).entrySet()) {
            applicator.configureProperty(project, (String)entry.getKey(), entry.getValue());
        }
    }

    private static class CachingPropertyApplicator {
        private final Class<? extends Project> projectClass;
        private final Map<Pair<String, ? extends Class<?>>, PropertyMutator> mutators = new HashMap();

        CachingPropertyApplicator(Class<? extends Project> projectClass) {
            this.projectClass = projectClass;
        }

        void configureProperty(Project project, String name, @Nullable Object value) {
            if (this.isPossibleProperty(name)) {
                assert (project.getClass() == this.projectClass);
                PropertyMutator propertyMutator = this.propertyMutatorFor(name, this.typeOf(value));
                if (propertyMutator != null) {
                    propertyMutator.setValue((Object)project, value);
                } else {
                    this.setExtraPropertyOf(project, name, value);
                }
            }
        }

        private void setExtraPropertyOf(Project project, String name, @Nullable Object value) {
            project.getExtensions().getExtraProperties().set(name, value);
        }

        @Nullable
        private Class<?> typeOf(@Nullable Object value) {
            return value == null ? null : value.getClass();
        }

        @Nullable
        private PropertyMutator propertyMutatorFor(String propertyName, @Nullable Class<?> valueType) {
            Pair key = Pair.of((Object)propertyName, valueType);
            PropertyMutator cached = this.mutators.get(key);
            if (cached != null) {
                return cached;
            }
            if (this.mutators.containsKey(key)) {
                return null;
            }
            PropertyMutator mutator = JavaPropertyReflectionUtil.writeablePropertyIfExists(this.projectClass, (String)propertyName, valueType);
            this.mutators.put(key, mutator);
            return mutator;
        }

        private boolean isPossibleProperty(String name) {
            return !name.isEmpty();
        }
    }
}

