/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks;

import java.io.File;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.internal.file.copy.CopySpecInternal;
import org.gradle.api.internal.file.copy.DestinationRootCopySpec;
import org.gradle.api.internal.file.copy.FileCopyAction;
import org.gradle.api.internal.file.copy.SyncCopyActionDecorator;
import org.gradle.api.tasks.AbstractCopyTask;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.file.Deleter;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.instrumentation.api.annotations.NotToBeReplacedByLazyProperty;
import org.gradle.internal.instrumentation.api.annotations.ToBeReplacedByLazyProperty;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Not worth caching")
public abstract class Sync
extends AbstractCopyTask {
    private final PatternFilterable preserveInDestination = new PatternSet();

    @Override
    protected CopyAction createCopyAction() {
        File destinationDir = this.getDestinationDir();
        if (destinationDir == null) {
            throw new InvalidUserDataException("No copy destination directory has been specified, use 'into' to specify a target directory.");
        }
        return new SyncCopyActionDecorator(destinationDir, (CopyAction)new FileCopyAction((PathToFileResolver)this.getFileLookup().getFileResolver(destinationDir)), this.preserveInDestination, this.getDeleter(), this.getDirectoryFileTreeFactory());
    }

    @Override
    protected CopySpecInternal createRootSpec() {
        return (CopySpecInternal)this.getProject().getObjects().newInstance(DestinationRootCopySpec.class, new Object[]{super.createRootSpec()});
    }

    @NotToBeReplacedByLazyProperty(because="Read-only nested like property")
    public DestinationRootCopySpec getRootSpec() {
        return (DestinationRootCopySpec)super.getRootSpec();
    }

    @OutputDirectory
    @ToBeReplacedByLazyProperty
    public File getDestinationDir() {
        return this.getRootSpec().getDestinationDir();
    }

    public void setDestinationDir(File destinationDir) {
        this.into(destinationDir);
    }

    @Internal
    @NotToBeReplacedByLazyProperty(because="Read-only nested like property")
    public PatternFilterable getPreserve() {
        return this.preserveInDestination;
    }

    public Sync preserve(Action<? super PatternFilterable> action) {
        action.execute((Object)this.preserveInDestination);
        return this;
    }

    @Inject
    protected Deleter getDeleter() {
        throw new UnsupportedOperationException("Decorator takes care of injection");
    }
}

