/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.properties;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.gradle.api.internal.tasks.properties.DefaultPropertyTypeResolver;
import org.gradle.api.internal.tasks.properties.InspectionScheme;
import org.gradle.api.internal.tasks.properties.ScriptSourceAwareImplementationResolver;
import org.gradle.cache.internal.CrossBuildInMemoryCacheFactory;
import org.gradle.internal.instantiation.InstantiationScheme;
import org.gradle.internal.properties.annotations.DefaultTypeMetadataStore;
import org.gradle.internal.properties.annotations.FunctionAnnotationHandler;
import org.gradle.internal.properties.annotations.MissingPropertyAnnotationHandler;
import org.gradle.internal.properties.annotations.NoOpPropertyAnnotationHandler;
import org.gradle.internal.properties.annotations.PropertyAnnotationHandler;
import org.gradle.internal.properties.annotations.PropertyTypeResolver;
import org.gradle.internal.properties.annotations.TypeAnnotationHandler;
import org.gradle.internal.properties.annotations.TypeMetadataStore;
import org.gradle.internal.properties.bean.DefaultPropertyWalker;
import org.gradle.internal.properties.bean.ImplementationResolver;
import org.gradle.internal.properties.bean.PropertyWalker;
import org.gradle.internal.reflect.annotations.TypeAnnotationMetadataStore;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value={Scope.Global.class})
public class InspectionSchemeFactory {
    private final Map<Class<? extends Annotation>, PropertyAnnotationHandler> allKnownPropertyHandlers;
    private final Map<Class<? extends Annotation>, FunctionAnnotationHandler> allKnownFunctionHandlers;
    private final ImmutableList<TypeAnnotationHandler> allKnownTypeHandlers;
    private final TypeAnnotationMetadataStore typeAnnotationMetadataStore;
    private final CrossBuildInMemoryCacheFactory cacheFactory;

    public InspectionSchemeFactory(List<? extends TypeAnnotationHandler> allKnownTypeHandlers, List<? extends PropertyAnnotationHandler> allKnownPropertyHandlers, List<? extends FunctionAnnotationHandler> allKnownFunctionHandlers, TypeAnnotationMetadataStore typeAnnotationMetadataStore, CrossBuildInMemoryCacheFactory cacheFactory) {
        ImmutableMap.Builder propertyHandlerBuilder = ImmutableMap.builder();
        for (PropertyAnnotationHandler propertyAnnotationHandler : allKnownPropertyHandlers) {
            propertyHandlerBuilder.put((Object)propertyAnnotationHandler.getAnnotationType(), (Object)propertyAnnotationHandler);
        }
        ImmutableMap.Builder functionHandlerBuilder = ImmutableMap.builder();
        for (FunctionAnnotationHandler functionAnnotationHandler : allKnownFunctionHandlers) {
            functionHandlerBuilder.put((Object)functionAnnotationHandler.getAnnotationType(), (Object)functionAnnotationHandler);
        }
        this.allKnownTypeHandlers = ImmutableList.copyOf(allKnownTypeHandlers);
        this.allKnownPropertyHandlers = propertyHandlerBuilder.build();
        this.allKnownFunctionHandlers = functionHandlerBuilder.build();
        this.typeAnnotationMetadataStore = typeAnnotationMetadataStore;
        this.cacheFactory = cacheFactory;
    }

    public InspectionScheme inspectionScheme(Collection<Class<? extends Annotation>> annotations, Collection<Class<? extends Annotation>> propertyModifiers, Collection<Class<? extends Annotation>> methodModifiers, InstantiationScheme instantiationScheme) {
        return this.inspectionScheme(annotations, propertyModifiers, methodModifiers, instantiationScheme, MissingPropertyAnnotationHandler.MISSING_INPUT_OUTPUT_HANDLER);
    }

    public InspectionScheme inspectionScheme(Collection<Class<? extends Annotation>> annotations, Collection<Class<? extends Annotation>> propertyModifiers, Collection<Class<? extends Annotation>> methodModifiers, InstantiationScheme instantiationScheme, MissingPropertyAnnotationHandler missingAnnotationProblemHandler) {
        ImmutableList.Builder propertyHandlers = ImmutableList.builderWithExpectedSize((int)annotations.size());
        ImmutableList.Builder functionHandlers = ImmutableList.builderWithExpectedSize((int)annotations.size());
        for (Class<? extends Annotation> annotation : annotations) {
            PropertyAnnotationHandler propertyHandler = this.allKnownPropertyHandlers.get(annotation);
            FunctionAnnotationHandler methodHandler = this.allKnownFunctionHandlers.get(annotation);
            if (propertyHandler == null && methodHandler == null) {
                throw new IllegalArgumentException(String.format("@%s is not a registered property or method type annotation.", annotation.getSimpleName()));
            }
            if (propertyHandler != null) {
                propertyHandlers.add((Object)propertyHandler);
            }
            if (methodHandler == null) continue;
            functionHandlers.add((Object)methodHandler);
        }
        for (Class<? extends Annotation> annotation : instantiationScheme.getInjectionAnnotations()) {
            if (annotations.contains(annotation)) continue;
            propertyHandlers.add((Object)new NoOpPropertyAnnotationHandler(annotation));
        }
        return new InspectionSchemeImpl((List<TypeAnnotationHandler>)this.allKnownTypeHandlers, (List<PropertyAnnotationHandler>)propertyHandlers.build(), propertyModifiers, (List<FunctionAnnotationHandler>)functionHandlers.build(), methodModifiers, this.typeAnnotationMetadataStore, this.cacheFactory, missingAnnotationProblemHandler);
    }

    private static class InspectionSchemeImpl
    implements InspectionScheme {
        private final DefaultPropertyWalker propertyWalker;
        private final DefaultTypeMetadataStore metadataStore;

        public InspectionSchemeImpl(List<TypeAnnotationHandler> typeHandlers, List<PropertyAnnotationHandler> propertyHandlers, Collection<Class<? extends Annotation>> propertyModifiers, List<FunctionAnnotationHandler> methodHandlers, Collection<Class<? extends Annotation>> methodModifiers, TypeAnnotationMetadataStore typeAnnotationMetadataStore, CrossBuildInMemoryCacheFactory cacheFactory, MissingPropertyAnnotationHandler missingAnnotationProblemHandler) {
            DefaultPropertyTypeResolver propertyTypeResolver = new DefaultPropertyTypeResolver();
            this.metadataStore = new DefaultTypeMetadataStore(typeHandlers, propertyHandlers, propertyModifiers, methodHandlers, methodModifiers, typeAnnotationMetadataStore, (PropertyTypeResolver)propertyTypeResolver, cacheFactory, missingAnnotationProblemHandler);
            this.propertyWalker = new DefaultPropertyWalker((TypeMetadataStore)this.metadataStore, (ImplementationResolver)new ScriptSourceAwareImplementationResolver(), propertyHandlers);
        }

        @Override
        public TypeMetadataStore getMetadataStore() {
            return this.metadataStore;
        }

        @Override
        public PropertyWalker getPropertyWalker() {
            return this.propertyWalker;
        }
    }
}

