/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.artifacts.ConfigurablePublishArtifact;
import org.gradle.api.artifacts.ConfigurationPublications;
import org.gradle.api.artifacts.ConfigurationVariant;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.PublishArtifactSet;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.ConfigurationVariantInternal;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.configurations.DefaultVariant;
import org.gradle.api.internal.artifacts.configurations.PublishArtifactSetProvider;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributesFactory;
import org.gradle.api.internal.collections.DomainObjectCollectionFactory;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.provider.Provider;
import org.gradle.internal.DisplayName;
import org.gradle.internal.FinalizableValue;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationParser;

public class DefaultConfigurationPublications
implements ConfigurationPublications,
FinalizableValue {
    private final DisplayName displayName;
    private final PublishArtifactSet artifacts;
    private final PublishArtifactSetProvider allArtifacts;
    private final AttributeContainerInternal parentAttributes;
    private final AttributeContainerInternal attributes;
    private final Instantiator instantiator;
    private final NotationParser<Object, ConfigurablePublishArtifact> artifactNotationParser;
    private final NotationParser<Object, Capability> capabilityNotationParser;
    private final FileCollectionFactory fileCollectionFactory;
    private final AttributesFactory attributesFactory;
    private final DomainObjectCollectionFactory domainObjectCollectionFactory;
    private final TaskDependencyFactory taskDependencyFactory;
    private NamedDomainObjectContainer<ConfigurationVariant> variants;
    private ConfigurationVariantFactory variantFactory;
    private DomainObjectSet<Capability> capabilities;
    private boolean canCreate = true;

    public DefaultConfigurationPublications(DisplayName displayName, PublishArtifactSet artifacts, PublishArtifactSetProvider allArtifacts, AttributeContainerInternal parentAttributes, Instantiator instantiator, NotationParser<Object, ConfigurablePublishArtifact> artifactNotationParser, NotationParser<Object, Capability> capabilityNotationParser, FileCollectionFactory fileCollectionFactory, AttributesFactory attributesFactory, DomainObjectCollectionFactory domainObjectCollectionFactory, TaskDependencyFactory taskDependencyFactory) {
        this.displayName = displayName;
        this.artifacts = artifacts;
        this.allArtifacts = allArtifacts;
        this.parentAttributes = parentAttributes;
        this.instantiator = instantiator;
        this.artifactNotationParser = artifactNotationParser;
        this.capabilityNotationParser = capabilityNotationParser;
        this.fileCollectionFactory = fileCollectionFactory;
        this.attributesFactory = attributesFactory;
        this.domainObjectCollectionFactory = domainObjectCollectionFactory;
        this.taskDependencyFactory = taskDependencyFactory;
        this.attributes = attributesFactory.mutable(parentAttributes);
    }

    public void collectVariants(ConfigurationInternal.VariantVisitor visitor) {
        PublishArtifactSet allArtifactSet = this.allArtifacts.getPublishArtifactSet();
        if (this.variants == null || this.variants.isEmpty() || !allArtifactSet.isEmpty()) {
            visitor.visitOwnVariant(this.displayName, this.attributes.asImmutable(), (Collection<? extends PublishArtifact>)allArtifactSet);
        }
        if (this.variants != null) {
            for (ConfigurationVariantInternal variant : this.variants.withType(ConfigurationVariantInternal.class)) {
                visitor.visitChildVariant(variant.getName(), variant.getDisplayName(), variant.getAttributes().asImmutable(), (Collection<? extends PublishArtifact>)variant.getArtifacts());
            }
        }
    }

    public AttributeContainer getAttributes() {
        return this.attributes;
    }

    public ConfigurationPublications attributes(Action<? super AttributeContainer> action) {
        action.execute((Object)this.attributes);
        return this;
    }

    public PublishArtifactSet getArtifacts() {
        return this.artifacts;
    }

    public void artifact(Object notation) {
        this.artifacts.add((Object)((PublishArtifact)this.artifactNotationParser.parseNotation(notation)));
    }

    public void artifact(Object notation, Action<? super ConfigurablePublishArtifact> configureAction) {
        ConfigurablePublishArtifact publishArtifact = (ConfigurablePublishArtifact)this.artifactNotationParser.parseNotation(notation);
        this.artifacts.add((Object)publishArtifact);
        configureAction.execute((Object)publishArtifact);
    }

    public void artifacts(Provider<? extends Iterable<? extends Object>> provider) {
        this.artifacts.addAllLater(provider.map(iterable -> {
            ArrayList results = new ArrayList();
            iterable.forEach(notation -> results.add((PublishArtifact)this.artifactNotationParser.parseNotation(notation)));
            return results;
        }));
    }

    public void artifacts(Provider<? extends Iterable<? extends Object>> provider, Action<? super ConfigurablePublishArtifact> configureAction) {
        this.artifacts.addAllLater(provider.map(iterable -> {
            ArrayList results = new ArrayList();
            iterable.forEach(notation -> {
                ConfigurablePublishArtifact artifact = (ConfigurablePublishArtifact)this.artifactNotationParser.parseNotation(notation);
                configureAction.execute((Object)artifact);
                results.add(artifact);
            });
            return results;
        }));
    }

    public NamedDomainObjectContainer<ConfigurationVariant> getVariants() {
        if (this.variants == null) {
            this.variantFactory = new ConfigurationVariantFactory();
            this.variants = this.domainObjectCollectionFactory.newNamedDomainObjectContainer(ConfigurationVariant.class, (NamedDomainObjectFactory)this.variantFactory);
        }
        return this.variants;
    }

    public void variants(Action<? super NamedDomainObjectContainer<ConfigurationVariant>> configureAction) {
        configureAction.execute(this.getVariants());
    }

    public void capability(Object notation) {
        if (this.canCreate) {
            if (this.capabilities == null) {
                this.capabilities = this.domainObjectCollectionFactory.newDomainObjectSet(Capability.class);
            }
            if (notation instanceof Provider) {
                this.capabilities.addLater(((Provider)notation).map(arg_0 -> this.capabilityNotationParser.parseNotation(arg_0)));
            } else {
                Capability descriptor = (Capability)this.capabilityNotationParser.parseNotation(notation);
                this.capabilities.add((Object)descriptor);
            }
        } else {
            throw new InvalidUserCodeException("Cannot declare capability '" + notation + "' after dependency " + this.displayName + " has been resolved");
        }
    }

    public Collection<? extends Capability> getCapabilities() {
        return this.capabilities == null ? Collections.emptyList() : ImmutableList.copyOf(this.capabilities);
    }

    public void preventFromFurtherMutation() {
        this.canCreate = false;
        if (this.variants != null) {
            for (ConfigurationVariant variant : this.variants) {
                ((ConfigurationVariantInternal)variant).preventFurtherMutation();
            }
        }
    }

    private class ConfigurationVariantFactory
    implements NamedDomainObjectFactory<ConfigurationVariant> {
        private ConfigurationVariantFactory() {
        }

        public ConfigurationVariant create(String name) {
            if (DefaultConfigurationPublications.this.canCreate) {
                return (ConfigurationVariant)DefaultConfigurationPublications.this.instantiator.newInstance(DefaultVariant.class, new Object[]{DefaultConfigurationPublications.this.displayName, name, DefaultConfigurationPublications.this.parentAttributes, DefaultConfigurationPublications.this.artifactNotationParser, DefaultConfigurationPublications.this.fileCollectionFactory, DefaultConfigurationPublications.this.attributesFactory, DefaultConfigurationPublications.this.domainObjectCollectionFactory, DefaultConfigurationPublications.this.taskDependencyFactory});
            }
            throw new InvalidUserCodeException("Cannot create variant '" + name + "' after dependency " + DefaultConfigurationPublications.this.displayName + " has been resolved");
        }
    }
}

