/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.problems.internal.rendering;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.gradle.api.NonNullApi;
import org.gradle.api.problems.ProblemId;
import org.gradle.api.problems.internal.GradleCoreProblemGroup;
import org.gradle.api.problems.internal.Problem;

@NonNullApi
public class ProblemRenderer {
    private final PrintWriter output;

    public ProblemRenderer(Writer writer) {
        this.output = new PrintWriter(writer);
    }

    public void render(List<Problem> problems) {
        HashMap<ProblemId, List> renderingGroups = new HashMap<ProblemId, List>();
        for (Problem problem : problems) {
            List groupedProblems2 = renderingGroups.computeIfAbsent(problem.getDefinition().getId(), id -> new ArrayList());
            groupedProblems2.add(problem);
        }
        renderingGroups.forEach((id, groupedProblems) -> ProblemRenderer.renderProblemGroup(this.output, id, groupedProblems));
    }

    public void render(Problem problem) {
        this.render(Collections.singletonList(problem));
    }

    static void renderProblemGroup(PrintWriter output, ProblemId id, List<Problem> groupedProblems) {
        groupedProblems.forEach(problem -> ProblemRenderer.renderProblem(output, problem));
    }

    static void renderProblem(PrintWriter output, Problem problem) {
        boolean isJavaCompilationProblem = problem.getDefinition().getId().getGroup().equals(GradleCoreProblemGroup.compilation().java());
        if (isJavaCompilationProblem) {
            ProblemRenderer.formatMultiline(output, problem.getDetails(), 0);
        } else {
            if (problem.getContextualLabel() != null) {
                ProblemRenderer.formatMultiline(output, problem.getContextualLabel(), 1);
            } else {
                ProblemRenderer.formatMultiline(output, problem.getDefinition().getId().getDisplayName(), 1);
            }
            if (problem.getDetails() != null) {
                ProblemRenderer.formatMultiline(output, problem.getDetails(), 2);
            }
        }
    }

    static void formatMultiline(PrintWriter output, String message, int level) {
        for (String line : message.split("\n")) {
            for (int i = 0; i < level; ++i) {
                output.print("  ");
            }
            output.printf("%s%n", line);
        }
    }
}

