/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.attributes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.Usage;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeMergingException;
import org.gradle.api.internal.attributes.AttributeValue;
import org.gradle.api.internal.attributes.DefaultImmutableAttributes;
import org.gradle.api.internal.attributes.DefaultMutableAttributeContainer;
import org.gradle.api.internal.attributes.HierarchicalAttributeContainer;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.attributes.UsageCompatibilityHandler;
import org.gradle.api.internal.model.NamedObjectInstantiator;
import org.gradle.internal.Cast;
import org.gradle.internal.isolation.Isolatable;
import org.gradle.internal.isolation.IsolatableFactory;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.internal.snapshot.impl.CoercingStringValueSnapshot;

@ServiceScope(value={Scope.BuildSession.class})
public class DefaultImmutableAttributesFactory
implements ImmutableAttributesFactory {
    private final ImmutableAttributes root;
    private final Map<ImmutableAttributes, List<DefaultImmutableAttributes>> children;
    private final IsolatableFactory isolatableFactory;
    private final UsageCompatibilityHandler usageCompatibilityHandler;
    private final NamedObjectInstantiator instantiator;

    public DefaultImmutableAttributesFactory(IsolatableFactory isolatableFactory, NamedObjectInstantiator instantiator) {
        this.isolatableFactory = isolatableFactory;
        this.instantiator = instantiator;
        this.root = ImmutableAttributes.EMPTY;
        this.children = new ConcurrentHashMap<ImmutableAttributes, List<DefaultImmutableAttributes>>();
        this.usageCompatibilityHandler = new UsageCompatibilityHandler(isolatableFactory, instantiator);
    }

    public int size() {
        return this.children.size();
    }

    @Override
    public DefaultMutableAttributeContainer mutable() {
        return new DefaultMutableAttributeContainer(this);
    }

    @Override
    public HierarchicalAttributeContainer mutable(AttributeContainerInternal fallback) {
        return this.join(fallback, new DefaultMutableAttributeContainer(this));
    }

    @Override
    public HierarchicalAttributeContainer join(AttributeContainerInternal fallback, AttributeContainerInternal primary) {
        return new HierarchicalAttributeContainer(this, fallback, primary);
    }

    @Override
    public <T> ImmutableAttributes of(Attribute<T> key, T value) {
        return this.concat(this.root, key, value);
    }

    @Override
    public <T> ImmutableAttributes concat(ImmutableAttributes node, Attribute<T> key, @Nullable T value) {
        return this.concat(node, key, this.isolate(value));
    }

    private <T> Isolatable<T> isolate(@Nullable T value) {
        if (value instanceof String) {
            return (Isolatable)Cast.uncheckedNonnullCast((Object)new CoercingStringValueSnapshot((String)value, this.instantiator));
        }
        return this.isolatableFactory.isolate(value);
    }

    @Override
    public <T> ImmutableAttributes concat(ImmutableAttributes node, Attribute<T> key, Isolatable<T> value) {
        if (key.equals((Object)Usage.USAGE_ATTRIBUTE) || key.getName().equals(Usage.USAGE_ATTRIBUTE.getName())) {
            return this.usageCompatibilityHandler.doConcat(this, node, key, value);
        }
        return this.doConcatIsolatable(node, key, value);
    }

    ImmutableAttributes doConcatIsolatable(ImmutableAttributes node, Attribute<?> key, Isolatable<?> value) {
        AtomicReference result = new AtomicReference();
        this.children.compute(node, (k, nodeChildren) -> {
            if (nodeChildren != null) {
                for (DefaultImmutableAttributes child : nodeChildren) {
                    if (!child.attribute.equals((Object)key) || !child.value.equals((Object)value)) continue;
                    result.set(child);
                    return nodeChildren;
                }
            } else {
                nodeChildren = new ArrayList<DefaultImmutableAttributes>();
            }
            DefaultImmutableAttributes child = new DefaultImmutableAttributes((DefaultImmutableAttributes)node, key, value);
            nodeChildren.add(child);
            result.set(child);
            return nodeChildren;
        });
        return (ImmutableAttributes)result.get();
    }

    public ImmutableAttributes getRoot() {
        return this.root;
    }

    @Override
    public ImmutableAttributes concat(ImmutableAttributes fallback, ImmutableAttributes primary) {
        if (fallback == ImmutableAttributes.EMPTY) {
            return primary;
        }
        if (primary == ImmutableAttributes.EMPTY) {
            return fallback;
        }
        ImmutableAttributes current = primary;
        for (Attribute attribute : fallback.keySet()) {
            if (current.findEntry(attribute.getName()).isPresent()) continue;
            if (fallback instanceof DefaultImmutableAttributes) {
                current = this.doConcatIsolatable(current, attribute, ((DefaultImmutableAttributes)fallback).getIsolatableAttribute(attribute));
                continue;
            }
            current = this.concat(current, (Attribute)Cast.uncheckedNonnullCast((Object)attribute), fallback.getAttribute(attribute));
        }
        return current;
    }

    @Override
    public ImmutableAttributes safeConcat(ImmutableAttributes attributes1, ImmutableAttributes attributes2) throws AttributeMergingException {
        if (attributes1 == ImmutableAttributes.EMPTY) {
            return attributes2;
        }
        if (attributes2 == ImmutableAttributes.EMPTY) {
            return attributes1;
        }
        ImmutableAttributes current = attributes2;
        for (Attribute attribute : attributes1.keySet()) {
            Object existingAttribute;
            Object currentAttribute;
            AttributeValue<?> entry = current.findEntry(attribute.getName());
            if (entry.isPresent() && !(currentAttribute = entry.get()).equals(existingAttribute = attributes1.getAttribute(attribute))) {
                throw new AttributeMergingException(attribute, existingAttribute, currentAttribute);
            }
            if (attributes1 instanceof DefaultImmutableAttributes) {
                current = this.doConcatIsolatable(current, attribute, ((DefaultImmutableAttributes)attributes1).getIsolatableAttribute(attribute));
                continue;
            }
            current = this.concat(current, (Attribute)Cast.uncheckedNonnullCast((Object)attribute), attributes1.getAttribute(attribute));
        }
        return current;
    }
}

