/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.util.ArrayList;
import java.util.List;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.BrokenResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariant;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariantSet;
import org.gradle.api.internal.artifacts.transform.ArtifactVariantSelector;
import org.gradle.api.internal.artifacts.transform.ConsumerProvidedVariantFinder;
import org.gradle.api.internal.artifacts.transform.TransformUpstreamDependenciesResolver;
import org.gradle.api.internal.artifacts.transform.TransformedVariant;
import org.gradle.api.internal.artifacts.transform.TransformedVariantFactory;
import org.gradle.api.internal.attributes.AttributeSchemaServices;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.attributes.immutable.ImmutableAttributesSchema;
import org.gradle.api.internal.attributes.matching.AttributeMatcher;
import org.gradle.internal.component.model.AttributeMatchingExplanationBuilder;
import org.gradle.internal.component.resolution.failure.ResolutionFailureHandler;

public class AttributeMatchingArtifactVariantSelector
implements ArtifactVariantSelector {
    private final ImmutableAttributesSchema consumerSchema;
    private final TransformUpstreamDependenciesResolver dependenciesResolver;
    private final ConsumerProvidedVariantFinder consumerProvidedVariantFinder;
    private final ImmutableAttributesFactory attributesFactory;
    private final AttributeSchemaServices attributeSchemaServices;
    private final TransformedVariantFactory transformedVariantFactory;
    private final ResolutionFailureHandler failureProcessor;

    AttributeMatchingArtifactVariantSelector(ImmutableAttributesSchema consumerSchema, TransformUpstreamDependenciesResolver dependenciesResolver, ConsumerProvidedVariantFinder consumerProvidedVariantFinder, ImmutableAttributesFactory attributesFactory, AttributeSchemaServices attributeSchemaServices, TransformedVariantFactory transformedVariantFactory, ResolutionFailureHandler failureProcessor) {
        this.consumerSchema = consumerSchema;
        this.dependenciesResolver = dependenciesResolver;
        this.consumerProvidedVariantFinder = consumerProvidedVariantFinder;
        this.attributesFactory = attributesFactory;
        this.attributeSchemaServices = attributeSchemaServices;
        this.transformedVariantFactory = transformedVariantFactory;
        this.failureProcessor = failureProcessor;
    }

    @Override
    public ResolvedArtifactSet select(ResolvedVariantSet producer, ImmutableAttributes requestAttributes, boolean allowNoMatchingVariants, ArtifactVariantSelector.ResolvedArtifactTransformer resolvedArtifactTransformer) {
        try {
            return this.doSelect(producer, allowNoMatchingVariants, resolvedArtifactTransformer, AttributeMatchingExplanationBuilder.logging(), requestAttributes);
        }
        catch (Exception t) {
            return new BrokenResolvedArtifactSet((Throwable)((Object)this.failureProcessor.unknownArtifactVariantSelectionFailure(producer, requestAttributes, t)));
        }
    }

    private ResolvedArtifactSet doSelect(ResolvedVariantSet producer, boolean allowNoMatchingVariants, ArtifactVariantSelector.ResolvedArtifactTransformer resolvedArtifactTransformer, AttributeMatchingExplanationBuilder explanationBuilder, ImmutableAttributes requestAttributes) {
        AttributeMatcher matcher = this.attributeSchemaServices.getMatcher(this.consumerSchema, producer.getSchema());
        ImmutableAttributes componentRequested = this.attributesFactory.concat(requestAttributes, producer.getOverriddenAttributes());
        List<ResolvedVariant> variants = producer.getVariants();
        List<ResolvedVariant> matches = matcher.matchMultipleCandidates(variants, componentRequested, explanationBuilder);
        if (matches.size() == 1) {
            return matches.get(0).getArtifacts();
        }
        if (matches.size() > 1) {
            throw this.failureProcessor.ambiguousArtifactsFailure(matcher, producer, componentRequested, matches);
        }
        List<TransformedVariant> transformedVariants = this.consumerProvidedVariantFinder.findTransformedVariants(variants, componentRequested);
        if (transformedVariants.size() > 1) {
            transformedVariants = AttributeMatchingArtifactVariantSelector.tryDisambiguate(matcher, transformedVariants, componentRequested, explanationBuilder);
        }
        if (transformedVariants.size() == 1) {
            TransformedVariant result = transformedVariants.get(0);
            return resolvedArtifactTransformer.asTransformed(result.getRoot(), result.getTransformedVariantDefinition(), this.dependenciesResolver, this.transformedVariantFactory);
        }
        if (!transformedVariants.isEmpty()) {
            throw this.failureProcessor.ambiguousArtifactTransformsFailure(producer, componentRequested, transformedVariants);
        }
        if (allowNoMatchingVariants) {
            return ResolvedArtifactSet.EMPTY;
        }
        throw this.failureProcessor.noCompatibleArtifactFailure(matcher, producer, componentRequested, variants);
    }

    private static List<TransformedVariant> tryDisambiguate(AttributeMatcher matcher, List<TransformedVariant> candidates, ImmutableAttributes componentRequested, AttributeMatchingExplanationBuilder explanationBuilder) {
        List<TransformedVariant> matches = matcher.matchMultipleCandidates(candidates, componentRequested, explanationBuilder);
        if (matches.size() == 1) {
            return matches;
        }
        assert (!matches.isEmpty());
        ArrayList<TransformedVariant> differentTransforms = new ArrayList<TransformedVariant>(1);
        TransformedVariant last = matches.get(matches.size() - 1);
        differentTransforms.add(last);
        for (int i = 0; i < matches.size() - 1; ++i) {
            TransformedVariant current = matches.get(i);
            if (matcher.areMutuallyCompatible(current.getAttributes(), last.getAttributes())) continue;
            differentTransforms.add(current);
        }
        return differentTransforms;
    }
}

