/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.component.external.model.DefaultModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.external.model.VariantMetadataRules;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.DefaultVariantMetadata;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.ModuleConfigurationMetadata;
import org.gradle.internal.component.model.VariantResolveMetadata;

class LazyRuleAwareWithBaseConfigurationMetadata
implements ModuleConfigurationMetadata {
    private final String name;
    private final ModuleConfigurationMetadata base;
    private final ModuleComponentIdentifier componentId;
    private final VariantMetadataRules variantMetadataRules;
    private final ImmutableAttributesFactory attributesFactory;
    private final ImmutableAttributes componentLevelAttributes;
    private final ImmutableList<ExcludeMetadata> excludes;
    private final boolean externalVariant;
    private List<? extends ModuleDependencyMetadata> computedDependencies;
    private ImmutableAttributes computedAttributes;
    private ImmutableCapabilities computedCapabilities;
    private ImmutableList<? extends ComponentArtifactMetadata> computedArtifacts;

    LazyRuleAwareWithBaseConfigurationMetadata(String name, @Nullable ModuleConfigurationMetadata base, ModuleComponentIdentifier componentId, ImmutableAttributesFactory attributesFactory, ImmutableAttributes componentLevelAttributes, VariantMetadataRules variantMetadataRules, ImmutableList<ExcludeMetadata> excludes, boolean externalVariant) {
        this.name = name;
        this.base = base;
        this.componentId = componentId;
        this.variantMetadataRules = variantMetadataRules;
        this.attributesFactory = attributesFactory;
        this.componentLevelAttributes = componentLevelAttributes;
        this.excludes = excludes;
        this.externalVariant = externalVariant;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public VariantResolveMetadata.Identifier getIdentifier() {
        return null;
    }

    @Override
    public List<? extends ModuleDependencyMetadata> getDependencies() {
        if (this.computedDependencies == null) {
            this.computedDependencies = this.variantMetadataRules.applyDependencyMetadataRules(this, this.base == null ? ImmutableList.of() : this.base.getDependencies());
        }
        return this.computedDependencies;
    }

    @Override
    public ImmutableAttributes getAttributes() {
        if (this.computedAttributes == null) {
            this.computedAttributes = this.variantMetadataRules.applyVariantAttributeRules(this, (AttributeContainerInternal)(this.base != null ? this.attributesFactory.concat(this.base.getAttributes(), this.componentLevelAttributes) : this.componentLevelAttributes));
        }
        return this.computedAttributes;
    }

    @Override
    public ImmutableList<? extends ComponentArtifactMetadata> getArtifacts() {
        if (this.computedArtifacts == null) {
            this.computedArtifacts = this.variantMetadataRules.applyVariantFilesMetadataRulesToArtifacts(this, this.base == null ? ImmutableList.of() : this.base.getArtifacts(), this.componentId);
        }
        return this.computedArtifacts;
    }

    @Override
    public ImmutableCapabilities getCapabilities() {
        if (this.computedCapabilities == null) {
            this.computedCapabilities = this.variantMetadataRules.applyCapabilitiesRules(this, this.base == null ? ImmutableCapabilities.EMPTY : this.base.getCapabilities());
        }
        return this.computedCapabilities;
    }

    @Override
    public Set<? extends VariantResolveMetadata> getArtifactVariants() {
        return ImmutableSet.of((Object)new DefaultVariantMetadata(this.name, null, this.asDescribable(), this.getAttributes(), this.getArtifacts(), this.getCapabilities()));
    }

    @Override
    public DisplayName asDescribable() {
        return Describables.of((Object)this.componentId, (Object)"configuration", (Object)this.name);
    }

    @Override
    public ComponentArtifactMetadata artifact(IvyArtifactName artifact) {
        return new DefaultModuleComponentArtifactMetadata(this.componentId, artifact);
    }

    @Override
    public ImmutableSet<String> getHierarchy() {
        return ImmutableSet.of((Object)this.name);
    }

    @Override
    public ImmutableList<ExcludeMetadata> getExcludes() {
        return this.excludes;
    }

    @Override
    public boolean isTransitive() {
        return true;
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public boolean isExternalVariant() {
        return this.externalVariant;
    }
}

