// Code generated by re2c, DO NOT EDIT.
//go:generate re2go $INPUT -o $OUTPUT --loop-switch -i
package main

import (
	"errors"
	"testing"
)

var (
	eSyntax   = errors.New("syntax error")
	eOverflow = errors.New("overflow error")
)

const u32Limit uint64 = 1<<32

func parse_u32(str string) (uint32, error) {
	var cursor, marker int
	result := uint64(0)

	add_digit := func(base uint64, offset byte) {
		result = result * base + uint64(str[cursor-1] - offset)
		if result >= u32Limit {
			result = u32Limit
		}
	}

	
{
	var yych byte
	yystate := 0
yyl:
	for {
		switch (yystate) {
		case 0:
			yych = str[cursor]
			cursor += 1
			switch (yych) {
			case '0':
				yystate = 2
				continue yyl
			case '1','2','3','4','5','6','7','8','9':
				yystate = 4
				continue yyl
			default:
				yystate = 1
				continue yyl
			}
		case 1:
			{ goto err }
		case 2:
			marker = cursor
			yych = str[cursor]
			switch (yych) {
			case 'B':
				fallthrough
			case 'b':
				cursor += 1
				yystate = 5
				continue yyl
			case 'X':
				fallthrough
			case 'x':
				cursor += 1
				yystate = 7
				continue yyl
			default:
				yystate = 3
				continue yyl
			}
		case 3:
			{ goto oct }
		case 4:
			cursor += -1
			{ goto dec }
		case 5:
			yych = str[cursor]
			switch (yych) {
			case '0','1':
				cursor += 1
				yystate = 8
				continue yyl
			default:
				yystate = 6
				continue yyl
			}
		case 6:
			cursor = marker
			yystate = 3
			continue yyl
		case 7:
			yych = str[cursor]
			switch (yych) {
			case '0','1','2','3','4','5','6','7','8','9':
				fallthrough
			case 'A','B','C','D','E','F':
				fallthrough
			case 'a','b','c','d','e','f':
				cursor += 1
				yystate = 9
				continue yyl
			default:
				yystate = 6
				continue yyl
			}
		case 8:
			cursor += -1
			{ goto bin }
		case 9:
			cursor += -1
			{ goto hex }
		default:
			panic("internal lexer error")
		}
	}
}

bin:
	
{
	var yych byte
	yystate := 0
yybin:
	for {
		switch (yystate) {
		case 0:
			yych = str[cursor]
			cursor += 1
			switch (yych) {
			case 0x00:
				yystate = 1
				continue yybin
			case '0','1':
				yystate = 3
				continue yybin
			default:
				yystate = 2
				continue yybin
			}
		case 1:
			{ goto end }
		case 2:
			{ goto err }
		case 3:
			{ add_digit(2, '0'); goto bin }
		default:
			panic("internal lexer error")
		}
	}
}

oct:
	
{
	var yych byte
	yystate := 0
yyoct:
	for {
		switch (yystate) {
		case 0:
			yych = str[cursor]
			cursor += 1
			switch (yych) {
			case 0x00:
				yystate = 1
				continue yyoct
			case '0','1','2','3','4','5','6','7':
				yystate = 3
				continue yyoct
			default:
				yystate = 2
				continue yyoct
			}
		case 1:
			{ goto end }
		case 2:
			{ goto err }
		case 3:
			{ add_digit(8, '0'); goto oct }
		default:
			panic("internal lexer error")
		}
	}
}

dec:
	
{
	var yych byte
	yystate := 0
yydec:
	for {
		switch (yystate) {
		case 0:
			yych = str[cursor]
			cursor += 1
			switch (yych) {
			case 0x00:
				yystate = 1
				continue yydec
			case '0','1','2','3','4','5','6','7','8','9':
				yystate = 3
				continue yydec
			default:
				yystate = 2
				continue yydec
			}
		case 1:
			{ goto end }
		case 2:
			{ goto err }
		case 3:
			{ add_digit(10, '0'); goto dec }
		default:
			panic("internal lexer error")
		}
	}
}

hex:
	
{
	var yych byte
	yystate := 0
yyhex:
	for {
		switch (yystate) {
		case 0:
			yych = str[cursor]
			cursor += 1
			switch (yych) {
			case 0x00:
				yystate = 1
				continue yyhex
			case '0','1','2','3','4','5','6','7','8','9':
				yystate = 3
				continue yyhex
			case 'A','B','C','D','E','F':
				yystate = 4
				continue yyhex
			case 'a','b','c','d','e','f':
				yystate = 5
				continue yyhex
			default:
				yystate = 2
				continue yyhex
			}
		case 1:
			{ goto end }
		case 2:
			{ goto err }
		case 3:
			{ add_digit(16, '0');    goto hex }
		case 4:
			{ add_digit(16, 'A'-10); goto hex }
		case 5:
			{ add_digit(16, 'a'-10); goto hex }
		default:
			panic("internal lexer error")
		}
	}
}

end:
	if result < u32Limit {
		return uint32(result), nil
	} else {
		return 0, eOverflow
	}
err:
	return 0, eSyntax
}

func TestLex(t *testing.T) {
	var tests = []struct {
		num uint32
		str string
		err error
	}{
		{1234567890, "1234567890\000", nil},
		{13, "0b1101\000", nil},
		{0x7fe, "0x007Fe\000", nil},
		{0644, "0644\000", nil},
		{0, "9999999999\000", eOverflow},
		{0, "123??\000", eSyntax},
	}

	for _, x := range tests {
		t.Run(x.str, func(t *testing.T) {
			num, err := parse_u32(x.str)
			if !(num == x.num && err == x.err) {
				t.Errorf("got %d, want %d", num, x.num)
			}
		})
	}
}
