; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=msp430-- < %s | FileCheck %s

; Check the following conversion in TargetLowering::SimplifySetCC
; (X & 8) != 0  -->  (X & 8) >> 3
define i16 @testSimplifySetCC_0(i16 %x) {
; CHECK-LABEL: testSimplifySetCC_0:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:    bit #32, r12
; CHECK-NEXT:    mov r2, r12
; CHECK-NEXT:    and #1, r12
; CHECK-NEXT:    ret
entry:
  %and = and i16 %x, 32
  %cmp = icmp ne i16 %and, 0
  %conv = zext i1 %cmp to i16
  ret i16 %conv
}

; Check the following conversion in TargetLowering::SimplifySetCC
; (X & 8) == 8  -->  (X & 8) >> 3
define i16 @testSimplifySetCC_1(i16 %x) {
; CHECK-LABEL: testSimplifySetCC_1:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:    bit #32, r12
; CHECK-NEXT:    mov r2, r12
; CHECK-NEXT:    and #1, r12
; CHECK-NEXT:    ret
entry:
  %and = and i16 %x, 32
  %cmp = icmp eq i16 %and, 32
  %conv = zext i1 %cmp to i16
  ret i16 %conv
}

; Check the following conversion in DAGCombiner::SimplifySelectCC
; (select_cc seteq (and x, y), 0, 0, A) -> (and (shr (shl x)) A)
define i16 @testSimplifySelectCC_0(i16 %x, i16 %a) {
; CHECK-LABEL: testSimplifySelectCC_0:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:    mov r12, r14
; CHECK-NEXT:    clr r12
; CHECK-NEXT:    bit #2048, r14
; CHECK-NEXT:    jeq .LBB2_2
; CHECK-NEXT:  ; %bb.1: ; %entry
; CHECK-NEXT:    mov r13, r12
; CHECK-NEXT:  .LBB2_2: ; %entry
; CHECK-NEXT:    ret
entry:
  %and = and i16 %x, 2048
  %cmp = icmp eq i16 %and, 0
  %cond = select i1 %cmp, i16 0, i16 %a
  ret i16 %cond
}

; Check the following conversion in DAGCombiner foldExtendedSignBitTest
; sext i1 (setgt iN X, -1) --> sra (not X), (N - 1)
define i16 @testExtendSignBit_0(i16 %x) {
; CHECK-LABEL: testExtendSignBit_0:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:    mov r12, r13
; CHECK-NEXT:    mov #-1, r12
; CHECK-NEXT:    tst r13
; CHECK-NEXT:    jge .LBB3_2
; CHECK-NEXT:  ; %bb.1: ; %entry
; CHECK-NEXT:    clr r12
; CHECK-NEXT:  .LBB3_2: ; %entry
; CHECK-NEXT:    ret
entry:
  %cmp = icmp sgt i16 %x, -1
  %cond = sext i1 %cmp to i16
  ret i16 %cond
}

; Check the following conversion in DAGCombiner foldExtendedSignBitTest
; zext i1 (setgt iN X, -1) --> srl (not X), (N - 1)
define i16 @testExtendSignBit_1(i16 %x) {
; CHECK-LABEL: testExtendSignBit_1:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:    mov r12, r13
; CHECK-NEXT:    mov #1, r12
; CHECK-NEXT:    tst r13
; CHECK-NEXT:    jge .LBB4_2
; CHECK-NEXT:  ; %bb.1: ; %entry
; CHECK-NEXT:    clr r12
; CHECK-NEXT:  .LBB4_2: ; %entry
; CHECK-NEXT:    ret
entry:
  %cmp = icmp sgt i16 %x, -1
  %cond = zext i1 %cmp to i16
  ret i16 %cond
}

; Check the following conversion in DAGCombiner::foldSelectCCToShiftAnd
; select_cc setlt X, 0, A, 0 -> and (sra X, size(X)-1), A
define i16 @testShiftAnd_0(i16 %x, i16 %a) {
; CHECK-LABEL: testShiftAnd_0:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:    tst r12
; CHECK-NEXT:    jl .LBB5_2
; CHECK-NEXT:  ; %bb.1: ; %entry
; CHECK-NEXT:    clr r13
; CHECK-NEXT:  .LBB5_2: ; %entry
; CHECK-NEXT:    mov r13, r12
; CHECK-NEXT:    ret
entry:
  %cmp = icmp slt i16 %x, 0
  %cond = select i1 %cmp, i16 %a, i16 0
  ret i16 %cond
}

; Check the following conversion in DAGCombiner::foldSelectCCToShiftAnd
; select_cc setlt X, 0, A, 0 -> "and (srl X, C2), A" iff A is a single-bit
define i16 @testShiftAnd_1(i16 %x) {
; CHECK-LABEL: testShiftAnd_1:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:    mov r12, r13
; CHECK-NEXT:    mov #2, r12
; CHECK-NEXT:    tst r13
; CHECK-NEXT:    jl .LBB6_2
; CHECK-NEXT:  ; %bb.1: ; %entry
; CHECK-NEXT:    clr r12
; CHECK-NEXT:  .LBB6_2: ; %entry
; CHECK-NEXT:    ret
entry:
  %cmp = icmp slt i16 %x, 0
  %cond = select i1 %cmp, i16 2, i16 0
  ret i16 %cond
}

; Check the following conversion in DAGCombiner::SimplifySelectCC
; select C, 16, 0 -> shl C, 4
define i16 @testSimplifySelectCC_1(i16 %a, i16 %b) {
; CHECK-LABEL: testSimplifySelectCC_1:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:    mov r12, r14
; CHECK-NEXT:    mov #32, r12
; CHECK-NEXT:    cmp r14, r13
; CHECK-NEXT:    jl .LBB7_2
; CHECK-NEXT:  ; %bb.1: ; %entry
; CHECK-NEXT:    clr r12
; CHECK-NEXT:  .LBB7_2: ; %entry
; CHECK-NEXT:    ret
entry:
  %cmp = icmp sgt i16 %a, %b
  %cond = select i1 %cmp, i16 32, i16 0
  ret i16 %cond
}

; Check the following conversion in TargetLowering::SimplifySetCC
; (X & 8) != 0  -->  (X & 8) >> 3
define i16 @testSimplifySetCC_0_sh8(i16 %x) {
; CHECK-LABEL: testSimplifySetCC_0_sh8:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:    and #256, r12
; CHECK-NEXT:    swpb r12
; CHECK-NEXT:    ret
entry:
  %and = and i16 %x, 256
  %cmp = icmp ne i16 %and, 0
  %conv = zext i1 %cmp to i16
  ret i16 %conv
}

; Check the following conversion in TargetLowering::SimplifySetCC
; (X & 8) == 8  -->  (X & 8) >> 3
define i16 @testSimplifySetCC_1_sh8(i16 %x) {
; CHECK-LABEL: testSimplifySetCC_1_sh8:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:    and #256, r12
; CHECK-NEXT:    swpb r12
; CHECK-NEXT:    ret
entry:
  %and = and i16 %x, 256
  %cmp = icmp eq i16 %and, 256
  %conv = zext i1 %cmp to i16
  ret i16 %conv
}

; Check the following conversion in DAGCombiner::foldSelectCCToShiftAnd
; select_cc setlt X, 0, A, 0 -> "and (srl X, C2), A" iff A is a single-bit
define i16 @testShiftAnd_1_sh8(i16 %x) {
; CHECK-LABEL: testShiftAnd_1_sh8:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:    swpb r12
; CHECK-NEXT:    and #128, r12
; CHECK-NEXT:    ret
entry:
  %cmp = icmp slt i16 %x, 0
  %cond = select i1 %cmp, i16 128, i16 0
  ret i16 %cond
}

; Check the following conversion in DAGCombiner::foldSelectCCToShiftAnd
; select_cc setlt X, 0, A, 0 -> "and (srl X, C2), A" iff A is a single-bit
define i16 @testShiftAnd_1_sh9(i16 %x) {
; CHECK-LABEL: testShiftAnd_1_sh9:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:    swpb r12
; CHECK-NEXT:    mov.b r12, r12
; CHECK-NEXT:    clrc
; CHECK-NEXT:    rrc r12
; CHECK-NEXT:    and #64, r12
; CHECK-NEXT:    ret
entry:
  %cmp = icmp slt i16 %x, 0
  %cond = select i1 %cmp, i16 64, i16 0
  ret i16 %cond
}
