; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -disable-peephole -mtriple=i386-apple-darwin -mattr=+crc32 -show-mc-encoding | FileCheck %s --check-prefixes=X86
; RUN: llc < %s -disable-peephole -mtriple=x86_64-apple-darwin -mattr=+crc32 -show-mc-encoding | FileCheck %s --check-prefixes=X64
; RUN: llc < %s -disable-peephole -mtriple=x86_64-apple-darwin -mattr=+crc32,+egpr -show-mc-encoding | FileCheck %s --check-prefixes=EGPR

define i32 @crc32_32_8(i32 %a, i8 %b) nounwind {
; X86-LABEL: crc32_32_8:
; X86:       ## %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax ## encoding: [0x8b,0x44,0x24,0x04]
; X86-NEXT:    crc32b {{[0-9]+}}(%esp), %eax ## encoding: [0xf2,0x0f,0x38,0xf0,0x44,0x24,0x08]
; X86-NEXT:    retl ## encoding: [0xc3]
;
; X64-LABEL: crc32_32_8:
; X64:       ## %bb.0:
; X64-NEXT:    movl %edi, %eax ## encoding: [0x89,0xf8]
; X64-NEXT:    crc32b %sil, %eax ## encoding: [0xf2,0x40,0x0f,0x38,0xf0,0xc6]
; X64-NEXT:    retq ## encoding: [0xc3]
;
; EGPR-LABEL: crc32_32_8:
; EGPR:       ## %bb.0:
; EGPR-NEXT:    movl %edi, %eax ## encoding: [0x89,0xf8]
; EGPR-NEXT:    crc32b %sil, %eax ## EVEX TO LEGACY Compression encoding: [0xf2,0x40,0x0f,0x38,0xf0,0xc6]
; EGPR-NEXT:    retq ## encoding: [0xc3]
  %tmp = call i32 @llvm.x86.sse42.crc32.32.8(i32 %a, i8 %b)
  ret i32 %tmp
}
declare i32 @llvm.x86.sse42.crc32.32.8(i32, i8) nounwind

define i32 @crc32_32_16(i32 %a, i16 %b) nounwind {
; X86-LABEL: crc32_32_16:
; X86:       ## %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax ## encoding: [0x8b,0x44,0x24,0x04]
; X86-NEXT:    crc32w {{[0-9]+}}(%esp), %eax ## encoding: [0x66,0xf2,0x0f,0x38,0xf1,0x44,0x24,0x08]
; X86-NEXT:    retl ## encoding: [0xc3]
;
; X64-LABEL: crc32_32_16:
; X64:       ## %bb.0:
; X64-NEXT:    movl %edi, %eax ## encoding: [0x89,0xf8]
; X64-NEXT:    crc32w %si, %eax ## encoding: [0x66,0xf2,0x0f,0x38,0xf1,0xc6]
; X64-NEXT:    retq ## encoding: [0xc3]
;
; EGPR-LABEL: crc32_32_16:
; EGPR:       ## %bb.0:
; EGPR-NEXT:    movl %edi, %eax ## encoding: [0x89,0xf8]
; EGPR-NEXT:    crc32w %si, %eax ## EVEX TO LEGACY Compression encoding: [0x66,0xf2,0x0f,0x38,0xf1,0xc6]
; EGPR-NEXT:    retq ## encoding: [0xc3]
  %tmp = call i32 @llvm.x86.sse42.crc32.32.16(i32 %a, i16 %b)
  ret i32 %tmp
}
declare i32 @llvm.x86.sse42.crc32.32.16(i32, i16) nounwind

define i32 @crc32_32_32(i32 %a, i32 %b) nounwind {
; X86-LABEL: crc32_32_32:
; X86:       ## %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax ## encoding: [0x8b,0x44,0x24,0x04]
; X86-NEXT:    crc32l {{[0-9]+}}(%esp), %eax ## encoding: [0xf2,0x0f,0x38,0xf1,0x44,0x24,0x08]
; X86-NEXT:    retl ## encoding: [0xc3]
;
; X64-LABEL: crc32_32_32:
; X64:       ## %bb.0:
; X64-NEXT:    movl %edi, %eax ## encoding: [0x89,0xf8]
; X64-NEXT:    crc32l %esi, %eax ## encoding: [0xf2,0x0f,0x38,0xf1,0xc6]
; X64-NEXT:    retq ## encoding: [0xc3]
;
; EGPR-LABEL: crc32_32_32:
; EGPR:       ## %bb.0:
; EGPR-NEXT:    movl %edi, %eax ## encoding: [0x89,0xf8]
; EGPR-NEXT:    crc32l %esi, %eax ## EVEX TO LEGACY Compression encoding: [0xf2,0x0f,0x38,0xf1,0xc6]
; EGPR-NEXT:    retq ## encoding: [0xc3]
  %tmp = call i32 @llvm.x86.sse42.crc32.32.32(i32 %a, i32 %b)
  ret i32 %tmp
}
declare i32 @llvm.x86.sse42.crc32.32.32(i32, i32) nounwind
