/*
 * Decompiled with CFR 0.152.
 */
package com.nexwave.nquindexer;

import com.nexwave.nsidita.BlankRemover;
import com.nexwave.nsidita.DocFileInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class SaxDocFileParser
extends DefaultHandler {
    protected DocFileInfo fileDesc = null;
    protected String projectDir = null;
    protected StringBuffer strbf = null;
    private String currentElName = "";
    private StringBuffer tempVal = null;
    private boolean shortdescBool = false;
    private int shortTagCpt = 0;
    Stack<String> stack = new Stack();
    private boolean addContent = false;
    private boolean addHeaderInfo = false;
    private boolean doNotIndex = false;
    private int divCount = 0;

    public int init(String string) {
        return 0;
    }

    public DocFileInfo runExtractData(File file) {
        this.fileDesc = new DocFileInfo(file);
        this.strbf = new StringBuffer("");
        this.parseDocument(file);
        return this.fileDesc;
    }

    public void parseDocument(File file) {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(false);
        this.addContent = false;
        this.divCount = 0;
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.getXMLReader().setFeature("http://xml.org/sax/features/external-general-entities", false);
            long l = System.currentTimeMillis();
            String string = this.RemoveValidationPI(file);
            if (string != null) {
                InputSource inputSource = new InputSource(new StringReader(string));
                inputSource.setSystemId(file.toURI().toURL().toString());
                sAXParser.parse(inputSource, (DefaultHandler)this);
            }
            long l2 = System.currentTimeMillis();
        }
        catch (SAXParseException sAXParseException) {
            System.out.println("SaxParseException: The indexing file contains incorrect xml syntax.");
            sAXParseException.printStackTrace();
        }
        catch (SAXException sAXException) {
            System.out.println("SaxException. You may need to include Xerces in your classpath. See documentation for details");
            sAXException.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        Object object;
        String string4;
        this.stack.add(string3);
        this.currentElName = string3;
        if (string3.equalsIgnoreCase("meta")) {
            this.addHeaderInfo = true;
            string4 = attributes.getValue("name");
            if (string4 != null && (string4.equalsIgnoreCase("keywords") || string4.equalsIgnoreCase("description") || string4.equalsIgnoreCase("indexterms"))) {
                if (string4.equalsIgnoreCase("keywords")) {
                    object = attributes.getValue("content").split(", ");
                    for (String string5 : object) {
                        this.strbf.append(" ").append(string5).append("@@@elem_meta_keywords@@@ ");
                    }
                } else if (string4.equalsIgnoreCase("indexterms")) {
                    object = attributes.getValue("content").split(", ");
                    for (String string6 : object) {
                        this.strbf.append(" ").append(string6).append("@@@elem_meta_indexterms@@@ ");
                    }
                } else {
                    this.strbf.append(" ").append(attributes.getValue("content")).append(" ");
                }
            }
            if (string4 != null && string4.equalsIgnoreCase("description")) {
                this.fileDesc.setShortdesc(BlankRemover.rmWhiteSpace(attributes.getValue("content").replace('\n', ' ')));
            }
            if (string4 != null && string4.equalsIgnoreCase("Section-Title")) {
                this.fileDesc.setTitle(BlankRemover.rmWhiteSpace(attributes.getValue("content").replace('\n', ' ')));
            }
        }
        if (string3.equalsIgnoreCase("title") || string3.equalsIgnoreCase("shortdesc")) {
            this.tempVal = new StringBuffer();
        }
        this.addHeaderInfo = string3.equalsIgnoreCase("meta") || string3.equalsIgnoreCase("title") || string3.equalsIgnoreCase("shortdesc");
        string4 = attributes.getValue("id");
        if ("content".equals(string4)) {
            this.addContent = true;
        }
        if (this.addContent) {
            if (string3.equalsIgnoreCase("div")) {
                ++this.divCount;
            }
            if (string3.equalsIgnoreCase("div") || string3.equalsIgnoreCase("p") || string3.equalsIgnoreCase("span")) {
                object = attributes.getValue("class");
                if (object != null && (((String)object).equalsIgnoreCase("shortdesc") || ((String)object).equalsIgnoreCase("summary"))) {
                    this.shortdescBool = true;
                }
                this.tempVal = new StringBuffer();
                this.strbf.append(" ");
            }
            if (this.shortdescBool) {
                ++this.shortTagCpt;
            }
            this.doNotIndex = (object = attributes.getValue("accesskey")) != null && ("n".equals(object) || "p".equals(object) || "h".equals(object));
        }
        this.strbf.append(" ");
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if ((this.addContent || this.addHeaderInfo) && !this.doNotIndex && !this.currentElName.equalsIgnoreCase("script")) {
            String string = new String(cArray, n, n2);
            String string2 = string.replaceAll("\\s+", " ");
            string = string.trim();
            string = this.minimalClean(string, null, null);
            string = string.replaceAll("\\s+", " ");
            String string3 = "@@@elem_" + this.stack.peek() + "@@@ ";
            Matcher matcher = Pattern.compile("(\\w|-|:)+").matcher(string);
            if (string.trim().length() > 0 && matcher.find()) {
                String string4 = new String(string2);
                string = this.duplicateWords(string4, string, "-");
                string4 = new String(string2);
                string = this.duplicateWords(string4, string, ":");
                string4 = new String(string2);
                string = this.duplicateWords(string4, string, ".");
                string = string.replace(" ", string3);
                string = string + string3;
            }
            this.strbf.append(string);
            if (this.tempVal != null) {
                this.tempVal.append(string2);
            }
        }
    }

    private String duplicateWords(String string, String string2, String string3) {
        int n = string.indexOf(string3);
        while (n >= 0) {
            String[] stringArray;
            int n2 = string.indexOf(" ", n);
            String string4 = null;
            if (n2 >= 0) {
                string4 = string.substring(0, n2);
                string = string.substring(n2);
            } else {
                string4 = string;
                string = "";
            }
            int n3 = string4.lastIndexOf(" ");
            if (n3 >= 0) {
                string4 = string4.substring(n3 + 1);
            }
            if (string3.indexOf(".") >= 0) {
                string3 = string3.replaceAll("\\.", "\\\\.");
            }
            for (String string5 : stringArray = string4.split(string3)) {
                string2 = string2 + " " + string5;
            }
            n = string.indexOf(string3);
        }
        return string2;
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        this.stack.pop();
        if (this.shortdescBool) {
            --this.shortTagCpt;
            if (this.shortTagCpt == 0) {
                String string4 = this.tempVal.toString().replace('\n', ' ');
                if (string4.trim().length() > 0) {
                    this.fileDesc.setShortdesc(BlankRemover.rmWhiteSpace(string4));
                }
                this.tempVal = null;
                this.shortdescBool = false;
            }
        }
        if (string3.equalsIgnoreCase("div") && this.addContent) {
            --this.divCount;
            if (this.divCount == 0) {
                this.addContent = false;
            }
        }
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
    }

    @Override
    public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
        return null;
    }

    public String RemoveValidationPI(File file) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            while (true) {
                boolean bl = true;
                try {
                    String string = bufferedReader.readLine();
                    if (string == null) break;
                    if (!(string = string.replaceAll("\\x26nbsp\\x3B", "&#160;")).contains("<!DOCTYPE html PUBLIC")) {
                        if (string.contains("<?xml version")) {
                            string = string.replaceAll("\\x3C\\x3Fxml[^\\x3E]*\\x3F\\x3E", "\n");
                        }
                        stringBuilder.append(string).append("\n");
                        continue;
                    }
                    int n = string.indexOf("<!DOCTYPE");
                    int n2 = string.indexOf(">", n);
                    while (n2 < 0) {
                        string = string.concat(bufferedReader.readLine());
                        n2 = string.indexOf(">", n);
                    }
                    String string2 = string.substring(n, n2);
                    if (string.contains("<?xml version")) {
                        string = string.replaceAll("\\x3C\\x3Fxml[^\\x3E]*\\x3F\\x3E", "\n");
                    }
                    string = string.replaceAll("\\x3C\\x21DOCTYPE[^\\x3E]*\\x3E", "\n");
                    stringBuilder.append(string);
                }
                catch (IOException iOException) {
                    break;
                }
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            return null;
        }
        return stringBuilder.toString();
    }

    protected String minimalClean(String string, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        String string2 = null;
        if (stringBuffer2 != null) {
            string2 = new String(stringBuffer2);
        }
        string = string.replaceAll("\\s+", " ");
        string = string.replaceAll("->", " ");
        string = string.replaceAll("[$|%,;'()\\/*\"{}=!&+<>#\\?]|\\[|\\]|[-][-]+", " ");
        string = string.replaceAll("[$,;'()\\/*\"{}=!&+<>\\\\]", " ");
        string = string.replaceAll("\\u3000|\\u3001|\\u3002|\\u3003|\\u3008|\\u3009|\\u300C|\\u300D", " ");
        string = string.replaceAll("\\u3013|\\u3014|\\u3015|\\u301C|\\u301D|\\u301E|\\u301F", " ");
        string = string.replaceAll("\\u3013|\\u300C|\\u300D", " ");
        if (string2 != null && string2.length() > 0) {
            string = string.replaceAll(string2, " ");
        }
        if (stringBuffer != null) {
            string = string.replaceAll(stringBuffer.toString(), " ");
        }
        string = string.replaceAll("[$|%,;'()\\/*\"{}=!&+<>#\\?]|\\[|\\]|[-][-]+", " ");
        string = string.replaceAll("[$,;'()\\/*\"{}=!&+<>\\\\]", " ");
        string = string.replaceAll("\\u3000|\\u3001|\\u3002|\\u3003|\\u3008|\\u3009|\\u300C|\\u300D", " ");
        string = string.replaceAll("\\u3013|\\u3014|\\u3015|\\u301C|\\u301D|\\u301E|\\u301F", " ");
        string = string.replaceAll("\\u3013|\\u300C|\\u300D", " ");
        if (string2 != null && string2.length() > 0) {
            string = string.replaceAll(string2, " ");
        }
        return string;
    }
}

