/**************************************************************************************/
/*                                                                                    */
/*  Visualization Library                                                             */
/*  http://visualizationlibrary.org                                                   */
/*                                                                                    */
/*  Copyright (c) 2005-2020, Michele Bosi                                             */
/*  All rights reserved.                                                              */
/*                                                                                    */
/*  Redistribution and use in source and binary forms, with or without modification,  */
/*  are permitted provided that the following conditions are met:                     */
/*                                                                                    */
/*  - Redistributions of source code must retain the above copyright notice, this     */
/*  list of conditions and the following disclaimer.                                  */
/*                                                                                    */
/*  - Redistributions in binary form must reproduce the above copyright notice, this  */
/*  list of conditions and the following disclaimer in the documentation and/or       */
/*  other materials provided with the distribution.                                   */
/*                                                                                    */
/*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND   */
/*  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED     */
/*  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE            */
/*  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR  */
/*  ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES    */
/*  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;      */
/*  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON    */
/*  ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT           */
/*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS     */
/*  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                      */
/*                                                                                    */
/**************************************************************************************/

#ifndef VLXVisitor_INCLUDE_ONCE
#define VLXVisitor_INCLUDE_ONCE

#include <vlCore/Object.hpp>
#include <set>

namespace vlX
{
  class VLXStructure;
  class VLXList;
  class VLXRawtextBlock;
  class VLXArray;
  class VLXArrayInteger;
  class VLXArrayReal;
  /*
  class VLXArrayString;
  class VLXArrayIdentifier;
  class VLXArrayID;
  */
  //-----------------------------------------------------------------------------
  /** Base class for all visitors visiting a VLX hierarchy. */
  class Visitor: public vl::Object
  {
    VL_INSTRUMENT_CLASS(vlX::Visitor, vl::Object)

  public:
    virtual void visitStructure(VLXStructure*) {}
    virtual void visitList(VLXList*) {}
    virtual void visitRawtextBlock(VLXRawtextBlock*) {}
    virtual void visitArray(VLXArrayInteger*) {}
    virtual void visitArray(VLXArrayReal*) {}
    /*
    virtual void visitArray(VLXArrayString*) {}
    virtual void visitArray(VLXArrayIdentifier*) {}
    virtual void visitArray(VLXArrayID*) {}
    */

    bool isVisited(void* node)
    {
      std::set< void* >::iterator it = mVisited.find(node);
      if (it == mVisited.end())
      {
        mVisited.insert(node);
        return false;
      }
      else
        return true;
    }

    void resetVisitedNodes() { mVisited.clear(); };

  private:
    std::set< void* > mVisited;
  };
}

#endif
