#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfv.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclimitersettype_ PETSCLIMITERSETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclimitersettype_ petsclimitersettype
#endif
PETSC_EXTERN void petsclimitersettype_(PetscLimiter *a, char * b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = PetscLimiterSetType(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfv.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclimitergettype_ PETSCLIMITERGETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclimitergettype_ petsclimitergettype
#endif
PETSC_EXTERN void petsclimitergettype_(PetscLimiter *a, char * b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = PetscLimiterGetType(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfv.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclimiterviewfromoptions_ PETSCLIMITERVIEWFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclimiterviewfromoptions_ petsclimiterviewfromoptions
#endif
PETSC_EXTERN void petsclimiterviewfromoptions_(PetscLimiter *a, PetscObject *b, char c[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  *ierr = PetscLimiterViewFromOptions(*a, *b, c_c);
  if (*ierr) return;
  FREECHAR(c, c_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfv.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclimiterview_ PETSCLIMITERVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclimiterview_ petsclimiterview
#endif
PETSC_EXTERN void petsclimiterview_(PetscLimiter *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = PetscLimiterView(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfv.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclimitersetfromoptions_ PETSCLIMITERSETFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclimitersetfromoptions_ petsclimitersetfromoptions
#endif
PETSC_EXTERN void petsclimitersetfromoptions_(PetscLimiter *a, PetscErrorCode *ierr)
{
  *ierr = PetscLimiterSetFromOptions(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfv.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclimitersetup_ PETSCLIMITERSETUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclimitersetup_ petsclimitersetup
#endif
PETSC_EXTERN void petsclimitersetup_(PetscLimiter *a, PetscErrorCode *ierr)
{
  *ierr = PetscLimiterSetUp(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfv.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclimiterdestroy_ PETSCLIMITERDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclimiterdestroy_ petsclimiterdestroy
#endif
PETSC_EXTERN void petsclimiterdestroy_(PetscLimiter *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = PetscLimiterDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfv.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclimitercreate_ PETSCLIMITERCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclimitercreate_ petsclimitercreate
#endif
PETSC_EXTERN void petsclimitercreate_(MPI_Fint *a, PetscLimiter *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(b);
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscLimiterCreate(MPI_Comm_f2c(*(a)), b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfv.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclimiterlimit_ PETSCLIMITERLIMIT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclimiterlimit_ petsclimiterlimit
#endif
PETSC_EXTERN void petsclimiterlimit_(PetscLimiter *a, PetscReal *b, PetscReal *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(c);
  *ierr = PetscLimiterLimit(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfv.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfvsettype_ PETSCFVSETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfvsettype_ petscfvsettype
#endif
PETSC_EXTERN void petscfvsettype_(PetscFV *a, char * b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = PetscFVSetType(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfv.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfvgettype_ PETSCFVGETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfvgettype_ petscfvgettype
#endif
PETSC_EXTERN void petscfvgettype_(PetscFV *a, char * b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = PetscFVGetType(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfv.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfvviewfromoptions_ PETSCFVVIEWFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfvviewfromoptions_ petscfvviewfromoptions
#endif
PETSC_EXTERN void petscfvviewfromoptions_(PetscFV *a, PetscObject *b, char c[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  *ierr = PetscFVViewFromOptions(*a, *b, c_c);
  if (*ierr) return;
  FREECHAR(c, c_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfv.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfvview_ PETSCFVVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfvview_ petscfvview
#endif
PETSC_EXTERN void petscfvview_(PetscFV *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = PetscFVView(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfv.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfvsetfromoptions_ PETSCFVSETFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfvsetfromoptions_ petscfvsetfromoptions
#endif
PETSC_EXTERN void petscfvsetfromoptions_(PetscFV *a, PetscErrorCode *ierr)
{
  *ierr = PetscFVSetFromOptions(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfv.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfvsetup_ PETSCFVSETUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfvsetup_ petscfvsetup
#endif
PETSC_EXTERN void petscfvsetup_(PetscFV *a, PetscErrorCode *ierr)
{
  *ierr = PetscFVSetUp(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfv.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfvdestroy_ PETSCFVDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfvdestroy_ petscfvdestroy
#endif
PETSC_EXTERN void petscfvdestroy_(PetscFV *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = PetscFVDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfv.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfvcreate_ PETSCFVCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfvcreate_ petscfvcreate
#endif
PETSC_EXTERN void petscfvcreate_(MPI_Fint *a, PetscFV *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(b);
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscFVCreate(MPI_Comm_f2c(*(a)), b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfv.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfvsetlimiter_ PETSCFVSETLIMITER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfvsetlimiter_ petscfvsetlimiter
#endif
PETSC_EXTERN void petscfvsetlimiter_(PetscFV *a, PetscLimiter *b, PetscErrorCode *ierr)
{
  *ierr = PetscFVSetLimiter(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfv.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfvgetlimiter_ PETSCFVGETLIMITER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfvgetlimiter_ petscfvgetlimiter
#endif
PETSC_EXTERN void petscfvgetlimiter_(PetscFV *a, PetscLimiter *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscFVGetLimiter(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfv.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfvsetnumcomponents_ PETSCFVSETNUMCOMPONENTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfvsetnumcomponents_ petscfvsetnumcomponents
#endif
PETSC_EXTERN void petscfvsetnumcomponents_(PetscFV *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = PetscFVSetNumComponents(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfv.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfvgetnumcomponents_ PETSCFVGETNUMCOMPONENTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfvgetnumcomponents_ petscfvgetnumcomponents
#endif
PETSC_EXTERN void petscfvgetnumcomponents_(PetscFV *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = PetscFVGetNumComponents(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfv.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfvsetcomponentname_ PETSCFVSETCOMPONENTNAME
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfvsetcomponentname_ petscfvsetcomponentname
#endif
PETSC_EXTERN void petscfvsetcomponentname_(PetscFV *a, PetscInt *b, char c[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  *ierr = PetscFVSetComponentName(*a, *b, c_c);
  if (*ierr) return;
  FREECHAR(c, c_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfv.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfvgetcomponentname_ PETSCFVGETCOMPONENTNAME
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfvgetcomponentname_ petscfvgetcomponentname
#endif
PETSC_EXTERN void petscfvgetcomponentname_(PetscFV *a, PetscInt *b, char c[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_c = PETSC_NULLPTR;
  *ierr = PetscFVGetComponentName(*a, *b, (const char **)&c_c);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)c, c_c, l_c);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, c, l_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfv.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfvsetspatialdimension_ PETSCFVSETSPATIALDIMENSION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfvsetspatialdimension_ petscfvsetspatialdimension
#endif
PETSC_EXTERN void petscfvsetspatialdimension_(PetscFV *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = PetscFVSetSpatialDimension(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfv.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfvgetspatialdimension_ PETSCFVGETSPATIALDIMENSION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfvgetspatialdimension_ petscfvgetspatialdimension
#endif
PETSC_EXTERN void petscfvgetspatialdimension_(PetscFV *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = PetscFVGetSpatialDimension(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfv.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfvsetcomputegradients_ PETSCFVSETCOMPUTEGRADIENTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfvsetcomputegradients_ petscfvsetcomputegradients
#endif
PETSC_EXTERN void petscfvsetcomputegradients_(PetscFV *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PetscFVSetComputeGradients(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfv.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfvgetcomputegradients_ PETSCFVGETCOMPUTEGRADIENTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfvgetcomputegradients_ petscfvgetcomputegradients
#endif
PETSC_EXTERN void petscfvgetcomputegradients_(PetscFV *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = PetscFVGetComputeGradients(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfv.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfvsetquadrature_ PETSCFVSETQUADRATURE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfvsetquadrature_ petscfvsetquadrature
#endif
PETSC_EXTERN void petscfvsetquadrature_(PetscFV *a, PetscQuadrature *b, PetscErrorCode *ierr)
{
  *ierr = PetscFVSetQuadrature(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfv.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfvgetquadrature_ PETSCFVGETQUADRATURE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfvgetquadrature_ petscfvgetquadrature
#endif
PETSC_EXTERN void petscfvgetquadrature_(PetscFV *a, PetscQuadrature *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscFVGetQuadrature(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfv.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfvcreatedualspace_ PETSCFVCREATEDUALSPACE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfvcreatedualspace_ petscfvcreatedualspace
#endif
PETSC_EXTERN void petscfvcreatedualspace_(PetscFV *a, DMPolytopeType *b, PetscErrorCode *ierr)
{
  *ierr = PetscFVCreateDualSpace(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfv.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfvgetdualspace_ PETSCFVGETDUALSPACE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfvgetdualspace_ petscfvgetdualspace
#endif
PETSC_EXTERN void petscfvgetdualspace_(PetscFV *a, PetscDualSpace *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscFVGetDualSpace(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfv.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfvsetdualspace_ PETSCFVSETDUALSPACE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfvsetdualspace_ petscfvsetdualspace
#endif
PETSC_EXTERN void petscfvsetdualspace_(PetscFV *a, PetscDualSpace *b, PetscErrorCode *ierr)
{
  *ierr = PetscFVSetDualSpace(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfv.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfvgetcelltabulation_ PETSCFVGETCELLTABULATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfvgetcelltabulation_ petscfvgetcelltabulation
#endif
PETSC_EXTERN void petscfvgetcelltabulation_(PetscFV *a, PetscTabulation *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscFVGetCellTabulation(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfv.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfvcreatetabulation_ PETSCFVCREATETABULATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfvcreatetabulation_ petscfvcreatetabulation
#endif
PETSC_EXTERN void petscfvcreatetabulation_(PetscFV *a, PetscInt *b, PetscInt *c, const PetscReal d[], PetscInt *e, PetscTabulation *f, PetscErrorCode *ierr)
{
  PetscBool null_f = !*(void**) f ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLREAL(d);
  CHKFORTRANNULLOBJECT(f);
  *ierr = PetscFVCreateTabulation(*a, *b, *c, d, *e, f);
  if (*ierr) return;
  if (! null_f && !*(void**) f) *(void **) f = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfv.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfvcomputegradient_ PETSCFVCOMPUTEGRADIENT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfvcomputegradient_ petscfvcomputegradient
#endif
PETSC_EXTERN void petscfvcomputegradient_(PetscFV *a, PetscInt *b, PetscScalar c[], PetscScalar d[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(c);
  CHKFORTRANNULLSCALAR(d);
  *ierr = PetscFVComputeGradient(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfv.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfvintegraterhsfunction_ PETSCFVINTEGRATERHSFUNCTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfvintegraterhsfunction_ petscfvintegraterhsfunction
#endif
PETSC_EXTERN void petscfvintegraterhsfunction_(PetscFV *a, PetscDS *b, PetscInt *c, PetscInt *d, PetscFVFaceGeom *e, PetscReal *f, PetscScalar g[], PetscScalar h[], PetscScalar i[], PetscScalar j[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(f);
  CHKFORTRANNULLSCALAR(g);
  CHKFORTRANNULLSCALAR(h);
  CHKFORTRANNULLSCALAR(i);
  CHKFORTRANNULLSCALAR(j);
  *ierr = PetscFVIntegrateRHSFunction(*a, *b, *c, *d, e, f, g, h, i, j);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfv.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfvclone_ PETSCFVCLONE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfvclone_ petscfvclone
#endif
PETSC_EXTERN void petscfvclone_(PetscFV *a, PetscFV *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscFVClone(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfv.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfvrefine_ PETSCFVREFINE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfvrefine_ petscfvrefine
#endif
PETSC_EXTERN void petscfvrefine_(PetscFV *a, PetscFV *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscFVRefine(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfv.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfvleastsquaressetmaxfaces_ PETSCFVLEASTSQUARESSETMAXFACES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfvleastsquaressetmaxfaces_ petscfvleastsquaressetmaxfaces
#endif
PETSC_EXTERN void petscfvleastsquaressetmaxfaces_(PetscFV *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = PetscFVLeastSquaresSetMaxFaces(*a, *b);
  if (*ierr) return;
}
