#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscinfoenabled_ PETSCINFOENABLED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscinfoenabled_ petscinfoenabled
#endif
PETSC_EXTERN void petscinfoenabled_(PetscClassId *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = PetscInfoEnabled(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscinfoallow_ PETSCINFOALLOW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscinfoallow_ petscinfoallow
#endif
PETSC_EXTERN void petscinfoallow_(PetscBool *a, PetscErrorCode *ierr)
{
  *ierr = PetscInfoAllow(*a ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscinfosetfile_ PETSCINFOSETFILE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscinfosetfile_ petscinfosetfile
#endif
PETSC_EXTERN void petscinfosetfile_(char a[], char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_a, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_a;
  FIXCHAR(a, l_a, c_a);
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = PetscInfoSetFile(c_a, c_b);
  if (*ierr) return;
  FREECHAR(a, c_a);
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscinfogetclass_ PETSCINFOGETCLASS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscinfogetclass_ petscinfogetclass
#endif
PETSC_EXTERN void petscinfogetclass_(char a[], PetscBool *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_a)
{
  char* c_a;
  FIXCHAR(a, l_a, c_a);
  CHKFORTRANNULLBOOL(b);
  *ierr = PetscInfoGetClass(c_a, b);
  if (*ierr) return;
  FREECHAR(a, c_a);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscinfogetinfo_ PETSCINFOGETINFO
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscinfogetinfo_ petscinfogetinfo
#endif
PETSC_EXTERN void petscinfogetinfo_(PetscBool *a, PetscBool *b, PetscBool *c, PetscBool *d, PetscInfoCommFlag *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(a);
  CHKFORTRANNULLBOOL(b);
  CHKFORTRANNULLBOOL(c);
  CHKFORTRANNULLBOOL(d);
  *ierr = PetscInfoGetInfo(a, b, c, d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscinfoprocessclass_ PETSCINFOPROCESSCLASS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscinfoprocessclass_ petscinfoprocessclass
#endif
PETSC_EXTERN void petscinfoprocessclass_(char a[], PetscInt *b, const PetscClassId c[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_a)
{
  char* c_a;
  FIXCHAR(a, l_a, c_a);
  *ierr = PetscInfoProcessClass(c_a, *b, c);
  if (*ierr) return;
  FREECHAR(a, c_a);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscinfosetfiltercommself_ PETSCINFOSETFILTERCOMMSELF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscinfosetfiltercommself_ petscinfosetfiltercommself
#endif
PETSC_EXTERN void petscinfosetfiltercommself_(PetscInfoCommFlag *a, PetscErrorCode *ierr)
{
  *ierr = PetscInfoSetFilterCommSelf(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscinfosetfromoptions_ PETSCINFOSETFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscinfosetfromoptions_ petscinfosetfromoptions
#endif
PETSC_EXTERN void petscinfosetfromoptions_(PetscOptions *a, PetscErrorCode *ierr)
{
  *ierr = PetscInfoSetFromOptions(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscinfodestroy_ PETSCINFODESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscinfodestroy_ petscinfodestroy
#endif
PETSC_EXTERN void petscinfodestroy_(PetscErrorCode *ierr)
{
  *ierr = PetscInfoDestroy();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscinfodeactivateclass_ PETSCINFODEACTIVATECLASS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscinfodeactivateclass_ petscinfodeactivateclass
#endif
PETSC_EXTERN void petscinfodeactivateclass_(PetscClassId *a, PetscErrorCode *ierr)
{
  *ierr = PetscInfoDeactivateClass(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscinfoactivateclass_ PETSCINFOACTIVATECLASS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscinfoactivateclass_ petscinfoactivateclass
#endif
PETSC_EXTERN void petscinfoactivateclass_(PetscClassId *a, PetscErrorCode *ierr)
{
  *ierr = PetscInfoActivateClass(*a);
  if (*ierr) return;
}
