#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define mathtoolgetpermutationsource_ MATHTOOLGETPERMUTATIONSOURCE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define mathtoolgetpermutationsource_ mathtoolgetpermutationsource
#endif
PETSC_EXTERN void mathtoolgetpermutationsource_(Mat *a, IS *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = MatHtoolGetPermutationSource(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define mathtoolgetpermutationtarget_ MATHTOOLGETPERMUTATIONTARGET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define mathtoolgetpermutationtarget_ mathtoolgetpermutationtarget
#endif
PETSC_EXTERN void mathtoolgetpermutationtarget_(Mat *a, IS *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = MatHtoolGetPermutationTarget(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define mathtoolusepermutation_ MATHTOOLUSEPERMUTATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define mathtoolusepermutation_ mathtoolusepermutation
#endif
PETSC_EXTERN void mathtoolusepermutation_(Mat *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = MatHtoolUsePermutation(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
