#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcreatecgnsfromfile_ DMPLEXCREATECGNSFROMFILE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcreatecgnsfromfile_ dmplexcreatecgnsfromfile
#endif
PETSC_EXTERN void dmplexcreatecgnsfromfile_(MPI_Fint *a, char b[], PetscBool *c, DM *d, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLOBJECT(d);
  *ierr = DMPlexCreateCGNSFromFile(MPI_Comm_f2c(*(a)), c_b, *c ? PETSC_TRUE : PETSC_FALSE, d);
  if (*ierr) return;
  FREECHAR(b, c_b);
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcreatecgns_ DMPLEXCREATECGNS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcreatecgns_ dmplexcreatecgns
#endif
PETSC_EXTERN void dmplexcreatecgns_(MPI_Fint *a, PetscInt *b, PetscBool *c, DM *d, PetscErrorCode *ierr)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(d);
  *ierr = DMPlexCreateCGNS(MPI_Comm_f2c(*(a)), *b, *c ? PETSC_TRUE : PETSC_FALSE, d);
  if (*ierr) return;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
