#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define veccreateseqviennacl_ VECCREATESEQVIENNACL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define veccreateseqviennacl_ veccreateseqviennacl
#endif
PETSC_EXTERN void veccreateseqviennacl_(MPI_Fint *a, PetscInt *b, Vec *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = VecCreateSeqViennaCL(MPI_Comm_f2c(*(a)), *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
