#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcreatelocalref_ MATCREATELOCALREF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcreatelocalref_ matcreatelocalref
#endif
PETSC_EXTERN void matcreatelocalref_(Mat *a, IS *b, IS *c, Mat *d, PetscErrorCode *ierr)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(d);
  *ierr = MatCreateLocalRef(*a, *b, *c, d);
  if (*ierr) return;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
