#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdevice.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdevicecontextgetcurrentcontext_ PETSCDEVICECONTEXTGETCURRENTCONTEXT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdevicecontextgetcurrentcontext_ petscdevicecontextgetcurrentcontext
#endif
PETSC_EXTERN void petscdevicecontextgetcurrentcontext_(PetscDeviceContext *a, PetscErrorCode *ierr)
{
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = PetscDeviceContextGetCurrentContext(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdevice.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdevicecontextsetcurrentcontext_ PETSCDEVICECONTEXTSETCURRENTCONTEXT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdevicecontextsetcurrentcontext_ petscdevicecontextsetcurrentcontext
#endif
PETSC_EXTERN void petscdevicecontextsetcurrentcontext_(PetscDeviceContext *a, PetscErrorCode *ierr)
{
  *ierr = PetscDeviceContextSetCurrentContext(*a);
  if (*ierr) return;
}
