#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matmpiadjcreatenonemptysubcommmat_ MATMPIADJCREATENONEMPTYSUBCOMMMAT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matmpiadjcreatenonemptysubcommmat_ matmpiadjcreatenonemptysubcommmat
#endif
PETSC_EXTERN void matmpiadjcreatenonemptysubcommmat_(Mat *a, Mat *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = MatMPIAdjCreateNonemptySubcommMat(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matmpiadjtoseq_ MATMPIADJTOSEQ
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matmpiadjtoseq_ matmpiadjtoseq
#endif
PETSC_EXTERN void matmpiadjtoseq_(Mat *a, Mat *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = MatMPIAdjToSeq(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matmpiadjtoseqrankzero_ MATMPIADJTOSEQRANKZERO
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matmpiadjtoseqrankzero_ matmpiadjtoseqrankzero
#endif
PETSC_EXTERN void matmpiadjtoseqrankzero_(Mat *a, Mat *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = MatMPIAdjToSeqRankZero(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matmpiadjsetpreallocation_ MATMPIADJSETPREALLOCATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matmpiadjsetpreallocation_ matmpiadjsetpreallocation
#endif
PETSC_EXTERN void matmpiadjsetpreallocation_(Mat *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  *ierr = MatMPIAdjSetPreallocation(*a, b, c, d);
  if (*ierr) return;
}
